/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.matrix;

import com.sri.panther.paintCommon.util.Utils;
import edu.usc.ksom.pm.panther.paint.matrix.NodeInfoForMatrix;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.gui.matrix.AnnotationMatrix;
import org.paint.gui.matrix.AnnotationMatrixModel;

public class AnnotationMatrixCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final String STR_EMPTY = "";
    public static final String STR_BRACKET_START = "(";
    public static final String STR_BRACKET_END = ")";
    public static final String STR_COMMA = ",";
    public static final String STR_COLON = ":";
    public static final String STR_ROW = "Row ";
    public static final String STR_COL = " Col ";
    public static final String STR_SPACE = " ";
    public static final String STR_HTML_START = "<HTML>";
    public static final String STR_HTML_END = "</HTML>";
    public static final String STR_HTML_BREAK = "<BR>";
    private static final Color PAINT_COLOR_EXP = Preferences.inst().getExpPaintColor();
    private static final Color PAINT_COLOR_INFER = Preferences.inst().getInferPaintColor();
    public static final Color COLOR_BASIC = new Color(155, 205, 255);
    public static final Color COLOR_CONTRAST = new Color(233, 236, 242);
    NodeInfoForMatrix nodeInfo;
    Qualifier qualifier;
    boolean selected;
    Color backgroundColor;
    String label;
    GeneNode node;
    int row;
    int column;

    public AnnotationMatrixCellRenderer() {
        this.setText(STR_EMPTY);
        this.nodeInfo = null;
        this.qualifier = null;
        this.selected = false;
        this.backgroundColor = null;
        this.label = null;
        this.node = null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(STR_EMPTY);
        this.nodeInfo = null;
        this.qualifier = null;
        this.selected = isSelected;
        this.backgroundColor = null;
        this.label = null;
        this.node = null;
        this.row = row;
        this.column = column;
        AnnotationMatrix annot_table = (AnnotationMatrix)table;
        AnnotationMatrixModel model = (AnnotationMatrixModel)table.getModel();
        this.nodeInfo = (NodeInfoForMatrix)value;
        if (null == this.nodeInfo) {
            System.out.println("Could not find cell Renderer component for row " + row + " column " + column);
            Exception e = new Exception();
            e.printStackTrace();
            return null;
        }
        this.node = this.nodeInfo.getgNode();
        if (this.node.isSelected() || annot_table.getSelectedColumn() == column) {
            this.selected = true;
        }
        this.backgroundColor = COLOR_BASIC;
        if (!model.isOdd(column)) {
            this.backgroundColor = COLOR_CONTRAST;
        }
        if (!this.nodeInfo.isExpBackground() && !this.nodeInfo.isNonExpBackground()) {
            Object tooltip = this.nodeInfo.getgTerm().getName() + STR_BRACKET_START + this.nodeInfo.getgTerm().getAcc() + STR_BRACKET_END;
            if (null == tooltip || ((String)tooltip).isEmpty()) {
                tooltip = this.nodeInfo.getgTerm().getAcc();
            }
            this.setToolTipText("<HTML>Row " + (this.row + 1) + STR_COL + (this.column + 1) + STR_SPACE + (String)tooltip + STR_HTML_END);
            return this;
        }
        if (this.nodeInfo.isExpBackground()) {
            Object termStr;
            this.backgroundColor = PAINT_COLOR_EXP;
            if (this.nodeInfo.isPaintExp()) {
                this.backgroundColor = Preferences.EXP_ANNOT_ADDED_IN_PAINT;
            }
            if (null == (termStr = this.nodeInfo.getgTerm().getName() + STR_BRACKET_START + this.nodeInfo.getgTerm().getAcc() + STR_BRACKET_END) || ((String)termStr).isEmpty()) {
                termStr = this.nodeInfo.getgTerm().getAcc();
            }
            this.setToolTipText("<HTML>Row " + (this.row + 1) + STR_COL + (this.column + 1) + STR_SPACE + this.node.getNodeLabel() + STR_BRACKET_START + this.node.getNode().getStaticInfo().getNodeAcc() + STR_SPACE + this.node.getNode().getStaticInfo().getPublicId() + ") " + (String)termStr + STR_HTML_BREAK + this.getAllQualifierInfo(this.nodeInfo, STR_HTML_BREAK) + STR_HTML_END);
            return this;
        }
        if (!this.nodeInfo.isExpBackground() && this.nodeInfo.isNonExpBackground()) {
            this.backgroundColor = PAINT_COLOR_INFER;
            Object termStr = this.nodeInfo.getgTerm().getName() + STR_BRACKET_START + this.nodeInfo.getgTerm().getAcc() + STR_BRACKET_END;
            if (null == termStr || ((String)termStr).isEmpty()) {
                termStr = this.nodeInfo.getgTerm().getAcc();
            }
            this.setToolTipText("<HTML>Row " + (this.row + 1) + STR_COL + (this.column + 1) + STR_SPACE + this.node.getNodeLabel() + STR_BRACKET_START + this.node.getNode().getStaticInfo().getNodeAcc() + STR_SPACE + this.node.getNode().getStaticInfo().getPublicId() + ") " + (String)termStr + STR_HTML_BREAK + this.getAllQualifierInfo(this.nodeInfo, STR_HTML_BREAK) + STR_HTML_END);
            return this;
        }
        return this;
    }

    private String getQualifierString(HashSet<Qualifier> qualifierSet) {
        if (null == qualifierSet || 0 == qualifierSet.size()) {
            return STR_EMPTY;
        }
        StringBuffer sb = new StringBuffer(STR_BRACKET_START);
        boolean added = false;
        Iterator<Qualifier> iter = qualifierSet.iterator();
        while (iter.hasNext()) {
            if (added) {
                sb.append(STR_COMMA);
            }
            Qualifier q = iter.next();
            sb.append(q.getText().toUpperCase());
            added = true;
        }
        sb.append(STR_BRACKET_END);
        return sb.toString();
    }

    private String getAllQualifierInfo(NodeInfoForMatrix nodeInfo, String delim) {
        if (null == nodeInfo) {
            return null;
        }
        HashMap<String, HashSet<String>> qualifierLookup = nodeInfo.getAllQualifierToListOfTerms();
        if (null == qualifierLookup) {
            return null;
        }
        Vector<CallSite> allStrs = new Vector<CallSite>(qualifierLookup.size());
        for (Map.Entry<String, HashSet<String>> entry : qualifierLookup.entrySet()) {
            String qualifier = entry.getKey();
            HashSet<String> terms = entry.getValue();
            allStrs.add((CallSite)((Object)(qualifier + STR_COLON + Utils.listToString(new Vector<String>(terms), (String)STR_EMPTY, (String)STR_COMMA))));
        }
        return Utils.listToString(allStrs, (String)STR_EMPTY, (String)delim);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.selected) {
            g.setColor(this.backgroundColor.brighter());
        } else {
            g.setColor(this.backgroundColor);
        }
        g.fillRect(1, 1, width - 1, height - 1);
        boolean multipleQualifiers = this.nodeInfo.containsMultipleQualifiers();
        if (!this.nodeInfo.isExpBackground() && !this.nodeInfo.isNonExpBackground()) {
            return;
        }
        if (this.nodeInfo.isExpBackground()) {
            if (multipleQualifiers && !this.nodeInfo.isExpNot() && !this.nodeInfo.isNonExpNot()) {
                g.setColor(Color.yellow);
                g.fillOval(1, 1, width - 3, height - 3);
            } else if (multipleQualifiers && (this.nodeInfo.isExpNot() || this.nodeInfo.isNonExpNot())) {
                g.setColor(Color.pink);
                g.fillOval(1, 1, width - 3, height - 3);
            } else if (!multipleQualifiers && this.nodeInfo.isExpNot()) {
                g.setColor(Color.red);
                g.fillOval(1, 1, width - 3, height - 3);
            }
            if (this.nodeInfo.isExpAnnotToTerm()) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.WHITE);
            }
            g.fillRect(this.getWidth() / 2 - 2, this.getHeight() / 2 - 2, 4, 4);
            return;
        }
        if (!this.nodeInfo.isExpBackground() && this.nodeInfo.isNonExpBackground()) {
            if (multipleQualifiers && !this.nodeInfo.isExpNot() && !this.nodeInfo.isNonExpNot()) {
                g.setColor(Color.yellow);
                g.fillOval(1, 1, width - 3, height - 3);
            } else if (multipleQualifiers && (this.nodeInfo.isExpNot() || this.nodeInfo.isNonExpNot())) {
                g.setColor(Color.pink);
                g.fillOval(1, 1, width - 3, height - 3);
            } else if (!multipleQualifiers && this.nodeInfo.isNonExpNot()) {
                g.setColor(Color.red);
                g.fillOval(1, 1, width - 3, height - 3);
            }
            if (this.nodeInfo.isNonExpAnnotToTerm()) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.WHITE);
            }
            g.fillRect(this.getWidth() / 2 - 2, this.getHeight() / 2 - 2, 4, 4);
        }
    }

    public void paintComponentOrig(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.selected) {
            g.setColor(this.backgroundColor.brighter());
        } else {
            g.setColor(this.backgroundColor);
        }
        g.fillRect(1, 1, width - 1, height - 1);
        if (!this.nodeInfo.isExpBackground() && !this.nodeInfo.isNonExpBackground()) {
            return;
        }
        if (this.nodeInfo.isExpBackground()) {
            if (this.nodeInfo.isExpNot()) {
                g.setColor(Color.red);
                g.fillOval(1, 1, width - 3, height - 3);
            }
            if (this.nodeInfo.isExpAnnotToTerm()) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.WHITE);
            }
            g.fillRect(this.getWidth() / 2 - 2, this.getHeight() / 2 - 2, 4, 4);
            return;
        }
        if (!this.nodeInfo.isExpBackground() && this.nodeInfo.isNonExpBackground()) {
            if (this.nodeInfo.isNonExpNot()) {
                g.setColor(Color.red);
                g.fillOval(1, 1, width - 3, height - 3);
            }
            if (this.nodeInfo.isNonExpAnnotToTerm()) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.WHITE);
            }
            g.fillRect(this.getWidth() / 2 - 2, this.getHeight() / 2 - 2, 4, 4);
        }
    }
}

