/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.matrix;

import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.gui.familytree.TreePanel;
import org.paint.gui.matrix.AnnotationMatrix;
import org.paint.gui.matrix.AnnotationMatrixCellRenderer;
import org.paint.gui.matrix.AnnotationMatrixModel;
import org.paint.gui.matrix.HeaderAncestor;
import org.paint.main.PaintManager;

public class AnnotationMatrixHeaderRenderer
extends JLabel
implements TableCellRenderer {
    public AnnotationMatrixHeaderRenderer(JTableHeader header) {
        this.setOpaque(true);
        this.setText("");
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AnnotationMatrix table = (AnnotationMatrix)((JTableHeader)e.getSource()).getTable();
                TableColumnModel columnModel = table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                AnnotationMatrixModel model = (AnnotationMatrixModel)table.getModel();
                HeaderAncestor ha = model.getPopup(viewColumn);
                ha.showMenu(e);
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        GOTerm goTerm;
        this.setIcon(null);
        AnnotationMatrixModel matrix = (AnnotationMatrixModel)table.getModel();
        Color bg_color = AnnotationMatrixCellRenderer.COLOR_BASIC;
        if (!matrix.isOdd(column)) {
            bg_color = AnnotationMatrixCellRenderer.COLOR_CONTRAST;
        }
        if (this.isPaintExpTerm(goTerm = matrix.getTermForColumn(column))) {
            bg_color = Preferences.EXP_ANNOT_ADDED_IN_PAINT;
        }
        this.setToolTipText(goTerm.getName());
        Preferences dp = Preferences.inst();
        UIManager.put("ToolTip.foreground", dp.getForegroundColor());
        ToolTipManager.sharedInstance().setDismissDelay(999999999);
        this.setBackground(bg_color);
        HeaderAncestor ha = matrix.getPopup(column);
        this.setForeground(dp.getForegroundColor());
        Border border = isSelected ? BorderFactory.createLineBorder(Color.BLACK) : BorderFactory.createEtchedBorder();
        this.setBorder(border);
        if (null == ha || !ha.hasAncestors()) {
            return this;
        }
        Icon icon = Preferences.inst().getIconByName("arrowDown");
        this.setIcon(icon);
        return this;
    }

    private boolean isPaintExpTerm(GOTerm goTerm) {
        List<GeneNode> nodes;
        if (null == goTerm) {
            return false;
        }
        String acc = goTerm.getAcc();
        if (null == acc) {
            return false;
        }
        PaintManager pm = PaintManager.inst();
        TreePanel tp = pm.getTree();
        if (null != tp && null != (nodes = tp.getTerminusNodes())) {
            for (GeneNode gn : nodes) {
                ArrayList annotList;
                Node n = gn.getNode();
                NodeVariableInfo nvi = n.getVariableInfo();
                if (null == nvi || null == (annotList = nvi.getGoAnnotationList())) continue;
                for (Annotation a : annotList) {
                    if (!a.isExpAnnotCreatedInPaint() || !acc.equals(a.getGoTerm())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

