/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.matrix;

import edu.usc.ksom.pm.panther.paint.matrix.MatrixGroup;
import edu.usc.ksom.pm.panther.paint.matrix.NodeInfoForMatrix;
import edu.usc.ksom.pm.panther.paint.matrix.TermAncestor;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.paint.datamodel.GeneNode;
import org.paint.gui.matrix.HeaderAncestor;

public class AnnotationMatrixModel
extends AbstractTableModel {
    private String aspect;
    private List<GeneNode> orderedNodes;
    private ArrayList<MatrixGroup> matrixGroupList;

    public AnnotationMatrixModel(List<GeneNode> orderedNodes, String aspect, ArrayList<MatrixGroup> matrixGroupList) {
        this.orderedNodes = orderedNodes;
        this.aspect = aspect;
        this.matrixGroupList = matrixGroupList;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return NodeInfoForMatrix.class;
    }

    @Override
    public int getRowCount() {
        if (null == this.orderedNodes) {
            return 0;
        }
        return this.orderedNodes.size();
    }

    @Override
    public int getColumnCount() {
        if (null == this.matrixGroupList) {
            return 0;
        }
        int total = 0;
        for (MatrixGroup group : this.matrixGroupList) {
            total += group.getCount();
        }
        return total;
    }

    public HeaderAncestor getPopup(int columnIndex) {
        int current = 0;
        for (MatrixGroup group : this.matrixGroupList) {
            if (current <= columnIndex && columnIndex < current + group.getCount()) {
                return new HeaderAncestor(group.getTermAncestorAtIndex(columnIndex - current));
            }
            current += group.getCount();
        }
        return null;
    }

    public TermAncestor getTermAncestorAtColumn(int columnIndex) {
        int current = 0;
        for (MatrixGroup group : this.matrixGroupList) {
            if (current <= columnIndex && columnIndex < current + group.getCount()) {
                return group.getTermAncestorAtIndex(columnIndex - current);
            }
            current += group.getCount();
        }
        return null;
    }

    public GOTerm getTermForColumn(int columnIndex) {
        int current = 0;
        for (MatrixGroup group : this.matrixGroupList) {
            if (current <= columnIndex && columnIndex < current + group.getCount()) {
                return group.getTermAtIndex(columnIndex - current);
            }
            current += group.getCount();
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (null == this.orderedNodes || rowIndex > this.orderedNodes.size()) {
            return null;
        }
        int current = 0;
        for (int i = 0; i < this.matrixGroupList.size(); ++i) {
            MatrixGroup group = this.matrixGroupList.get(i);
            if (current <= columnIndex && columnIndex < current + group.getCount()) {
                return group.getAnnotInfoForNode(this.orderedNodes.get(rowIndex).getNode(), columnIndex - current);
            }
            current += group.getCount();
        }
        System.out.println("Invalid row or column " + rowIndex + " col index = " + columnIndex);
        return null;
    }

    public boolean isOdd(int columnIndex) {
        int current = 0;
        for (int i = 0; i < this.matrixGroupList.size(); ++i) {
            MatrixGroup group = this.matrixGroupList.get(i);
            if (current <= columnIndex && columnIndex < current + group.getCount()) {
                return i % 2 != 0;
            }
            current += group.getCount();
        }
        return false;
    }

    public GeneNode getNode(int row) {
        if (row >= this.orderedNodes.size()) {
            System.out.println("Asking for row " + row + " which is > than the number of rows (" + this.orderedNodes.size() + ")");
            return null;
        }
        if (row < 0) {
            System.out.println("Asking for negative row");
            return null;
        }
        return this.orderedNodes.get(row);
    }

    public int getRow(GeneNode dsn) {
        try {
            return this.orderedNodes.indexOf(dsn);
        }
        catch (NullPointerException e) {
            return -1;
        }
    }
}

