/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.matrix;

import edu.usc.ksom.pm.panther.paint.annotation.QualifierAnnotRltn;
import edu.usc.ksom.pm.panther.paint.matrix.TermAncestor;
import edu.usc.ksom.pm.panther.paint.matrix.TermToAssociation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotQualifierGroup;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationHelper;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.TaxonomyHelper;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import org.apache.commons.lang.WordUtils;
import org.bbop.framework.GUIManager;
import org.paint.datamodel.GeneNode;
import org.paint.dialog.AnnotationQualifierDlg;
import org.paint.gui.DirtyIndicator;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.EventManager;
import org.paint.gui.evidence.PaintAction;
import org.paint.gui.familytree.TreePanel;
import org.paint.gui.matrix.AnnotationMatrix;
import org.paint.gui.matrix.AnnotationMatrixModel;
import org.paint.gui.matrix.MatrixTransferInfo;
import org.paint.main.PaintManager;
import org.paint.util.AnnotationUtil;
import org.paint.util.GeneNodeUtil;

public class AnnotationTransferHndlr
extends TransferHandler {
    private static AnnotDragGestureRecognizer recognizer = null;
    private Set<GeneNode> visitedNodes = new HashSet<GeneNode>();
    public static final DataFlavor FLAVOR_MATRIX_TRANSFER_INFO = new DataFlavor(MatrixTransferInfo.class, "MatrixTransferInfo");
    public static final String REMOVE_MSG_MORE_SPECIFIC_PART_1 = "Annotation to descendant node ";
    public static final String REMOVE_MSG_MORE_SPECIFIC_PART_2 = " for more specific or same term ";
    public static final String REMOVE_MSG_MORE_SPECIFIC_PART_3 = " (";
    public static final String REMOVE_MSG_MORE_SPECIFIC_PART_4 = ") will be removed.\n";
    public static final String REMOVE_MSG_LESS_SPECIFIC_PART_1 = "Annotation to node ";
    public static final String REMOVE_MSG_LESS_SPECIFIC_PART_2 = " for less specific term or same term ";
    public static final String REMOVE_MSG_LESS_SPECIFIC_PART_3 = " (";
    public static final String REMOVE_MSG_LESS_SPECIFIC_PART_4 = ") will be removed.\n";
    public static final String MORE_SPECIFIC_DESCENDENT_ANNOTATION = "More specific descendent annotation";
    public static final String LESS_SPECIFIC_ANNOTATION = "Less specific annotation";
    public static final String MSG_TAXON_CONSTRAINT_PART_1 = " - According to current taxonomy constraints rules, species ";
    public static final String MSG_TAXON_CONSTRAINT_PART_2 = " cannot be annotated to term ";
    public static final String MSG_TAXON_CONSTRAINT_PART_3 = ".  If there is an error with the taxonomy rule, create a ticket in GitHub in  https://github.com/geneontology/go-ontology/issues and tag as 'taxon constraint'.";

    public AnnotationTransferHndlr() {
    }

    public AnnotationTransferHndlr(String property) {
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean canImport = false;
        String because = null;
        TreePanel treePanel = null;
        if (support.isDrop() && support.isDataFlavorSupported(FLAVOR_MATRIX_TRANSFER_INFO) && support.getComponent() instanceof TreePanel) {
            canImport = true;
            treePanel = (TreePanel)support.getComponent();
        }
        GeneNode node = null;
        if (!canImport || treePanel == null) {
            return false;
        }
        Point p = support.getDropLocation().getDropPoint();
        if (!treePanel.pointInNode(p)) {
            this.clearVisitedNodes(treePanel);
            canImport = false;
            return false;
        }
        node = treePanel.getClickedInNodeArea(p);
        if (node != null) {
            try {
                StringBuffer becauseBuf = new StringBuffer();
                MatrixTransferInfo matrixTransferInfo = (MatrixTransferInfo)support.getTransferable().getTransferData(FLAVOR_MATRIX_TRANSFER_INFO);
                TermAncestor termAncestor = matrixTransferInfo.getTermAncestor();
                TermToAssociation toa = termAncestor.getTermToAssociation();
                PaintManager pm = PaintManager.inst();
                boolean possible = AnnotationHelper.IBDPossibleForNode((String)toa.getTerm().getAcc(), (Node)node.getNode(), (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper());
                if (possible) {
                    System.out.println("Possible to annotate node " + node.getNode().getStaticInfo().getPublicId() + " with IBD annotation to term " + toa.getTerm().getAcc());
                    canImport = true;
                } else {
                    canImport = false;
                }
            }
            catch (UnsupportedFlavorException e) {
                canImport = false;
            }
            catch (IOException e) {
                canImport = false;
            }
        }
        this.clearVisitedNodes(treePanel);
        if (treePanel != null) {
            Object drop_label = null;
            if (node != null) {
                this.visitedNodes.add(node);
                Node n = node.getNode();
                if (canImport) {
                    node.setDropColor(Color.BLACK);
                    drop_label = n.getStaticInfo().getPublicId();
                } else {
                    node.setDropColor(Color.RED);
                    if (null != because) {
                        drop_label = n.getStaticInfo().getPublicId() + " " + because;
                    }
                }
                treePanel.repaint();
            }
            Point dropPoint = support.getDropLocation().getDropPoint();
            dropPoint.x += 10;
            dropPoint.y += 2;
            treePanel.setDropInfo(node, dropPoint, (String)drop_label);
        }
        return canImport;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        AnnotationMatrix table = (AnnotationMatrix)c;
        int column = table.getSelectedColumn();
        int row = table.getClickedRow();
        AnnotationMatrixModel model = (AnnotationMatrixModel)table.getModel();
        TermAncestor termAncestor = model.getTermAncestorAtColumn(column);
        if (termAncestor == null) {
            System.out.println("No term for column " + column);
        }
        MatrixTransferInfo mti = new MatrixTransferInfo(termAncestor, ((AnnotationMatrixModel)table.getModel()).getNode(row));
        AnnotationTransferable transferable = new AnnotationTransferable(mti);
        return transferable;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        int srcActions = this.getSourceActions(comp);
        if (!(e instanceof MouseEvent) || action != 1 && action != 2 && action != 0x40000000 || (srcActions & action) == 0) {
            action = 0;
        }
        System.out.println("Drag move is not none");
        if (action != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new AnnotDragGestureRecognizer(new DragHandler());
            }
            recognizer.gestured(comp, (MouseEvent)e, srcActions, action);
        } else {
            this.exportDone(comp, null, 0);
        }
    }

    @Override
    public Icon getVisualRepresentation(Transferable t) {
        return super.getVisualRepresentation(t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        ArrayList children;
        NodeVariableInfo nvi;
        Iterator qualifierDlg;
        MatrixTransferInfo mti = null;
        TreePanel treePanel = null;
        try {
            mti = (MatrixTransferInfo)support.getTransferable().getTransferData(FLAVOR_MATRIX_TRANSFER_INFO);
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        if (!(support.getComponent() instanceof TreePanel)) {
            return false;
        }
        treePanel = (TreePanel)support.getComponent();
        if (null == mti) {
            return false;
        }
        TermToAssociation toa = mti.getTermAncestor().getTermToAssociation();
        Point p = support.getDropLocation().getDropPoint();
        GeneNode gNode = treePanel.getClickedInNodeArea(p);
        GOTerm annotTerm = toa.getTerm();
        String termAcc = annotTerm.getAcc();
        PaintManager pm = PaintManager.inst();
        AnnotQualifierGroup groups = AnnotationHelper.possibleToAnnotateWithIBD((String)toa.getTerm().getAcc(), (Node)gNode.getNode(), (StringBuffer)new StringBuffer(), (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper());
        if (null == groups || null == groups.getQualifierAnnotLookup()) {
            return false;
        }
        HashMap qualifierAnnotLookup = groups.getQualifierAnnotLookup();
        QualifierAnnotRltn qar = null;
        HashSet<Qualifier> applicableQset = null;
        if (1 != qualifierAnnotLookup.size()) {
            qualifierDlg = new AnnotationQualifierDlg((Frame)GUIManager.getManager().getFrame(), groups);
            qar = ((AnnotationQualifierDlg)((Object)qualifierDlg)).getAnnotationSet();
            if (!((AnnotationQualifierDlg)((Object)qualifierDlg)).didUserSubmitForm()) return false;
            applicableQset = qar.getqSet();
        } else {
            qualifierDlg = qualifierAnnotLookup.keySet().iterator();
            if (qualifierDlg.hasNext()) {
                HashSet<Qualifier> qset;
                applicableQset = qset = (HashSet<Qualifier>)qualifierDlg.next();
            }
        }
        ArrayList<GeneNode> allDescendents = new ArrayList<GeneNode>();
        GeneNodeUtil.allNonPrunedDescendents(gNode, allDescendents);
        if (!this.handleAnnotsToMoreSpecificTerms(annotTerm, allDescendents)) {
            return false;
        }
        if (!this.handleAnnotsToLessSpecificTerms(annotTerm, applicableQset, gNode)) {
            return false;
        }
        HashSet<Annotation> withSet = new HashSet<Annotation>();
        String errMsg = AnnotationHelper.canNodeBeAnnotatedWithIBD((String)termAcc, applicableQset, (Node)gNode.getNode(), withSet, (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper(), (boolean)true);
        if (null != errMsg) {
            System.out.println(errMsg);
            return false;
        }
        Node n = gNode.getNode();
        System.out.println("Going to annotate node " + n.getStaticInfo().getPublicId() + " with IBD annotation to term " + termAcc);
        TaxonomyHelper th = pm.getTaxonHelper();
        boolean valid = th.termAndQualifierValidForSpeciesCheckTaxonomy(termAcc, gNode.getNode().getStaticInfo().getCalculatedSpecies(), applicableQset);
        if (!valid) {
            String bigStr = gNode.getNode().getStaticInfo().getPublicId() + MSG_TAXON_CONSTRAINT_PART_1 + gNode.getNode().getStaticInfo().getCalculatedSpecies() + MSG_TAXON_CONSTRAINT_PART_2 + termAcc + MSG_TAXON_CONSTRAINT_PART_3;
            String formatted = WordUtils.wrap((String)bigStr, (int)80);
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), formatted);
        }
        PaintAction.inst().addIBDAnnotationAndPropagate(annotTerm, gNode, withSet, applicableQset);
        if (!th.isCheckingTaxonomy() && !(nvi = n.getVariableInfo()).isPruned() && null != (children = n.getStaticInfo().getChildren())) {
            StringBuffer sb = new StringBuffer();
            for (Node child : children) {
                AnnotationHelper.checkTaxonomyViolationsForNodeAndDescendants((Node)child, (String)annotTerm.getAcc(), (StringBuffer)sb, (TaxonomyHelper)th);
            }
            if (0 < sb.length()) {
                String formatted = WordUtils.wrap((String)sb.toString(), (int)80);
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), formatted, "Taxonomy violation", 2);
            }
        }
        this.clearVisitedNodes(treePanel);
        DirtyIndicator.inst().setAnnotated(true);
        EventManager.inst().fireAnnotationChangeEvent(new AnnotationChangeEvent(gNode));
        return true;
    }

    private boolean handleAnnotsToMoreSpecificTerms(GOTerm term, List<GeneNode> descList) {
        GOTermHelper gth = PaintManager.inst().goTermHelper();
        ArrayList ancestors = gth.getAncestors(term);
        if (null == ancestors || 0 == ancestors.size()) {
            return true;
        }
        Iterator iter = ancestors.iterator();
        while (iter.hasNext()) {
            GOTerm curTerm = (GOTerm)iter.next();
            String aspect = curTerm.getAspect();
            if (null == aspect || aspect.equals(term.getAspect())) continue;
            iter.remove();
        }
        HashSet<Annotation> removeDescSet = new HashSet<Annotation>();
        StringBuffer removeBuffer = new StringBuffer();
        for (GeneNode node : descList) {
            ArrayList annotList;
            Node n = node.getNode();
            NodeVariableInfo nvi = n.getVariableInfo();
            if (null == nvi || null == (annotList = nvi.getGoAnnotationList())) continue;
            for (Annotation annot : annotList) {
                String goTerm;
                GOTerm curTerm;
                String code = annot.getSingleEvidenceCodeFromSet();
                if (null == code) continue;
                GeneNode gn = PaintManager.inst().getGeneByPTNId(n.getStaticInfo().getPublicId());
                if (!code.equals("IBD") && (!code.equals("IKR") || gn.isLeaf()) && !code.equals("IRD") || !ancestors.contains(curTerm = gth.getTerm(goTerm = annot.getGoTerm())) && !curTerm.equals(term)) continue;
                removeDescSet.add(annot);
                removeBuffer.append(REMOVE_MSG_MORE_SPECIFIC_PART_1 + n.getStaticInfo().getPublicId() + REMOVE_MSG_MORE_SPECIFIC_PART_2 + goTerm + " (" + curTerm.getName() + ") will be removed.\n");
            }
        }
        if (removeDescSet.isEmpty()) {
            return true;
        }
        int dialogResult = JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), removeBuffer.toString(), MORE_SPECIFIC_DESCENDENT_ANNOTATION, 1, 2);
        if (dialogResult != 0) {
            return false;
        }
        for (Annotation annot : removeDescSet) {
            Node node = annot.getAnnotationDetail().getAnnotatedNode();
            GeneNode gn = PaintManager.inst().getGeneByPTNId(node.getStaticInfo().getPublicId());
            AnnotationUtil.deleteAnnotation(gn, annot);
        }
        return true;
    }

    private boolean handleAnnotsToLessSpecificTerms(GOTerm term, HashSet<Qualifier> applicableQset, GeneNode gNode) {
        Node n = gNode.getNode();
        NodeVariableInfo nvi = gNode.getNode().getVariableInfo();
        if (null == nvi) {
            return true;
        }
        ArrayList annots = nvi.getGoAnnotationList();
        if (null == annots || 0 == annots.size()) {
            return true;
        }
        GOTermHelper gth = PaintManager.inst().goTermHelper();
        ArrayList ancestors = gth.getAncestors(term);
        if (null == ancestors || 0 == ancestors.size()) {
            return true;
        }
        HashSet<Annotation> removeAnnotSet = new HashSet<Annotation>();
        StringBuffer removeBuffer = new StringBuffer();
        for (Annotation a : annots) {
            GOTerm curTerm;
            String code = a.getSingleEvidenceCodeFromSet();
            GeneNode gn = PaintManager.inst().getGeneByPTNId(n.getStaticInfo().getPublicId());
            if (!"IBD".equals(code) && (!"IKR".equals(code) || gn.isLeaf()) && !"IRD".equals(code) || !ancestors.contains(curTerm = gth.getTerm(a.getGoTerm())) && !curTerm.equals(term)) continue;
            removeAnnotSet.add(a);
            removeBuffer.append(REMOVE_MSG_LESS_SPECIFIC_PART_1 + n.getStaticInfo().getPublicId() + REMOVE_MSG_LESS_SPECIFIC_PART_2 + a.getGoTerm() + " (" + curTerm.getName() + ") will be removed.\n");
        }
        if (removeAnnotSet.isEmpty()) {
            return true;
        }
        int dialogResult = JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), removeBuffer.toString(), LESS_SPECIFIC_ANNOTATION, 1, 2);
        if (dialogResult != 0) {
            return false;
        }
        for (Annotation annot : removeAnnotSet) {
            Node node = annot.getAnnotationDetail().getAnnotatedNode();
            GeneNode gn = PaintManager.inst().getGeneByPTNId(node.getStaticInfo().getPublicId());
            AnnotationUtil.deleteAnnotation(gn, annot);
        }
        return true;
    }

    private void clearVisitedNodes(TreePanel tree) {
        for (GeneNode currentNode : this.visitedNodes) {
            if (currentNode == null) continue;
            currentNode.setDropColor(null);
        }
        if (tree != null) {
            tree.repaint();
        }
        this.visitedNodes.clear();
    }

    private static class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private DragHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            JComponent c = (JComponent)dge.getComponent();
            AnnotationTransferHndlr th = (AnnotationTransferHndlr)c.getTransferHandler();
            Transferable t = th.createTransferable(c);
            if (t != null) {
                this.scrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                FontMetrics fm = c.getGraphics().getFontMetrics();
                try {
                    MatrixTransferInfo mti = (MatrixTransferInfo)t.getTransferData(FLAVOR_MATRIX_TRANSFER_INFO);
                    TermAncestor termAncestor = mti.getTermAncestor();
                    String term_name = termAncestor.getTermToAssociation().getTerm().getName();
                    int height = fm.getHeight() + 2;
                    int width = fm.stringWidth("    " + term_name);
                    BufferedImage img = new BufferedImage(width, height, 6);
                    Graphics g = ((Image)img).getGraphics();
                    g.setColor(Color.black);
                    g.drawString(term_name, 0, height - 2);
                    dge.startDrag(null, img, new Point(0, -1 * ((Image)img).getHeight(null)), t, this);
                }
                catch (UnsupportedFlavorException e) {
                    th.exportDone(c, t, 0);
                    System.out.println("Unable to get term name, bad flavor");
                }
                catch (IOException e) {
                    th.exportDone(c, t, 0);
                    System.out.println("Unable to get term name, io problem");
                }
                catch (Exception e) {
                    th.exportDone(c, t, 0);
                    System.out.println(e.getMessage());
                }
            } else {
                th.exportDone(c, t, 0);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            System.out.println("Drag enter");
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dsde) {
            System.out.println("Drag has exitted source");
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent c = (JComponent)dsc.getComponent();
            if (dsde.getDropSuccess()) {
                ((AnnotationTransferHndlr)c.getTransferHandler()).exportDone(c, dsc.getTransferable(), dsde.getDropAction());
            } else {
                ((AnnotationTransferHndlr)c.getTransferHandler()).exportDone(c, dsc.getTransferable(), 0);
            }
            c.setAutoscrolls(this.scrolls);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            System.out.println("Drag action changed");
        }
    }

    private static class AnnotDragGestureRecognizer
    extends DragGestureRecognizer {
        AnnotDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        void gestured(JComponent c, MouseEvent e, int srcActions, int action) {
            this.setComponent(c);
            this.setSourceActions(srcActions);
            this.appendEvent(e);
            this.fireDragGestureRecognized(action, e.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }

    class AnnotationTransferable
    implements Transferable {
        private MatrixTransferInfo mti;

        public AnnotationTransferable(MatrixTransferInfo mti) {
            this.mti = mti;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.mti;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{FLAVOR_MATRIX_TRANSFER_INFO};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(FLAVOR_MATRIX_TRANSFER_INFO);
        }
    }
}

