/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.matrix;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.geneontology.db.model.GraphPath;
import org.geneontology.db.model.Term;

public class GraphPathComparator
implements Comparator<GraphPath> {
    public static final int LESS_THAN = -1;
    public static final int GREATER_THAN = 1;
    public static final int EQUAL_TO = 0;
    private Map<Term, List<GraphPath>> parent_groups;

    public GraphPathComparator(Map<Term, List<GraphPath>> parent_groups) {
        this.parent_groups = parent_groups;
    }

    @Override
    public int compare(GraphPath fa, GraphPath fb) {
        int distance_b;
        int distance_a = fa.getDistance();
        int comparison = this.compareDistance(distance_a, distance_b = fb.getDistance());
        if (comparison == 0) {
            comparison = this.compareProlific(fa.getSubject(), fb.getSubject());
        }
        if (comparison == 0) {
            comparison = this.compareStrings(fa.getSubject().getName(), fb.getSubject().getName());
        }
        return comparison;
    }

    private int compareDistance(int a, int b) {
        int comparison = a - b;
        comparison = comparison < 0 ? -1 : (comparison > 0 ? 1 : 0);
        return comparison;
    }

    private int compareProlific(Term a, Term b) {
        List<GraphPath> a_list = this.parent_groups.get(a);
        int a_descendants = a_list != null ? a_list.size() : 0;
        List<GraphPath> b_list = this.parent_groups.get(b);
        int b_descendants = b_list != null ? b_list.size() : 0;
        int comparison = b_descendants - a_descendants;
        comparison = comparison < 0 ? -1 : (comparison > 0 ? 1 : 0);
        return comparison;
    }

    private int compareStrings(String a, String b) {
        int comparison = a.toLowerCase().compareTo(b.toLowerCase());
        comparison = comparison < 0 ? -1 : (comparison > 0 ? 1 : 0);
        return comparison;
    }
}

