/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.matrix;

import edu.usc.ksom.pm.panther.paint.matrix.TermAncestor;
import edu.usc.ksom.pm.panther.paint.matrix.TermToAssociation;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.bbop.framework.GUIManager;
import org.paint.datamodel.Association;
import org.paint.gui.matrix.AnnotationMatrix;
import org.paint.main.PaintManager;

public class HeaderAncestor
extends JPopupMenu
implements ActionListener {
    private TermAncestor termAncestor;

    public HeaderAncestor(TermAncestor termAncestor) {
        super("");
        this.termAncestor = termAncestor;
    }

    public void showMenu(MouseEvent e) {
        PaintManager pm = PaintManager.inst();
        AnnotationMatrix am = pm.getMatrix();
        GOTermHelper gth = pm.goTermHelper();
        ArrayList<GOTerm> termList = this.termAncestor.getAncestorList();
        boolean added = false;
        for (GOTerm term : termList) {
            List parents;
            boolean termInMatrix = am.termInMatrix(term);
            if (termInMatrix || null == (parents = term.getParents()) || 0 == parents.size()) continue;
            if (!GOTermHelper.isAnnotAllowedForTerm((String)term.getAcc())) continue;
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(term.getName());
            menuItem.setSelected(false);
            menuItem.setActionCommand(term.getAcc());
            menuItem.addActionListener(this);
            this.add(menuItem);
            added = true;
        }
        if (added) {
            this.show(e.getComponent(), e.getX(), e.getY());
        } else {
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "No Ancestors", "Warning", 2);
        }
    }

    public boolean hasAncestors() {
        PaintManager pm = PaintManager.inst();
        AnnotationMatrix am = pm.getMatrix();
        ArrayList<GOTerm> termList = this.termAncestor.getAncestorList();
        for (GOTerm term : termList) {
            boolean termInMatrix = am.termInMatrix(term);
            if (termInMatrix) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String acc = e.getActionCommand();
        if (null == acc) {
            return;
        }
        ArrayList<GOTerm> termList = this.termAncestor.getAncestorList();
        ArrayList<GOTerm> newAncestorList = new ArrayList<GOTerm>();
        GOTerm selected = null;
        for (GOTerm term : termList) {
            if (null == selected && acc.equals(term.getAcc())) {
                System.out.println("Selected term " + term.getAcc() + " " + term.getName());
                selected = term;
                continue;
            }
            if (null == selected) continue;
            newAncestorList.add(term);
        }
        if (null == selected) {
            this.setVisible(false);
            return;
        }
        TermToAssociation toa = new TermToAssociation(selected);
        ArrayList<Association> associations = this.termAncestor.getTermToAssociation().getAsnList();
        for (Association a : associations) {
            toa.addAsn(a);
        }
        TermAncestor ta = new TermAncestor(toa, newAncestorList);
        ta.setTermToAssociation(toa);
        PaintManager.inst().addTermAncestor(ta);
        this.setVisible(false);
    }
}

