/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.menu;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;
import org.paint.dialog.CurationStatusColorDialog;
import org.paint.dialog.FindDialog;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.AnnotationChangeListener;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.FamilyChangeEvent;
import org.paint.gui.event.FamilyChangeListener;
import org.paint.gui.evidence.ActionLog;
import org.paint.main.PaintManager;

public class EditMenu
extends JMenu
implements FamilyChangeListener,
AnnotationChangeListener {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger((String)EditMenu.class.getName());
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenuItem searchItem;
    protected FindDialog findDialog;
    private static final String undo = "Undo";
    private static final String redo = "Redo";
    private static final String find = "Find...";
    private static final String curation_status_color = "Curation status colors... (Does not Work!!!)";

    public EditMenu() {
        super("Edit");
        this.setMnemonic('e');
        this.undoItem = new JMenuItem(undo);
        this.undoItem.setMnemonic(90);
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 4));
        this.undoItem.addActionListener(new undoActionListener());
        this.add(this.undoItem);
        this.undoItem.setEnabled(false);
        this.redoItem = new JMenuItem(redo);
        this.redoItem.setMnemonic(89);
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 4));
        this.redoItem.addActionListener(new redoActionListener());
        this.add(this.redoItem);
        this.redoItem.setEnabled(false);
        this.addSeparator();
        this.searchItem = new JMenuItem(find);
        this.searchItem.setMnemonic(70);
        this.searchItem.setAccelerator(KeyStroke.getKeyStroke(70, 4));
        this.searchItem.addActionListener(new SearchActionListener());
        this.add(this.searchItem);
        this.searchItem.setEnabled(PaintManager.inst().getFamily() != null);
        this.addSeparator();
        JMenuItem curationStatusColor = new JMenuItem(curation_status_color);
        curationStatusColor.addActionListener(new CurationStatusColorListener());
        this.add(curationStatusColor);
        EventManager.inst().registerFamilyListener(this);
        EventManager.inst().registerGeneAnnotationChangeListener(this);
    }

    @Override
    public void newFamilyData(FamilyChangeEvent e) {
        this.searchItem.setEnabled(true);
        this.updateLogItems();
    }

    @Override
    public void handleAnnotationChangeEvent(AnnotationChangeEvent event) {
        this.updateLogItems();
    }

    private void updateLogItems() {
        String item_label = ActionLog.inst().doneString();
        if (item_label != null) {
            this.undoItem.setText("Undo " + item_label);
            this.undoItem.setEnabled(true);
        } else {
            this.undoItem.setText(undo);
            this.undoItem.setEnabled(false);
        }
        item_label = ActionLog.inst().undoneString();
        if (item_label != null) {
            this.redoItem.setText("Redo " + item_label);
            this.redoItem.setEnabled(true);
        } else {
            this.redoItem.setText(redo);
            this.redoItem.setEnabled(false);
        }
    }

    private class CurationStatusColorListener
    implements ActionListener {
        private CurationStatusColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new CurationStatusColorDialog(GUIManager.getManager().getFrame());
        }
    }

    private class SearchActionListener
    implements ActionListener {
        private SearchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null == EditMenu.this.findDialog) {
                EditMenu.this.findDialog = new FindDialog((Frame)GUIManager.getManager().getFrame(), "Find");
            } else {
                EditMenu.this.findDialog.setVisible(true);
            }
        }
    }

    private class redoActionListener
    implements ActionListener {
        private redoActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionLog.inst().redo();
        }
    }

    private class undoActionListener
    implements ActionListener {
        private undoActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionLog.inst().undo();
        }
    }
}

