/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.menu;

import com.sri.panther.paintCommon.User;
import com.sri.panther.paintCommon.familyLibrary.FileNameGenerator;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;
import org.paint.config.Preferences;
import org.paint.dataadapter.FileAdapter;
import org.paint.dataadapter.PantherServer;
import org.paint.dialog.ActiveFamily;
import org.paint.dialog.LoginDlg;
import org.paint.dialog.ManageBooksDlg;
import org.paint.dialog.NewFamily;
import org.paint.dialog.OrgEvidenceDlg;
import org.paint.gui.DirtyIndicator;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.AnnotationChangeListener;
import org.paint.gui.event.AnnotationDisplayEvent;
import org.paint.gui.event.CommentChangeEvent;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.FamilyChangeEvent;
import org.paint.gui.event.FamilyChangeListener;
import org.paint.main.PaintManager;

public class FileMenu
extends JMenu
implements AnnotationChangeListener,
FamilyChangeListener {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger(FileMenu.class);
    protected JMenuItem loginItem;
    protected JMenuItem logoffItem;
    protected JMenuItem manageBooksItem;
    protected JMenuItem updateCommentItem;
    protected JMenuItem updateFamilyNameItem;
    protected JMenuItem saveDBItem;
    protected JMenuItem viewOmittedAnnotInfoItem;
    protected JMenuItem viewTaxonomyViolatoinInfoItem;
    protected JMenuItem viewUpdateHistoryItem;
    protected JMenuItem setOrgEvidenceItem;
    private static final String MENU_ITEM_LOGIN = "Login";
    private static final String MENU_ITEM_LOGOFF = "Logoff";
    private static final String MENU_ITEM_OPEN_FROM_DB = "Open from database ... ";
    private static final String MENU_ITEM_MANAGE_BOOKS = "Manage and View Books...";
    private static final String MENU_ITEM_UPDATE_COMMENT = "Update comment...";
    private static final String MENU_ITEM_UPDATE_NAME_FAMILY = "Name Family...";
    private static final String MENU_ITEM_SAVE_TO_DB = "Save to database...";
    private static final String MENU_ITEM_VIEW_ANNOT_INFO = "View annotation information";
    private static final String MENU_ITEM_VIEW_ANNOT_HISTORY_INFO = "View annotation history";
    private static final String MENU_ITEM_VIEW_TAXONOMY_VIOLATION_INFO = "View taxonomy violation information";
    private static final String MENU_ITEM_SET_NON_DISPLAY_ORG_EVIDENCE = "Select evidence codes to filter in Annotation matrix";
    private static List<FileMenu> instances = new ArrayList<FileMenu>();
    private static final String LINE_BREAK = "\\\\n";
    private static final String LINE_SEPARATOR_SYSTEM_PROPERY = System.getProperty("line.separator");
    private static final String STR_EMPTY = "";

    public FileMenu() {
        super("File");
        this.setMnemonic('f');
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.loginItem = new JMenuItem(MENU_ITEM_LOGIN);
        this.loginItem.setAccelerator(KeyStroke.getKeyStroke(76, toolkit.getMenuShortcutKeyMask()));
        this.loginItem.addActionListener(new LoginActionListener(this, this.loginItem));
        this.add(this.loginItem);
        this.logoffItem = new JMenuItem(MENU_ITEM_LOGOFF);
        this.logoffItem.addActionListener(new LogoffActionListener(this, this.logoffItem));
        this.add(this.logoffItem);
        this.logoffItem.setEnabled(false);
        this.addSeparator();
        this.manageBooksItem = new JMenuItem(MENU_ITEM_MANAGE_BOOKS);
        this.manageBooksItem.setAccelerator(KeyStroke.getKeyStroke(77, toolkit.getMenuShortcutKeyMask()));
        this.manageBooksItem.addActionListener(new ManageBooksActionListener());
        this.add(this.manageBooksItem);
        this.manageBooksItem.setEnabled(false);
        this.updateFamilyNameItem = new JMenuItem(MENU_ITEM_UPDATE_NAME_FAMILY);
        this.updateFamilyNameItem.addActionListener(new UpdateFamilyNameActionListener());
        this.add(this.updateFamilyNameItem);
        this.updateFamilyNameItem.setEnabled(false);
        this.updateCommentItem = new JMenuItem(MENU_ITEM_UPDATE_COMMENT);
        this.updateCommentItem.addActionListener(new UpdateCommentsActionListener());
        this.add(this.updateCommentItem);
        this.updateCommentItem.setEnabled(false);
        this.saveDBItem = new JMenuItem(MENU_ITEM_SAVE_TO_DB);
        this.saveDBItem.addActionListener(new SaveBookActionListener());
        this.add(this.saveDBItem);
        this.saveDBItem.setEnabled(false);
        this.addSeparator();
        this.viewOmittedAnnotInfoItem = new JMenuItem(MENU_ITEM_VIEW_ANNOT_INFO);
        this.viewOmittedAnnotInfoItem.addActionListener(new ViewOmittedAnnotActionListener());
        this.add(this.viewOmittedAnnotInfoItem);
        this.viewOmittedAnnotInfoItem.setEnabled(false);
        this.viewTaxonomyViolatoinInfoItem = new JMenuItem(MENU_ITEM_VIEW_TAXONOMY_VIOLATION_INFO);
        this.viewTaxonomyViolatoinInfoItem.addActionListener(new ViewTaxomomyViolationInfoListener());
        this.add(this.viewTaxonomyViolatoinInfoItem);
        this.viewTaxonomyViolatoinInfoItem.setEnabled(false);
        this.viewUpdateHistoryItem = new JMenuItem(MENU_ITEM_VIEW_ANNOT_HISTORY_INFO);
        this.viewUpdateHistoryItem.addActionListener(new ViewAnnotHistoryActionListener());
        this.add(this.viewUpdateHistoryItem);
        this.viewUpdateHistoryItem.setEnabled(false);
        this.setOrgEvidenceItem = new JMenuItem(MENU_ITEM_SET_NON_DISPLAY_ORG_EVIDENCE);
        this.setOrgEvidenceItem.addActionListener(new SetOrgEvidenceActionListener());
        this.add(this.setOrgEvidenceItem);
        this.setOrgEvidenceItem.setEnabled(true);
        this.updateMenu();
        EventManager.inst().registerGeneAnnotationChangeListener(this);
        EventManager.inst().registerFamilyListener(this);
    }

    public void updateMenu() {
        this.saveDBItem.setEnabled(DirtyIndicator.inst().bookUpdated());
        this.updateCommentItem.setEnabled(DirtyIndicator.inst().bookUpdated());
        this.updateFamilyNameItem.setEnabled(DirtyIndicator.inst().bookUpdated());
        this.viewOmittedAnnotInfoItem.setEnabled(DirtyIndicator.inst().bookUpdated());
        this.viewTaxonomyViolatoinInfoItem.setEnabled(DirtyIndicator.inst().bookUpdated());
        this.viewUpdateHistoryItem.setEnabled(DirtyIndicator.inst().bookUpdated());
    }

    public boolean saveCurrent() {
        return PaintManager.inst().saveCurrent();
    }

    @Override
    public void newFamilyData(FamilyChangeEvent e) {
        this.updateCommentItem.setEnabled(true);
        this.updateFamilyNameItem.setEnabled(true);
        this.saveDBItem.setEnabled(true);
        this.viewOmittedAnnotInfoItem.setEnabled(true);
        this.viewTaxonomyViolatoinInfoItem.setEnabled(true);
        this.viewUpdateHistoryItem.setEnabled(true);
    }

    @Override
    public void handleAnnotationChangeEvent(AnnotationChangeEvent event) {
        this.updateMenu();
    }

    private static void updateMenus() {
        for (FileMenu f : instances) {
            f.updateMenu();
        }
    }

    private static class SaveToFileActionListener
    implements ActionListener {
        private SaveToFileActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActiveFamily dlg = new ActiveFamily(GUIManager.getManager().getFrame());
            File f = dlg.getSelectedFile(true, null);
            if (f != null) {
                try {
                    String paintfile = FileNameGenerator.formatPAINTFileName((String)f.getCanonicalPath());
                    FileAdapter dt = new FileAdapter(paintfile);
                    dt.saveOutput();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Unable to save file " + f);
                }
            }
        }
    }

    private class SearchBooksActionListener
    implements ActionListener {
        private SearchBooksActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int dialogResult;
            if (DirtyIndicator.inst().bookUpdated() && null != PaintManager.inst().getFamily() && (dialogResult = JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), "Book has been updated, do you want to save?", "Book Updated", 1, 2)) == 0) {
                FileMenu.this.saveCurrent();
            }
            DirtyIndicator.inst().setAnnotated(false);
            NewFamily dlg = new NewFamily(GUIManager.getManager().getFrame());
            String familyID = dlg.display();
            if (familyID != null) {
                PaintManager.inst().openNewFamily(familyID);
                FileMenu.updateMenus();
            }
        }
    }

    private class SaveBookActionListener
    implements ActionListener {
        private SaveBookActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaintManager.inst().saveCurrent();
        }
    }

    private class ManageBooksActionListener
    implements ActionListener {
        private ManageBooksActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int dialogResult;
            int dialogResult2;
            int dialogResult3;
            if (DirtyIndicator.inst().bookUpdated() && null != PaintManager.inst().getFamily() && (dialogResult3 = JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), "Book has been updated, do you want to save?", "Book Updated", 1, 2)) == 0) {
                FileMenu.this.saveCurrent();
            }
            DirtyIndicator.inst().setAnnotated(false);
            ManageBooksDlg dlg = new ManageBooksDlg((Frame)GUIManager.getManager().getFrame(), Preferences.inst().getPantherURL(), PaintManager.inst().getUserInfo());
            String bookId = dlg.display();
            if (null == bookId) {
                return;
            }
            User user = PaintManager.inst().getUser();
            if ((null == user || user.getprivilegeLevel() < 6) && (dialogResult2 = JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), "User does not have privilege to lock and save books, continue?", "User privilege warning", 1, 2)) != 0) {
                return;
            }
            User lockedBy = dlg.getLockedBy();
            if (null != user && null != lockedBy && !user.getloginName().equals(lockedBy.getLoginName()) && (dialogResult = JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), "Book is locked by another user " + lockedBy.getLoginName() + ", you will not be able to save changes.  Continue?", "Book is already locked by another user", 1, 2)) != 0) {
                return;
            }
            PaintManager.inst().closeCurrent();
            PaintManager.inst().openNewFamily(bookId);
            FileMenu.updateMenus();
        }
    }

    private class UpdateCommentsActionListener
    implements ActionListener {
        private UpdateCommentsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaintManager pm = PaintManager.inst();
            String curComment = pm.getCuratorNotes();
            if (null != curComment) {
                curComment = curComment.replaceAll(FileMenu.LINE_BREAK, LINE_SEPARATOR_SYSTEM_PROPERY);
            }
            JTextArea ta = new JTextArea(20, 100);
            if (null != curComment) {
                ta.setText(curComment);
            }
            ta.setWrapStyleWord(true);
            ta.setLineWrap(true);
            ta.setCaretPosition(0);
            ta.setEditable(true);
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), new JScrollPane(ta), "Curator Notes", 1);
            String newComment = ta.getText();
            if (null != newComment && 0 == (newComment = newComment.trim()).length()) {
                newComment = null;
            }
            if (null != curComment && !curComment.equals(newComment)) {
                pm.setCuratorNotes(newComment);
            } else if (null != newComment && !newComment.equals(curComment)) {
                pm.setCuratorNotes(newComment);
            }
            DirtyIndicator.inst().setAnnotated(true);
            EventManager.inst().fireCommentChangeEvent(new CommentChangeEvent(this));
        }
    }

    private class SetOrgEvidenceActionListener
    implements ActionListener {
        private SetOrgEvidenceActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OrgEvidenceDlg dlg = new OrgEvidenceDlg((Frame)GUIManager.getManager().getFrame(), Preferences.inst().getPantherURL(), PaintManager.inst().getUserInfo());
            boolean changes = dlg.display();
            if (changes) {
                EventManager.inst().fireAnnotationDisplayEvent(new AnnotationDisplayEvent(this));
            }
        }
    }

    private class ViewAnnotHistoryActionListener
    implements ActionListener {
        private ViewAnnotHistoryActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaintManager pm = PaintManager.inst();
            String upateHistory = pm.getUpdateHistory();
            if (null == upateHistory) {
                upateHistory = FileMenu.STR_EMPTY;
            }
            String info = upateHistory.toString().replaceAll(FileMenu.LINE_BREAK, LINE_SEPARATOR_SYSTEM_PROPERY);
            JTextArea ta = new JTextArea(20, 100);
            if (null != info) {
                ta.setText(info);
            }
            ta.setEditable(false);
            ta.setWrapStyleWord(true);
            ta.setLineWrap(true);
            ta.setCaretPosition(0);
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), new JScrollPane(ta), "Curation history information", 1);
        }
    }

    private class ViewTaxomomyViolationInfoListener
    implements ActionListener {
        private ViewTaxomomyViolationInfoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaintManager pm = PaintManager.inst();
            ArrayList<String> msgList = pm.getTaxonmomyWarnings();
            String info = String.join((CharSequence)LINE_SEPARATOR_SYSTEM_PROPERY, msgList);
            JTextArea ta = new JTextArea(20, 100);
            if (null != info) {
                ta.setText(info);
            }
            ta.setEditable(false);
            ta.setWrapStyleWord(true);
            ta.setLineWrap(true);
            ta.setCaretPosition(0);
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), new JScrollPane(ta), "Taxomomy violation information", 1);
        }
    }

    private class ViewOmittedAnnotActionListener
    implements ActionListener {
        private ViewOmittedAnnotActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaintManager pm = PaintManager.inst();
            StringBuffer errorBuf = pm.getFamily().getNodeInfoBuf();
            if (null == errorBuf) {
                errorBuf = new StringBuffer(FileMenu.STR_EMPTY);
            }
            String info = errorBuf.toString().replaceAll(FileMenu.LINE_BREAK, LINE_SEPARATOR_SYSTEM_PROPERY);
            JTextArea ta = new JTextArea(20, 100);
            if (null != info) {
                ta.setText(info);
            }
            ta.setEditable(false);
            ta.setWrapStyleWord(true);
            ta.setLineWrap(true);
            ta.setCaretPosition(0);
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), new JScrollPane(ta), "Additional information about annotations", 1);
        }
    }

    private class UpdateFamilyNameActionListener
    implements ActionListener {
        private UpdateFamilyNameActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaintManager pm = PaintManager.inst();
            String curFamilyName = pm.getFamily().getName();
            JTextArea ta = new JTextArea(1, 40);
            if (null != curFamilyName) {
                ta.setText(curFamilyName);
            }
            ta.setWrapStyleWord(true);
            ta.setLineWrap(true);
            ta.setCaretPosition(0);
            ta.setEditable(true);
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), new JScrollPane(ta), "Family Name", 1);
            String newFamilyName = ta.getText();
            if (null != newFamilyName) {
                newFamilyName.trim();
                if (0 == newFamilyName.length()) {
                    newFamilyName = null;
                }
            }
            if (null != curFamilyName && !curFamilyName.equals(newFamilyName)) {
                pm.getFamily().setName(newFamilyName);
            } else if (null != newFamilyName && !newFamilyName.equals(curFamilyName)) {
                pm.getFamily().setName(newFamilyName);
            }
            pm.setTitle();
            DirtyIndicator.inst().setAnnotated(true);
            EventManager.inst().fireAnnotationChangeEvent(new AnnotationChangeEvent(pm.getTree().getRoot()));
        }
    }

    private class LogoffActionListener
    implements ActionListener {
        FileMenu fileMenu;
        JMenuItem menuItem;

        public LogoffActionListener(FileMenu fileMenu2, JMenuItem menuItem) {
            this.fileMenu = fileMenu2;
            this.menuItem = menuItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int dialogResult;
            if (DirtyIndicator.inst().bookUpdated() && null != PaintManager.inst().getFamily() && (dialogResult = JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), "Book has been updated, do you want to save?", "Book Updated", 1, 2)) == 0) {
                FileMenu.this.saveCurrent();
            }
            DirtyIndicator.inst().setAnnotated(false);
            PaintManager.inst().setUser(null);
            FileMenu.this.loginItem.setEnabled(true);
            FileMenu.this.logoffItem.setEnabled(false);
            FileMenu.this.manageBooksItem.setEnabled(false);
            FileMenu.this.saveDBItem.setEnabled(false);
            FileMenu.this.updateCommentItem.setEnabled(false);
            FileMenu.this.updateFamilyNameItem.setEnabled(false);
            FileMenu.this.viewOmittedAnnotInfoItem.setEnabled(false);
            FileMenu.this.viewTaxonomyViolatoinInfoItem.setEnabled(false);
            FileMenu.this.viewUpdateHistoryItem.setEnabled(false);
        }
    }

    private class LoginActionListener
    implements ActionListener {
        FileMenu fileMenu;
        JMenuItem menuItem;

        public LoginActionListener(FileMenu fileMenu2, JMenuItem menuItem) {
            this.fileMenu = fileMenu2;
            this.menuItem = menuItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int dialogResult;
            if (DirtyIndicator.inst().bookUpdated() && null != PaintManager.inst().getFamily() && (dialogResult = JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), "Book has been updated, do you want to save?", "Book Updated", 1, 2)) == 0) {
                FileMenu.this.saveCurrent();
            }
            DirtyIndicator.inst().setAnnotated(false);
            LoginDlg dlg = new LoginDlg(GUIManager.getManager().getFrame());
            Vector<String> results = dlg.display();
            if (null == results) {
                System.out.println("No login information to verify, returning");
                return;
            }
            if (results.isEmpty()) {
                System.out.println("No login information to verify, returning");
                return;
            }
            System.out.println("Sending user login information with " + results.size() + " elements ");
            User user = PantherServer.inst().getUserInfo(Preferences.inst().getPantherURL(), results);
            if (null == user) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Unable to verify user information", "User Information", 0);
                System.exit(-1);
            }
            if (user.getprivilegeLevel() < 6) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "User does not have privilege to lock and save books", "User privilege warning", 2);
            }
            PaintManager pm = PaintManager.inst();
            pm.setUser(user);
            pm.setUserInfo(results);
            FileMenu.this.loginItem.setEnabled(false);
            FileMenu.this.logoffItem.setEnabled(true);
            FileMenu.this.manageBooksItem.setEnabled(true);
        }
    }
}

