/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.menu;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;
import org.paint.dialog.MSAColorDialog;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.FamilyChangeEvent;
import org.paint.gui.event.FamilyChangeListener;
import org.paint.gui.msa.MSA;
import org.paint.gui.msa.MSAPanel;
import org.paint.main.PaintManager;

public class MSAMenu
extends JMenu
implements FamilyChangeListener {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger((String)"MSAMenu");
    private static final String LABEL_FULL_ALIGN = "Entire Alignment";
    private static final String LABEL_TRIMMED_ALIGN = "Trimmed Alignment";
    private static final String LABEL_DOMAIN = "Domain";
    private static final String LABEL_DOMAIN_TRIMMED = "Condensed Domain";
    private static final String LABEL_KEY_RESIDUE = "Key Residue";
    private static final String weight = "Use weights";
    private static final String update = "Edit msa colors/thresholds";
    private JMenuItem fullItem = new JMenuItem("Entire Alignment");
    private JMenuItem matchStatesItem;
    private JMenuItem domainItem;
    private JMenuItem domainTrimmedItem;
    private JMenuItem keyResidueItem;

    public MSAMenu() {
        super("MSA and Domain");
        this.add(this.fullItem);
        this.fullItem.setEnabled(false);
        this.fullItem.addActionListener(new MSAActionListener());
        this.matchStatesItem = new JMenuItem(LABEL_TRIMMED_ALIGN);
        this.add(this.matchStatesItem);
        this.matchStatesItem.setEnabled(false);
        this.matchStatesItem.addActionListener(new MSAActionListener());
        this.domainItem = new JMenuItem(LABEL_DOMAIN);
        this.add(this.domainItem);
        this.domainItem.setEnabled(false);
        this.domainItem.addActionListener(new MSAActionListener());
        this.domainTrimmedItem = new JMenuItem(LABEL_DOMAIN_TRIMMED);
        this.add(this.domainTrimmedItem);
        this.domainTrimmedItem.setEnabled(false);
        this.domainTrimmedItem.addActionListener(new MSAActionListener());
        this.keyResidueItem = new JMenuItem(LABEL_KEY_RESIDUE);
        this.add(this.keyResidueItem);
        this.keyResidueItem.setEnabled(false);
        this.keyResidueItem.addActionListener(new MSAActionListener());
        this.addSeparator();
        JMenuItem updateMSA = new JMenuItem(update);
        updateMSA.addActionListener(new MSAUpdateActionListener());
        this.add(updateMSA);
        EventManager ev = EventManager.inst();
        ev.registerFamilyListener(this);
    }

    public void updateMenu(MSAPanel msaPanel) {
        MSA msa = msaPanel.getModel();
        if (null != msa) {
            if (msa.haveFullAlignData()) {
                this.fullItem.setEnabled(true);
                this.fullItem.setSelected(true);
            }
            if (msa.haveTrimmedAlignData()) {
                this.matchStatesItem.setEnabled(true);
                this.matchStatesItem.setSelected(false);
            }
            if (msa.haveDomainInfo()) {
                this.domainItem.setEnabled(true);
                this.domainItem.setSelected(false);
                this.domainTrimmedItem.setEnabled(true);
                this.domainTrimmedItem.setSelected(false);
            }
            if (msa.haveHaveKeyResidueInfo()) {
                this.keyResidueItem.setEnabled(true);
                this.keyResidueItem.setSelected(false);
            }
        } else {
            this.fullItem.setEnabled(false);
            this.matchStatesItem.setEnabled(false);
            this.domainItem.setEnabled(false);
            this.domainTrimmedItem.setEnabled(false);
            this.keyResidueItem.setEnabled(false);
        }
    }

    @Override
    public void newFamilyData(FamilyChangeEvent e) {
        MSAPanel msa = PaintManager.inst().getMSAPanel();
        if (msa != null) {
            this.setVisible(true);
            this.updateMenu(msa);
        } else {
            this.setVisible(false);
        }
    }

    private class MSAUpdateActionListener
    implements ActionListener {
        private MSAUpdateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MSAPanel msa = PaintManager.inst().getMSAPanel();
            MSAColorDialog dlg = new MSAColorDialog((Frame)GUIManager.getManager().getFrame(), msa.isWeighted());
            if (dlg.display()) {
                msa.updateColors();
            }
        }
    }

    private class MSAActionListener
    implements ActionListener {
        MSAActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MSAPanel msaPanel = PaintManager.inst().getMSAPanel();
            if (null != msaPanel) {
                MSA msa = msaPanel.getModel();
                if (null == msa) {
                    return;
                }
                if (e.getSource().equals(MSAMenu.this.fullItem) && MSAMenu.this.fullItem.isEnabled()) {
                    msa.setDisplayType(MSA.MSA_DISPLAY.ENTIRE_ALIGNMENT);
                    msaPanel.setFullLength(true);
                } else if (e.getSource().equals(MSAMenu.this.matchStatesItem) && MSAMenu.this.matchStatesItem.isEnabled()) {
                    msa.setDisplayType(MSA.MSA_DISPLAY.TRIMMED);
                    msaPanel.setFullLength(false);
                } else if (e.getSource().equals(MSAMenu.this.domainItem) && MSAMenu.this.domainItem.isEnabled()) {
                    msa.setDisplayType(MSA.MSA_DISPLAY.DOMAIN);
                    msaPanel.setFullLength(true);
                } else if (e.getSource().equals(MSAMenu.this.domainTrimmedItem) && MSAMenu.this.domainTrimmedItem.isEnabled()) {
                    msa.setDisplayType(MSA.MSA_DISPLAY.DOMAIN_TRIMMED);
                    msaPanel.setFullLength(true);
                } else if (e.getSource().equals(MSAMenu.this.keyResidueItem) && MSAMenu.this.keyResidueItem.isEnabled()) {
                    msa.setDisplayType(MSA.MSA_DISPLAY.KEY_RESIDUE);
                    msaPanel.setFullLength(true);
                }
            }
        }
    }
}

