/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.menu;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;
import org.paint.config.Preferences;
import org.paint.dialog.ScaleTreeDlg;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.FamilyChangeEvent;
import org.paint.gui.event.FamilyChangeListener;
import org.paint.gui.familytree.TreeModel;
import org.paint.gui.familytree.TreePanel;
import org.paint.main.PaintManager;

public class TreeMenu
extends JMenu
implements FamilyChangeListener {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger((String)TreeMenu.class.getName());
    private static final String expand = "Expand all nodes";
    private static final String collapse = "Collapse nodes without experimental data";
    private static final String reset = "Reset root to main";
    private static final String distance = "Use distances";
    private static final String order = "Order leaves ";
    private static final String ladder_top = "Most leaves above";
    private static final String ladder_bottom = "Most leaves below";
    private static final String species = "By species";
    private static final String scale = "Scale...";
    private static final String COLOR = "Color tree";
    private static final String COLOR_DUPLICATION = "Color based on duplication";
    private static final String COLOR_SPECIES_CLS = "Color based on species classification";
    private static final String COLOR_HORIZONTAL_TRANSFER = "Color based on horizontal transfer";
    private JRadioButtonMenuItem species_order;

    public TreeMenu() {
        super("Tree");
        this.setMnemonic('t');
        JMenuItem expandAllNodesItem = new JMenuItem(expand);
        expandAllNodesItem.addActionListener(new TreeActionListener(202));
        this.add(expandAllNodesItem);
        JMenuItem collapseNonExpNodesItem = new JMenuItem(collapse);
        collapseNonExpNodesItem.addActionListener(new TreeActionListener(201));
        this.add(collapseNonExpNodesItem);
        this.addSeparator();
        JMenuItem resetRootToMain = new JMenuItem(reset);
        resetRootToMain.addActionListener(new TreeActionListener(203));
        this.add(resetRootToMain);
        this.addSeparator();
        JCheckBoxMenuItem useDistances = new JCheckBoxMenuItem(distance);
        useDistances.setSelected(Preferences.inst().isUseDistances());
        useDistances.addActionListener(new TreeActionListener(204));
        this.add(useDistances);
        JMenuItem scaleTree = new JMenuItem(scale);
        scaleTree.addActionListener(new ScaleTreeActionListener());
        this.add(scaleTree);
        this.addSeparator();
        JMenu tree_ordering = new JMenu(order);
        this.species_order = new JRadioButtonMenuItem(species);
        JRadioButtonMenuItem top_order = new JRadioButtonMenuItem(ladder_top);
        JRadioButtonMenuItem bottom_order = new JRadioButtonMenuItem(ladder_bottom);
        this.species_order.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.species_order);
        group.add(top_order);
        group.add(bottom_order);
        this.species_order.addItemListener(new TreeReorderListener(205));
        top_order.addItemListener(new TreeReorderListener(206));
        bottom_order.addItemListener(new TreeReorderListener(207));
        tree_ordering.add(this.species_order);
        tree_ordering.add(top_order);
        tree_ordering.add(bottom_order);
        this.add(tree_ordering);
        this.addSeparator();
        JMenu coloring = new JMenu(COLOR);
        JRadioButtonMenuItem colorDuplication = new JRadioButtonMenuItem(COLOR_DUPLICATION);
        JRadioButtonMenuItem colorSpecies = new JRadioButtonMenuItem(COLOR_SPECIES_CLS);
        JRadioButtonMenuItem colorHorizontalTransfer = new JRadioButtonMenuItem(COLOR_HORIZONTAL_TRANSFER);
        TreeModel.TreeColorSchema tcs = Preferences.inst().getColorSchema();
        if (TreeModel.TreeColorSchema.DUPLICATION == tcs) {
            colorDuplication.setSelected(true);
            colorSpecies.setSelected(false);
            colorHorizontalTransfer.setSelected(false);
        } else if (TreeModel.TreeColorSchema.SPECIES_CLS == tcs) {
            colorDuplication.setSelected(false);
            colorSpecies.setSelected(true);
            colorHorizontalTransfer.setSelected(false);
        } else {
            colorDuplication.setSelected(false);
            colorSpecies.setSelected(false);
            colorHorizontalTransfer.setSelected(true);
        }
        ButtonGroup cGroup = new ButtonGroup();
        cGroup.add(colorDuplication);
        cGroup.add(colorSpecies);
        cGroup.add(colorHorizontalTransfer);
        colorDuplication.addItemListener(new TreeColorListener(TreeModel.TreeColorSchema.DUPLICATION));
        colorSpecies.addItemListener(new TreeColorListener(TreeModel.TreeColorSchema.SPECIES_CLS));
        colorHorizontalTransfer.addItemListener(new TreeColorListener(TreeModel.TreeColorSchema.HORIZONTAL_TRANSFER));
        coloring.add(colorDuplication);
        coloring.add(colorSpecies);
        coloring.add(colorHorizontalTransfer);
        this.add(coloring);
        EventManager.inst().registerFamilyListener(this);
    }

    @Override
    public void newFamilyData(FamilyChangeEvent e) {
        this.species_order.setSelected(true);
    }

    private class TreeReorderListener
    implements ItemListener {
        int action;

        TreeReorderListener(int action) {
            this.action = action;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            TreePanel tree;
            if (e.getStateChange() == 1 && (tree = PaintManager.inst().getTree()) != null) {
                switch (this.action) {
                    case 205: {
                        tree.speciesOrder();
                        break;
                    }
                    case 206: {
                        tree.descendentCountLadder(true);
                        break;
                    }
                    case 207: {
                        tree.descendentCountLadder(false);
                    }
                }
            }
        }
    }

    private class TreeColorListener
    implements ItemListener {
        TreeModel.TreeColorSchema colSchema;

        TreeColorListener(TreeModel.TreeColorSchema colSchema) {
            this.colSchema = colSchema;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (1 != e.getStateChange()) {
                return;
            }
            PaintManager.inst().getTree().updateColoring(this.colSchema);
        }
    }

    private class TreeActionListener
    implements ActionListener {
        int action;

        TreeActionListener(int action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePanel tree = PaintManager.inst().getTree();
            if (tree != null) {
                switch (this.action) {
                    case 204: {
                        Preferences.inst().toggleUseDistances();
                        tree.adjustTree();
                        break;
                    }
                    case 202: {
                        tree.expandAllNodes();
                        break;
                    }
                    case 201: {
                        tree.collapseNonExperimental();
                        break;
                    }
                    case 203: {
                        tree.resetRootToMain();
                    }
                }
            }
        }
    }

    private class ScaleTreeActionListener
    implements ActionListener {
        private ScaleTreeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScaleTreeDlg scaleTreeDlg = new ScaleTreeDlg((Frame)GUIManager.getManager().getFrame(), Preferences.inst().getTree_distance_scaling());
            Double d = scaleTreeDlg.display();
            if (null == d) {
                return;
            }
            TreePanel tree = PaintManager.inst().getTree();
            if (tree != null) {
                tree.scaleTree(d);
            } else {
                Preferences.inst().setTree_distance_scaling(d);
            }
        }
    }
}

