/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.msa;

import edu.usc.ksom.pm.panther.paintCommon.Domain;
import edu.usc.ksom.pm.panther.paintCommon.KeyResidue;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.gui.msa.AminoAcidStats;
import org.paint.gui.msa.MSAParser;
import org.paint.main.PaintManager;
import org.paint.util.DuplicationColor;

public class MSA {
    public static final char CHAR_DOT = '.';
    public static final char CHAR_DASH = '-';
    private boolean full_length;
    private HashMap<String, HashMap<String, ArrayList<Domain>>> domainLookup;
    private ArrayList<KeyResidue> keyResidueList;
    private MSA_DISPLAY displayType = MSA_DISPLAY.NONE;
    private boolean have_weights;
    private boolean haveSeq;
    private boolean haveDomain;
    private boolean haveKeyResidue;
    private MSAParser msaParser = null;
    private Hashtable<GeneNode, Color[]> nodeToColor = new Hashtable();
    private static final String msaFont = "Monospaced";
    private static Logger log = Logger.getLogger(MSA.class);
    private boolean colors_initialized = false;
    private Font font;
    private AminoAcidStats[] aminoAcidStats;
    private int selectedCol = -1;
    private int[] seq_range;
    private static final int START_BASE = 0;
    private static final int END_BASE = 1;
    private HashMap<String, Color> domainToColorLookup;
    private HashMap<String, Color> lightDomainColorLookup;
    private int DEFAULT_DOMAIN_HEIGHT = 5;
    private HashSet<String> domainSet;
    private int maxDomainRows = 0;
    private static final Color selectedColor = Color.PINK;
    private static final Color COLOR_GREEN = new Color(50, 168, 82);
    private static final Color COLOR_MAGENTA = new Color(255, 0, 255);
    private static final HashMap<KeyResidue.ResidueType, Color> RESIDUE_LOOKUP = MSA.initResidueLookup();

    private static HashMap<KeyResidue.ResidueType, Color> initResidueLookup() {
        HashMap<KeyResidue.ResidueType, Color> rtnLookup = new HashMap<KeyResidue.ResidueType, Color>();
        rtnLookup.put(KeyResidue.ResidueType.ACT_SITE, Color.BLACK);
        rtnLookup.put(KeyResidue.ResidueType.BINDING, Color.RED);
        rtnLookup.put(KeyResidue.ResidueType.METAL, Color.ORANGE);
        return rtnLookup;
    }

    public MSA(String[] msaInfo, String[] wtsInfo, HashMap<String, HashMap<String, ArrayList<Domain>>> domainLookup, ArrayList<KeyResidue> keyResidueList) {
        this.msaParser = new MSAParser();
        if (null != msaInfo && 0 != msaInfo.length) {
            this.haveSeq = true;
            this.msaParser.parseSeqs(msaInfo);
            this.displayType = MSA_DISPLAY.ENTIRE_ALIGNMENT;
        }
        this.domainLookup = domainLookup;
        this.setupDomainData();
        this.keyResidueList = keyResidueList;
        this.setupKeyResidueList();
        this.have_weights = false;
        this.full_length = true;
        Font f = Preferences.inst().getFont();
        this.setFont(new Font(msaFont, f.getStyle(), f.getSize()));
        this.setColors();
    }

    protected void setupKeyResidueList() {
        if (null == this.keyResidueList) {
            this.haveKeyResidue = false;
            return;
        }
        PaintManager manager = PaintManager.inst();
        List<GeneNode> nodes = manager.getTree().getAllNodes();
        for (GeneNode gn : nodes) {
            String protId = gn.getSeqId();
            for (KeyResidue kr : this.keyResidueList) {
                String protein = kr.getProtein();
                if (null == protId || !protId.equals(protein)) continue;
                ArrayList<Object> list = gn.getKeyResidueList();
                if (null == list) {
                    list = new ArrayList();
                    gn.setKeyResidueList(list);
                    this.haveKeyResidue = true;
                }
                list.add(kr);
            }
        }
    }

    protected void setupDomainData() {
        if (null == this.domainLookup) {
            this.haveDomain = false;
            return;
        }
        PaintManager manager = PaintManager.inst();
        this.domainToColorLookup = new HashMap();
        this.lightDomainColorLookup = new HashMap();
        this.domainSet = new HashSet();
        for (Map.Entry<String, HashMap<String, ArrayList<Domain>>> entry : this.domainLookup.entrySet()) {
            GeneNode gn;
            HashMap<String, ArrayList<Domain>> geneDomainLookup = entry.getValue();
            if (null == geneDomainLookup || null == (gn = manager.getGeneByPaintId(entry.getKey()))) continue;
            gn.setDomainLookup(geneDomainLookup);
            this.domainSet.addAll(geneDomainLookup.keySet());
            ArrayList<Domain> domainsForGene = new ArrayList<Domain>();
            for (ArrayList<Domain> dList : geneDomainLookup.values()) {
                domainsForGene.addAll(dList);
            }
            ArrayList<ArrayList<Domain>> domainRows = MSA.groupWithoutOverlap(domainsForGene);
            gn.setDomainRows(domainRows);
        }
        List<Color> colors = DuplicationColor.inst().getPastelColors();
        int i = 0;
        for (String domainStr : this.domainSet) {
            if (i == 0) {
                this.domainToColorLookup.put(domainStr, DuplicationColor.LIGHT_STEEL_BLUE);
                this.lightDomainColorLookup.put(domainStr, DuplicationColor.LIGHT_STEEL_BLUE);
                ++i;
                continue;
            }
            if (i >= colors.size()) {
                int index = i / colors.size();
                Color atIndex = DuplicationColor.inst().getDarkerColor(colors.get(index));
                this.domainToColorLookup.put(domainStr, DuplicationColor.inst().getDarkerColor(atIndex));
                this.lightDomainColorLookup.put(domainStr, atIndex);
            } else {
                this.domainToColorLookup.put(domainStr, DuplicationColor.inst().getDarkerColor(colors.get(i)));
                this.lightDomainColorLookup.put(domainStr, colors.get(i));
            }
            ++i;
        }
    }

    protected static boolean domainsOverlap(ArrayList<Domain> list1, ArrayList<Domain> list2) {
        for (Domain l1d : list1) {
            for (Domain l2d : list2) {
                if (!MSA.overlap(l1d.getStart(), l1d.getEnd(), l2d.getStart(), l2d.getEnd())) continue;
                return true;
            }
        }
        return false;
    }

    protected void reorderRows(List<GeneNode> node_list) {
    }

    protected void setFont(Font f) {
        this.font = f;
    }

    protected boolean isFullLength() {
        return this.full_length;
    }

    protected void setFullLength(boolean full) {
        this.full_length = full;
    }

    protected void updateColors() {
        this.colors_initialized = false;
    }

    public void draw(Graphics g, Rectangle viewport) {
        if (g == null) {
            return;
        }
        this.setColors();
        if (!this.colors_initialized) {
            g.drawString("No display specified", 100, 100);
            return;
        }
        if (MSA_DISPLAY.DOMAIN == this.displayType) {
            this.displayDomain(g, viewport);
            return;
        }
        if (MSA_DISPLAY.DOMAIN_TRIMMED == this.displayType) {
            this.displayDomainTrimmed(g, viewport);
            return;
        }
        this.displayPid(g, viewport);
    }

    public Rectangle getGridSize(Graphics g) {
        if (null == this.font) {
            return null;
        }
        PaintManager pm = PaintManager.inst();
        Rectangle r = new Rectangle();
        int row_height = pm.getRowHeight();
        int colWidth = this.getColumnWidth(g);
        if (row_height == 0) {
            log.warn((Object)"Row height is not set");
            row_height = 16;
        }
        r.height = row_height + pm.getTopMargin();
        r.width = 0;
        List<GeneNode> contents = PaintManager.inst().getTree().getTerminusNodes();
        if (contents != null) {
            r.height += contents.size() * row_height;
            r.width += this.msaParser.getSeqLength(this.full_length) * colWidth;
        }
        return r;
    }

    private void displayPid(Graphics g, Rectangle viewport) {
        int seq_x_position;
        List<GeneNode> contents = PaintManager.inst().getTree().getTerminusNodes();
        if (contents == null || contents.size() == 0) {
            return;
        }
        g.setFont(this.font);
        int row_height = PaintManager.inst().getRowHeight();
        int curHeight = PaintManager.inst().getTopMargin();
        int charWidth = this.getColumnWidth(g);
        int headerHeight = PaintManager.inst().getTopMargin();
        int topInset = (headerHeight - this.font.getSize()) / 2;
        int header_y = viewport.y + headerHeight - topInset - 1;
        if (Color.white != g.getColor()) {
            g.setColor(Color.white);
        }
        g.fillRect(viewport.x, viewport.y, viewport.width, headerHeight - topInset - 1);
        g.setColor(Color.black);
        this.seq_range = this.setSeqRange(viewport, charWidth, this.msaParser.getSeqLength(this.full_length));
        int column_x = seq_x_position = viewport.x;
        char[] ruler = this.msaParser.getRuler(this.full_length);
        for (int column = this.seq_range[0]; column < this.seq_range[1]; ++column) {
            g.drawChars(ruler, column, 1, column_x, header_y);
            column_x += charWidth;
        }
        for (int row = 0; row < contents.size(); ++row) {
            GeneNode node = contents.get(row);
            if (!node.isTerminus()) continue;
            if (viewport.y > curHeight + row_height || viewport.y + viewport.height < curHeight) {
                curHeight += row_height;
                continue;
            }
            String seq = null;
            boolean hmm = false;
            if (this.full_length) {
                seq = node.getSequence();
            } else {
                seq = node.getHMMSeq();
                hmm = true;
            }
            if (null == seq || 0 == seq.length()) {
                curHeight += row_height;
                continue;
            }
            Color[] nodeColors = this.nodeToColor.get(node);
            if (null == nodeColors) {
                curHeight += row_height;
                continue;
            }
            if (node.isPruned()) {
                curHeight += row_height;
                continue;
            }
            Font bold = new Font(msaFont, 1, this.font.getSize());
            ArrayList<KeyResidue> krList = node.getKeyResidueList();
            Font f = node.isSelected() || MSA_DISPLAY.KEY_RESIDUE == this.displayType && null != krList && 0 != krList.size() ? bold : this.font;
            column_x = seq_x_position;
            int seq_y = curHeight + row_height - topInset - 1;
            char[] seq_chars = seq.toCharArray();
            for (int column = this.seq_range[0]; column < this.seq_range[1]; ++column) {
                Color color = null;
                color = false == hmm ? nodeColors[column] : nodeColors[this.msaParser.getMatchPosIndex().get(column)];
                if (column == this.selectedCol) {
                    color = selectedColor;
                }
                g.setColor(color);
                g.fillRect(column_x, curHeight, charWidth, row_height);
                if (MSA_DISPLAY.KEY_RESIDUE == this.displayType) {
                    g.setColor(Color.LIGHT_GRAY);
                    if (node.isSelected()) {
                        g.setColor(Color.GRAY);
                    }
                    if (null != krList && 0 != krList.size()) {
                        HashSet<Color> multiples = new HashSet<Color>();
                        for (KeyResidue kr : krList) {
                            if (column != kr.getAlignPos() - 1) continue;
                            g.setColor(RESIDUE_LOOKUP.get(kr.getResidueType()));
                            multiples.add(g.getColor());
                        }
                        if (multiples.size() > 1) {
                            g.setColor(COLOR_MAGENTA);
                        }
                    }
                } else {
                    g.setColor(Color.BLACK);
                }
                g.setFont(f);
                g.drawChars(seq_chars, column, 1, column_x, seq_y);
                column_x += charWidth;
            }
            curHeight += row_height;
        }
    }

    private void displayDomain(Graphics g, Rectangle viewport) {
        int seq_x_position;
        List<GeneNode> contents = PaintManager.inst().getTree().getTerminusNodes();
        if (contents == null || contents.isEmpty()) {
            return;
        }
        g.setFont(this.font);
        int row_height = PaintManager.inst().getRowHeight();
        int curHeight = PaintManager.inst().getTopMargin();
        double domainHeight = this.DEFAULT_DOMAIN_HEIGHT;
        if (0 != this.maxDomainRows) {
            domainHeight = row_height / this.maxDomainRows;
            if (1 == this.maxDomainRows || domainHeight > (double)this.DEFAULT_DOMAIN_HEIGHT) {
                domainHeight = this.DEFAULT_DOMAIN_HEIGHT;
            }
        }
        int domainHeightInt = new Double(domainHeight).intValue();
        int charWidth = this.getColumnWidth(g);
        int headerHeight = PaintManager.inst().getTopMargin();
        int topInset = (headerHeight - this.font.getSize()) / 2;
        int header_y = viewport.y + headerHeight - topInset - 1;
        if (Color.white != g.getColor()) {
            g.setColor(Color.white);
        }
        g.fillRect(viewport.x, viewport.y, viewport.width, headerHeight - topInset - 1);
        g.setColor(Color.black);
        this.seq_range = this.setSeqRange(viewport, charWidth, this.aminoAcidStats.length);
        int column_x = seq_x_position = viewport.x;
        char[] ruler = this.msaParser.getRuler(this.full_length);
        for (int column = this.seq_range[0]; column < this.seq_range[1]; ++column) {
            g.drawChars(ruler, column, 1, column_x, header_y);
            column_x += charWidth;
        }
        for (int row = 0; row < contents.size(); ++row) {
            String seq;
            GeneNode node = contents.get(row);
            if (!node.isTerminus()) continue;
            if (viewport.y > curHeight + row_height || viewport.y + viewport.height < curHeight) {
                curHeight += row_height;
                continue;
            }
            String string = seq = this.full_length ? node.getSequence() : node.getHMMSeq();
            if (null == seq || 0 == seq.length()) {
                curHeight += row_height;
                continue;
            }
            if (node.isPruned()) {
                curHeight += row_height;
                continue;
            }
            ArrayList<ArrayList<Domain>> domainRows = node.getDomainRows();
            HashMap<String, ArrayList<Domain>> domainLookup = node.getDomainLookup();
            if (null == domainRows || null == domainLookup || 0 == domainRows.size() || 0 == domainLookup.size()) {
                curHeight += row_height;
                continue;
            }
            for (int i = 0; i < domainRows.size(); ++i) {
                ArrayList<Domain> curRow = domainRows.get(i);
                double domainPosStart = domainHeight * (double)i;
                int height = new Double(domainPosStart).intValue() + curHeight;
                for (Domain d : curRow) {
                    g.setColor(this.domainToColorLookup.get(d.getHmmAcc()));
                    int startPos = MSA.getPosition(seq, d.getStart());
                    int endPos = MSA.getPosition(seq, d.getEnd());
                    if (startPos < 0 || endPos < 0) continue;
                    g.fillRect(startPos * charWidth, height, (endPos - startPos + 1) * charWidth, domainHeightInt);
                    ArrayList<Point> dotDashRanges = MSA.getDotDashRanges(seq, startPos, endPos);
                    if (null == dotDashRanges) continue;
                    for (Point range : dotDashRanges) {
                        g.setColor(this.lightDomainColorLookup.get(d.getHmmAcc()));
                        g.fillRect(range.x * charWidth, height, (range.y - range.x + 1) * charWidth, domainHeightInt);
                    }
                }
            }
            Font f = node.isSelected() ? new Font(msaFont, 1, this.font.getSize()) : this.font;
            column_x = seq_x_position;
            int seq_y = curHeight + row_height - topInset - 1;
            char[] seq_chars = seq.toCharArray();
            for (int column = this.seq_range[0]; column < this.seq_range[1]; ++column) {
                g.setColor(Color.LIGHT_GRAY);
                g.setFont(f);
                g.drawChars(seq_chars, column, 1, column_x, seq_y);
                column_x += charWidth;
            }
            curHeight += row_height;
        }
    }

    private void displayDomainTrimmed(Graphics g, Rectangle viewport) {
        int seq_x_position;
        List<GeneNode> contents = PaintManager.inst().getTree().getTerminusNodes();
        if (contents == null || contents.size() == 0) {
            return;
        }
        g.setFont(this.font);
        int row_height = PaintManager.inst().getRowHeight();
        int curHeight = PaintManager.inst().getTopMargin();
        double domainHeight = this.DEFAULT_DOMAIN_HEIGHT;
        if (0 != this.maxDomainRows) {
            domainHeight = row_height / this.maxDomainRows;
            if (1 == this.maxDomainRows || domainHeight > (double)this.DEFAULT_DOMAIN_HEIGHT) {
                domainHeight = this.DEFAULT_DOMAIN_HEIGHT;
            }
        }
        int domainHeightInt = new Double(domainHeight).intValue();
        int charWidth = this.getColumnWidth(g);
        this.seq_range = this.setSeqRange(viewport, charWidth, this.aminoAcidStats.length);
        int column_x = seq_x_position = viewport.x;
        for (int row = 0; row < contents.size(); ++row) {
            String seq;
            GeneNode node = contents.get(row);
            if (!node.isTerminus()) continue;
            if (viewport.y > curHeight + row_height || viewport.y + viewport.height < curHeight) {
                curHeight += row_height;
                continue;
            }
            String string = seq = this.full_length ? node.getSequence() : node.getHMMSeq();
            if (null == seq || 0 == seq.length()) {
                curHeight += row_height;
                continue;
            }
            if (node.isPruned()) {
                curHeight += row_height;
                continue;
            }
            ArrayList<ArrayList<Domain>> domainRows = node.getDomainRows();
            HashMap<String, ArrayList<Domain>> domainLookup = node.getDomainLookup();
            if (null == domainRows || null == domainLookup || 0 == domainRows.size() || 0 == domainLookup.size()) {
                curHeight += row_height;
                continue;
            }
            for (int i = 0; i < domainRows.size(); ++i) {
                ArrayList<Domain> curRow = domainRows.get(i);
                double domainPosStart = domainHeight * (double)i;
                int height = new Double(domainPosStart).intValue() + curHeight;
                for (Domain d : curRow) {
                    g.setColor(this.domainToColorLookup.get(d.getHmmAcc()));
                    int startPos = MSA.getPosition(seq, d.getStart());
                    int endPos = MSA.getPosition(seq, d.getEnd());
                    if (startPos < 0 || endPos < 0) continue;
                    g.fillRect(startPos * charWidth, height, (endPos - startPos + 1) * charWidth, domainHeightInt);
                }
            }
            curHeight += row_height;
        }
    }

    public static ArrayList<Point> getDotDashRanges(String seq, int start, int end) {
        StringBuffer sb = new StringBuffer();
        ArrayList<Point> ranges = new ArrayList<Point>();
        Point p = null;
        for (int i = start; i <= end; ++i) {
            char c = seq.charAt(i);
            if ('.' == c || '-' == c) {
                if (null == p) {
                    p = new Point();
                    p.x = i;
                }
                p.y = i;
                continue;
            }
            sb.append(c);
            if (null == p) continue;
            ranges.add((Point)p.clone());
            p = null;
        }
        if (null != p) {
            ranges.add(p);
        }
        return ranges;
    }

    private int[] setSeqRange(Rectangle viewport, int charWidth, int seqMaxLen) {
        this.seq_range = new int[2];
        this.seq_range[0] = (viewport.x + 1) / charWidth - 1;
        this.seq_range[0] = Math.max(0, this.seq_range[0]);
        this.seq_range[1] = this.seq_range[0] + viewport.width / charWidth + 1;
        if (this.seq_range[1] >= seqMaxLen) {
            this.seq_range[1] = seqMaxLen - 1;
        }
        if (this.seq_range[0] >= seqMaxLen) {
            this.seq_range[0] = seqMaxLen - 1;
        }
        return this.seq_range;
    }

    private void setColors() {
        if (this.colors_initialized) {
            return;
        }
        this.initColumnWeights(false);
        this.colors_initialized = this.setUnweightedColor();
    }

    private boolean setUnweightedColor() {
        this.nodeToColor.clear();
        List<GeneNode> contents = PaintManager.inst().getTree().getTerminusNodes();
        Color[] colors = Preferences.inst().getMSAColors(false);
        float[] threshold = Preferences.inst().getMSAThresholds(false);
        int row_count = contents.size();
        for (int row = 0; row < row_count; ++row) {
            int seqLength;
            GeneNode node = contents.get(row);
            String seq = node.getSequence();
            Color[] columnColors = null;
            if (seq == null) {
                seqLength = -1;
            } else {
                seqLength = seq.length();
                columnColors = new Color[seqLength];
            }
            block1: for (int column = 0; column < seqLength; ++column) {
                columnColors[column] = Color.WHITE;
                char c = seq.charAt(column);
                if (c == '.' || c == '-' || c == ' ') continue;
                AminoAcidStats alignStats = null;
                alignStats = this.aminoAcidStats[column];
                double frequency = alignStats.getAAFrequency(c);
                double weight = frequency * 100.0 / (double)row_count;
                for (int k = 0; k < threshold.length; ++k) {
                    if (!(weight > (double)threshold[k])) continue;
                    columnColors[column] = colors[k];
                    continue block1;
                }
            }
            if (null == node || null == columnColors) continue;
            this.nodeToColor.put(node, columnColors);
        }
        return true;
    }

    private boolean setWeightedColor(double totalWt) {
        this.nodeToColor.clear();
        List<GeneNode> contents = PaintManager.inst().getTree().getTerminusNodes();
        Color[] colors = Preferences.inst().getMSAColors(true);
        float[] threshold = Preferences.inst().getMSAThresholds(true);
        for (int row = 0; row < contents.size(); ++row) {
            String seq;
            GeneNode node = contents.get(row);
            String string = seq = this.full_length ? node.getSequence() : node.getHMMSeq();
            if (!node.isTerminus() || seq == null) continue;
            int seqLength = seq.length();
            Color[] columnColors = new Color[seqLength];
            block1: for (int column = 0; column < seqLength; ++column) {
                columnColors[column] = Color.WHITE;
                char c = seq.charAt(column);
                if (c == '-' || c == '.') continue;
                AminoAcidStats alignStats = this.aminoAcidStats[column];
                double weight = alignStats.getAAFrequency(c);
                double percent = 0.0;
                percent = weight / totalWt * 100.0;
                for (int k = 0; k < threshold.length; ++k) {
                    if (!(percent > (double)threshold[k])) continue;
                    columnColors[column] = colors[k];
                    continue block1;
                }
            }
            this.nodeToColor.put(node, columnColors);
        }
        return true;
    }

    public int getCol(Point p, Graphics g, Rectangle viewport) {
        if (null == g || null == p || null == viewport) {
            return -1;
        }
        double sampleWidth = this.getExactColumnWidth(g, this.msaParser.getSampleSeq());
        int size = this.msaParser.getSeq_length();
        return (int)((double)(p.x - viewport.x) / (sampleWidth / (double)size)) + this.seq_range[0];
    }

    protected boolean setSelectedColInfo(Point p, Graphics g, Rectangle viewport) {
        int col = this.getCol(p, g, viewport);
        if (col < 0) {
            return false;
        }
        this.selectedCol = col;
        return true;
    }

    public ArrayList<Domain> getDomains(Point p, Graphics g) {
        if (null == g || null == p) {
            return null;
        }
        GeneNode node = this.getSelectedGene(p, g);
        if (null == node) {
            return null;
        }
        int charWidth = this.getColumnWidth(g);
        int selected = -1;
        int length = this.msaParser.getSeqLength(this.full_length) * charWidth;
        if (0 <= p.x && p.x <= length) {
            selected = p.x / charWidth;
        }
        ArrayList<Domain> rtnList = new ArrayList<Domain>();
        HashMap<String, ArrayList<Domain>> lookup = node.getDomainLookup();
        if (null == lookup) {
            return rtnList;
        }
        for (ArrayList<Domain> domainArray : lookup.values()) {
            for (Domain d : domainArray) {
                if (MSA.getPosition(node.getSequence(), d.getStart()) > selected || selected > MSA.getPosition(node.getSequence(), d.getEnd())) continue;
                rtnList.add(d);
            }
        }
        return rtnList;
    }

    public ArrayList<KeyResidue> getKeyResidue(Point p, Graphics g, Rectangle viewport) {
        if (null == g || null == p || MSA_DISPLAY.KEY_RESIDUE != this.getDisplayType()) {
            return null;
        }
        GeneNode node = this.getSelectedGene(p, g);
        if (null == node) {
            return null;
        }
        ArrayList<KeyResidue> krList = node.getKeyResidueList();
        if (null == krList || 0 == krList.size()) {
            return null;
        }
        int selected = this.getCol(p, g, viewport);
        ArrayList<KeyResidue> rtnList = new ArrayList<KeyResidue>();
        for (KeyResidue kr : krList) {
            if (kr.getAlignPos() - 1 != selected) continue;
            rtnList.add(kr);
        }
        if (rtnList.isEmpty()) {
            return null;
        }
        return rtnList;
    }

    protected GeneNode getSelectedGene(Point p, Graphics g) {
        int row;
        if (null == g) {
            return null;
        }
        int charWidth = this.getColumnWidth(g);
        int header_width = this.msaParser.getSeqLength(this.full_length) * charWidth;
        int cur_y = PaintManager.inst().getTopMargin();
        int right_x = header_width + this.seq_range[0] * charWidth;
        if (p.x > right_x || p.y <= cur_y) {
            return null;
        }
        List<GeneNode> contents = PaintManager.inst().getTree().getTerminusNodes();
        int row_height = PaintManager.inst().getRowHeight();
        for (row = 0; p.y > cur_y + row_height && row < contents.size(); ++row) {
            cur_y += row_height;
        }
        if (row < contents.size()) {
            return contents.get(row);
        }
        return null;
    }

    protected int getColumnWidth(Graphics g) {
        if (MSA_DISPLAY.DOMAIN_TRIMMED == this.displayType) {
            return 1;
        }
        return g.getFontMetrics(this.font).stringWidth("W");
    }

    protected double getExactColumnWidth(Graphics g, String text) {
        if (MSA_DISPLAY.DOMAIN_TRIMMED == this.displayType) {
            return 1.0;
        }
        if (!(g instanceof Graphics2D)) {
            return g.getFontMetrics(this.font).stringWidth(text);
        }
        Graphics2D graphics2d = (Graphics2D)g;
        FontRenderContext context = graphics2d.getFontRenderContext();
        return this.font.getStringBounds(text, context).getWidth();
    }

    protected Rectangle getSelectionRect(Graphics g, Collection<GeneNode> nodes) {
        if (nodes != null && !nodes.isEmpty() && this.seq_range != null) {
            int min_row = -1;
            int max_row = -1;
            List<GeneNode> contents = PaintManager.inst().getTree().getTerminusNodes();
            for (GeneNode node : nodes) {
                int row = contents.indexOf(node);
                if (min_row < 0 || row < min_row) {
                    min_row = row;
                }
                if (max_row >= 0 && row <= max_row) continue;
                max_row = row;
            }
            int charWidth = this.getColumnWidth(g);
            int x = this.seq_range[0] * charWidth;
            int width = (this.seq_range[1] - this.seq_range[0]) * charWidth;
            int row_height = PaintManager.inst().getRowHeight();
            int y = PaintManager.inst().getTopMargin() + min_row * row_height;
            int height = (max_row - min_row + 1) * row_height;
            Rectangle rect = new Rectangle(x, y, width, height);
            return rect;
        }
        return null;
    }

    private double initColumnWeights(boolean weighted) {
        int seq_length = this.msaParser.getSeq_length();
        this.aminoAcidStats = new AminoAcidStats[seq_length];
        double totalWt = 0.0;
        List<GeneNode> contents = PaintManager.inst().getTree().getTerminusNodes();
        for (int column = 0; column < seq_length; ++column) {
            AminoAcidStats alignStats = this.aminoAcidStats[column];
            if (alignStats == null) {
                this.aminoAcidStats[column] = alignStats = new AminoAcidStats();
            }
            for (GeneNode node : contents) {
                String sequence;
                if (column == 0) {
                    totalWt += node.getSequenceWt();
                }
                if ((sequence = node.getSequence()) == null || sequence.length() <= column) continue;
                char aa = sequence.charAt(column);
                double align_frequency = alignStats.getAAFrequency(aa);
                align_frequency = weighted ? (align_frequency += node.getSequenceWt()) : (align_frequency += 1.0);
                alignStats.setAAFrequency(aa, align_frequency);
            }
        }
        return totalWt;
    }

    protected void setWeighted(boolean weighted) {
        MSA_DISPLAY type = weighted ? MSA_DISPLAY.WEIGHTED : MSA_DISPLAY.ENTIRE_ALIGNMENT;
        this.colors_initialized = this.displayType == type;
        this.displayType = type;
    }

    protected boolean isWeighted() {
        return this.have_weights && this.displayType == MSA_DISPLAY.WEIGHTED;
    }

    protected boolean haveWeights() {
        return this.have_weights;
    }

    public boolean haveFullAlignData() {
        return this.haveSeq;
    }

    public boolean haveTrimmedAlignData() {
        return this.haveSeq;
    }

    public boolean haveDomainInfo() {
        return null != this.domainLookup;
    }

    public void setDisplayType(MSA_DISPLAY displayType) {
        this.displayType = displayType;
    }

    public MSA_DISPLAY getDisplayType() {
        return this.displayType;
    }

    public static int getPosition(String seq, int pos) {
        int seqPos = -1;
        if (null == seq || pos < 0) {
            return seqPos;
        }
        seqPos = 0;
        for (int i = 0; i < seq.length(); ++i) {
            char c = seq.charAt(i);
            if (c != '.' && c != '-') {
                ++seqPos;
            }
            if (seqPos != pos) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList<ArrayList<Domain>> groupWithoutOverlap(ArrayList<Domain> domainList) {
        if (null == domainList) {
            return null;
        }
        HashMap<String, ArrayList<Domain>> domainLookup = new HashMap<String, ArrayList<Domain>>();
        for (Domain d : domainList) {
            ArrayList<Domain> astList = (ArrayList<Domain>)domainLookup.get(d.getHmmAcc());
            if (null == astList) {
                astList = new ArrayList<Domain>();
                domainLookup.put(d.getHmmAcc(), astList);
            }
            astList.add(d);
        }
        ArrayList<ArrayList<Domain>> rtnList = new ArrayList<ArrayList<Domain>>();
        for (String domainAcc : domainLookup.keySet()) {
            DomainGroup dg = new DomainGroup((ArrayList)domainLookup.get(domainAcc));
            if (1 == dg.entries.size()) {
                boolean inserted = false;
                for (int i = 0; i < rtnList.size(); ++i) {
                    if (MSA.domainsOverlap(rtnList.get(i), (ArrayList)domainLookup.get(domainAcc))) continue;
                    ArrayList<Domain> cur = rtnList.get(i);
                    cur.addAll((Collection)domainLookup.get(domainAcc));
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                rtnList.add((ArrayList)domainLookup.get(domainAcc));
                continue;
            }
            for (ArrayList<Domain> entry : dg.entries) {
                boolean inserted = false;
                for (int i = 0; i < rtnList.size(); ++i) {
                    if (MSA.domainsOverlap(rtnList.get(i), entry)) continue;
                    ArrayList<Domain> cur = rtnList.get(i);
                    cur.addAll(entry);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                rtnList.add(entry);
            }
        }
        return rtnList;
    }

    protected static boolean overlap(int a, int b, int c, int d) {
        return a <= d && b >= c;
    }

    public static void main(String[] args) {
        String seq = "AFERERWRWRIOURWPIZVNMCGFGFG";
        System.out.println("Seq =  " + seq);
        int start = 5;
        int end = 8;
        ArrayList<Point> ranges = MSA.getDotDashRanges(seq, MSA.getPosition(seq, start), MSA.getPosition(seq, end));
        seq = "A......AFER...ER..WRWRIOURWPIZVNMCGFGFG";
        System.out.println("Seq =  " + seq);
        start = 1;
        end = 8;
        ranges = MSA.getDotDashRanges(seq, MSA.getPosition(seq, start), MSA.getPosition(seq, end));
        seq = ".......AFER...ER..WRWRIOURWPIZVNMCGFGFG";
        System.out.println("Seq =  " + seq);
        start = 1;
        end = 8;
        ranges = MSA.getDotDashRanges(seq, MSA.getPosition(seq, start), MSA.getPosition(seq, end));
        seq = "ABC.....AFER...ER..WRWRIOURWPIZVNMCGFGFG";
        System.out.println("Seq =  " + seq);
        start = 1;
        end = 8;
        ranges = MSA.getDotDashRanges(seq, MSA.getPosition(seq, start), MSA.getPosition(seq, end));
    }

    public boolean haveHaveKeyResidueInfo() {
        return this.haveKeyResidue;
    }

    public static class DomainGroup {
        public ArrayList<Domain> domainList;
        public ArrayList<ArrayList<Domain>> entries;

        public DomainGroup(ArrayList<Domain> domainList) {
            if (null == domainList) {
                return;
            }
            this.domainList = domainList;
            this.entries = new ArrayList();
            this.entries.add(this.domainList);
            for (int i = 0; i < this.entries.size(); ++i) {
                ArrayList<Domain> current = this.entries.get(i);
                Domain first = current.get(0);
                for (int j = 1; j < current.size(); ++j) {
                    if (!MSA.overlap(first.getStart(), first.getEnd(), current.get(j).getStart(), current.get(j).getEnd())) continue;
                    ArrayList<Domain> newRow = new ArrayList<Domain>();
                    newRow.add(current.remove(j));
                    --j;
                    this.entries.add(newRow);
                }
            }
        }
    }

    public static enum MSA_DISPLAY {
        ENTIRE_ALIGNMENT,
        TRIMMED,
        DOMAIN,
        DOMAIN_TRIMMED,
        WEIGHTED,
        NONE,
        KEY_RESIDUE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

