/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.msa;

import com.sri.panther.paintCommon.util.Utils;
import edu.usc.ksom.pm.panther.paintCommon.Domain;
import edu.usc.ksom.pm.panther.paintCommon.KeyResidue;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import org.apache.log4j.Logger;
import org.paint.datamodel.GeneNode;
import org.paint.gui.FamilyViews;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.GeneSelectEvent;
import org.paint.gui.event.GeneSelectListener;
import org.paint.gui.event.NodeReorderEvent;
import org.paint.gui.event.NodeReorderListener;
import org.paint.gui.msa.MSA;
import org.paint.main.PaintManager;
import org.paint.util.HTMLUtil;

public class MSAPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
Scrollable,
GeneSelectListener,
NodeReorderListener {
    private static final long serialVersionUID = 1L;
    private MSA msa;
    private static Logger log = Logger.getLogger(MSAPanel.class);

    public MSAPanel() {
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        EventManager manager = EventManager.inst();
        manager.registerGeneListener(this);
        manager.registerNodeReorderListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (null == this.msa) {
            return;
        }
        this.msa.draw(g, ((JScrollPane)this.getParent().getParent()).getViewport().getViewRect());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int modifiers;
        if (null == this.msa) {
            return;
        }
        Graphics g = this.getGraphics();
        Point p = e.getPoint();
        if ((MSA.MSA_DISPLAY.DOMAIN == this.msa.getDisplayType() || MSA.MSA_DISPLAY.DOMAIN_TRIMMED == this.msa.getDisplayType()) && ((modifiers = e.getModifiers()) & 0x10) != 0 && (modifiers & 4) == 0) {
            ArrayList<Domain> domainList = this.msa.getDomains(p, g);
            HashSet<String> processedSet = new HashSet<String>();
            if (null != domainList) {
                for (Domain d : domainList) {
                    String acc = d.getHmmAcc();
                    if (!processedSet.contains(acc)) {
                        try {
                            HTMLUtil.bringUpInBrowser(new URL(Domain.getPFAMDomainUrl((String)acc)));
                        }
                        catch (MalformedURLException mfe) {
                            mfe.printStackTrace();
                        }
                    }
                    processedSet.add(acc);
                }
            }
        }
        if (MSA.MSA_DISPLAY.DOMAIN_TRIMMED == this.msa.getDisplayType()) {
            return;
        }
        if (4 != (e.getModifiers() & 4)) {
            GeneNode node = this.msa.getSelectedGene(p, g);
            if (node != null) {
                ArrayList<GeneNode> selection = new ArrayList<GeneNode>();
                selection.add(node);
                GeneSelectEvent ge = new GeneSelectEvent(this, selection, node);
                EventManager.inst().fireGeneEvent(ge);
            }
        } else {
            Rectangle rect = ((JScrollPane)this.getParent().getParent()).getViewport().getViewRect();
            if (this.msa.setSelectedColInfo(p, g, rect)) {
                super.paintComponent(g);
                this.msa.draw(g, ((JScrollPane)this.getParent().getParent()).getViewport().getViewRect());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private Dimension getDrawAreaSize() {
        Dimension d = new Dimension(0, 0);
        if (this.msa == null || this.getGraphics() == null) {
            return null;
        }
        Rectangle newRect = this.msa.getGridSize(this.getGraphics());
        if (null != newRect) {
            d.width = newRect.width;
            d.height = newRect.height;
        }
        return d;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.getDrawAreaSize();
        if (d == null || d.width == 0 && d.height == 0) {
            d = super.getPreferredSize();
        } else {
            int pad = FamilyViews.inst().getBottomMargin(3);
            d.height += pad;
        }
        return d;
    }

    @Override
    public void handleGeneSelectEvent(GeneSelectEvent e) {
        if (this.msa == null || e.getPrevious() == e.getGenes()) {
            return;
        }
        this.repaintSelection(e.getPrevious());
        this.repaintSelection(e.getGenes());
    }

    public void handlePruning(GeneNode node) {
        ArrayList<GeneNode> temp = new ArrayList<GeneNode>();
        temp.add(node);
        this.repaintSelection(temp);
    }

    private void repaintSelection(Collection<GeneNode> nodes) {
        Graphics g = this.getGraphics();
        Rectangle rect = this.msa.getSelectionRect(g, nodes);
        if (rect != null) {
            this.repaint(rect);
        }
    }

    @Override
    public void handleNodeReorderEvent(NodeReorderEvent e) {
        if (null == this.msa) {
            return;
        }
        this.msa.reorderRows(e.getNodes());
        this.revalidate();
    }

    public void setWeighted(boolean weighted) {
        if (this.msa != null) {
            this.msa.setWeighted(weighted);
            this.repaint();
        }
    }

    public void setModel(MSA msa) {
        this.msa = msa;
        this.revalidate();
    }

    public boolean isWeighted() {
        if (this.msa != null) {
            return this.msa.isWeighted();
        }
        return false;
    }

    public boolean haveWeights() {
        if (null == this.msa) {
            return false;
        }
        return this.msa.haveWeights();
    }

    public void updateColors() {
        if (null == this.msa) {
            return;
        }
        this.msa.updateColors();
        this.repaint();
    }

    public boolean isFullLength() {
        if (null == this.msa) {
            return false;
        }
        return this.msa.isFullLength();
    }

    public void setFullLength(boolean full) {
        if (this.msa != null) {
            this.msa.setFullLength(full);
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getGraphics() != null && this.msa != null) {
            Rectangle msa_rect = this.msa.getGridSize(this.getGraphics());
            return msa_rect.getSize();
        }
        return new Dimension();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int row_height = PaintManager.inst().getRowHeight();
            int rows = visibleRect.height / row_height;
            return (rows + 1) * row_height;
        }
        int col_width = this.msa.getColumnWidth(this.getGraphics());
        int cols = visibleRect.width / col_width;
        return (cols + 1) * col_width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int newPosition;
        int maxUnitIncrement;
        int currentPosition;
        if (orientation == 1) {
            currentPosition = visibleRect.y;
            maxUnitIncrement = PaintManager.inst().getRowHeight();
        } else {
            currentPosition = visibleRect.x;
            maxUnitIncrement = this.msa.getColumnWidth(this.getGraphics());
        }
        int increment = direction < 0 ? ((newPosition = currentPosition - currentPosition / maxUnitIncrement * maxUnitIncrement) == 0 ? maxUnitIncrement : newPosition) : (currentPosition / maxUnitIncrement + 1) * maxUnitIncrement - currentPosition;
        return increment;
    }

    public MSA getModel() {
        return this.msa;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (null != this.msa) {
            Graphics g = this.getGraphics();
            Point p = e.getPoint();
            if (MSA.MSA_DISPLAY.DOMAIN == this.msa.getDisplayType() || MSA.MSA_DISPLAY.DOMAIN_TRIMMED == this.msa.getDisplayType()) {
                ArrayList<Domain> domainList = this.msa.getDomains(p, g);
                if (null == domainList) {
                    return;
                }
                HashSet<CallSite> domainSet = new HashSet<CallSite>();
                for (Domain d : domainList) {
                    domainSet.add((CallSite)((Object)(d.getHmmName() + " (" + d.getHmmAcc() + " Range " + d.getStart() + " - " + d.getEnd() + " )")));
                }
                GeneNode node = this.msa.getSelectedGene(p, g);
                Object label = "";
                if (null != node && !domainSet.isEmpty()) {
                    label = node.getNodeLabel() + " " + node.getNode().getStaticInfo().getPublicId() + " - ";
                    this.setToolTipText((String)label + Utils.listToString(new Vector(domainSet), (String)"", (String)", "));
                } else {
                    this.setToolTipText((String)label);
                }
            } else if (MSA.MSA_DISPLAY.KEY_RESIDUE == this.msa.getDisplayType()) {
                Rectangle viewRect = ((JScrollPane)this.getParent().getParent()).getViewport().getViewRect();
                ArrayList<KeyResidue> applicableList = this.msa.getKeyResidue(p, g, viewRect);
                if (null != applicableList) {
                    ArrayList<CallSite> dispList = new ArrayList<CallSite>();
                    for (KeyResidue kr : applicableList) {
                        dispList.add((CallSite)((Object)(kr.getResidueType().toString() + " " + kr.getDescription() + kr.getAlignPos())));
                    }
                    GeneNode node = this.msa.getSelectedGene(p, g);
                    String label = node.getNodeLabel() + " " + node.getNode().getStaticInfo().getPublicId() + " - " + String.join((CharSequence)",", dispList);
                    this.setToolTipText(label);
                } else {
                    this.setToolTipText("");
                }
            } else {
                this.setToolTipText("");
            }
        }
    }
}

