/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.msa;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.paint.datamodel.GeneNode;
import org.paint.main.PaintManager;

public class MSAParser {
    private static final String PREFIX_SEQ_START = ">";
    private static Logger log = Logger.getLogger(MSAParser.class);
    private int seq_length;
    private int hmm_length;
    private ArrayList<Boolean> matchPosList;
    private ArrayList<Integer> matchPosIndex;
    private final int SEGMENTS = 25;
    private final int SUB_SEGMENTS = 5;
    private char[] full_ruler;
    private char[] condense_ruler;
    private String sampleSeq;
    private String sampleHmmSeq;

    public void parseSeqs(String[] seqInfo) {
        this.seq_length = 0;
        ArrayList<GeneNode> nodes = new ArrayList<GeneNode>();
        if (null == seqInfo || 0 == seqInfo.length) {
            return;
        }
        PaintManager manager = PaintManager.inst();
        for (int line = 0; line < seqInfo.length; ++line) {
            if (!seqInfo[line].startsWith(PREFIX_SEQ_START) || line + 1 >= seqInfo.length || seqInfo[line + 1].startsWith(PREFIX_SEQ_START)) continue;
            String paint_id = seqInfo[line].replaceFirst(PREFIX_SEQ_START, "");
            GeneNode node = manager.getGeneByPaintId(paint_id);
            if (node == null) {
                log.error((Object)("Unable to get gene " + paint_id + " for MSA data"));
                continue;
            }
            nodes.add(node);
            int start = line + 1;
            StringBuffer sb = new StringBuffer();
            while (start < seqInfo.length) {
                if (null == seqInfo[start]) continue;
                if (seqInfo[start].startsWith(PREFIX_SEQ_START)) break;
                sb.append(seqInfo[start].trim());
                ++start;
                ++line;
            }
            String seq = sb.toString();
            node.setSequence(seq);
            StringBuffer hmmBuf = new StringBuffer();
            for (int i = 0; i < seq.length(); ++i) {
                char c = seq.charAt(i);
                if ((c < 'A' || c > 'Z') && c != '-') continue;
                hmmBuf.append(c);
            }
            node.setHMMSeq(hmmBuf.toString());
            this.sampleHmmSeq = node.getHMMSeq();
            if (this.seq_length != 0 && this.seq_length != seq.length()) {
                log.debug((Object)"The length of the MSA sequences are not the same");
            }
            if (this.seq_length >= seq.length()) continue;
            this.seq_length = seq.length();
            this.sampleSeq = seq;
        }
        this.full_ruler = this.setRuler(this.seq_length);
        this.condense_ruler = this.setCondensedSequences(nodes);
        if (this.seq_length < 25) {
            this.condense_ruler = "Sequence".toCharArray();
        }
    }

    private char[] setRuler(int seqMaxLen) {
        char[] ruler;
        if (seqMaxLen < 25) {
            ruler = "Sequence".toCharArray();
        } else {
            ruler = new char[seqMaxLen];
            for (int i = 0; i < seqMaxLen; ++i) {
                if (0 == (i + 1) % 25) {
                    String s = Integer.toString(i + 1);
                    for (int j = 0; j < s.length(); ++j) {
                        ruler[i - s.length() + j] = s.charAt(j);
                    }
                    ruler[i] = 124;
                    continue;
                }
                ruler[i] = 0 == (i + 1) % 5 ? 39 : 32;
            }
        }
        return ruler;
    }

    protected int getSeqLength(boolean uncondensed) {
        if (uncondensed) {
            return this.seq_length;
        }
        return this.hmm_length;
    }

    protected char[] getRuler(boolean uncondensed) {
        if (uncondensed) {
            return this.full_ruler;
        }
        return this.condense_ruler;
    }

    private char[] setCondensedSequences(List<GeneNode> nodes) {
        int i;
        GeneNode node = nodes.get(0);
        String sequence = node.getSequence();
        if (null == sequence) {
            return null;
        }
        int seqLen = sequence.length();
        if (seqLen != this.seq_length) {
            return null;
        }
        this.matchPosList = new ArrayList(sequence.length());
        this.matchPosIndex = new ArrayList();
        for (int i2 = 0; i2 < this.seq_length; ++i2) {
            char c = sequence.charAt(i2);
            if (c >= 'A' && c <= 'Z' || c == '-') {
                this.matchPosList.add(true);
                this.matchPosIndex.add(i2);
                continue;
            }
            this.matchPosList.add(false);
        }
        this.hmm_length = this.matchPosIndex.size();
        StringBuffer ruler = new StringBuffer();
        int counter = 0;
        for (i = 0; i < this.matchPosList.size(); ++i) {
            if (!this.matchPosList.get(i).booleanValue()) continue;
            if (i > 0 && ++counter % 10 == 0) {
                ruler.append("|");
                String replace = Integer.toString(i) + "|";
                int length = replace.length();
                ruler.replace(ruler.length() - length, ruler.length(), replace);
                continue;
            }
            ruler.append(" ");
        }
        this.condense_ruler = new char[ruler.length()];
        for (i = 0; i < ruler.length(); ++i) {
            this.condense_ruler[i] = ruler.charAt(i);
        }
        return this.condense_ruler;
    }

    private char[] setCondensedSequencesOld(List<GeneNode> nodes) {
        int gap_size = 0;
        StringBuffer ruler = new StringBuffer();
        for (int seq_position = 0; seq_position < this.seq_length; ++seq_position) {
            char c;
            boolean column_needed = false;
            for (int i = 0; i < nodes.size() && !column_needed; ++i) {
                String sequence;
                GeneNode node = nodes.get(i);
                if (node.getSequence() == null || ((c = (sequence = node.getSequence()).charAt(seq_position)) < 'A' || c > 'Z') && c != '-') continue;
                column_needed = true;
            }
            gap_size = column_needed ? 0 : ++gap_size;
            if (gap_size < 6) {
                if (0 == (seq_position + 1) % 10) {
                    String s = Integer.toString(seq_position + 1);
                    int pos = ruler.length() - s.length();
                    ruler.replace(pos, pos + s.length(), s);
                    ruler.append('|');
                } else if (0 == (seq_position + 1) % 5) {
                    ruler.append('\'');
                } else {
                    ruler.append(' ');
                }
            } else if (ruler.charAt(ruler.length() - 1) != '~') {
                int pos = ruler.length() - 5;
                boolean digit = true;
                int end_gap = ruler.lastIndexOf("~");
                if (end_gap > 0) {
                    int start_gap;
                    for (start_gap = end_gap - 1; start_gap > 0 && ruler.charAt(start_gap) == '~'; --start_gap) {
                    }
                    if (ruler.charAt(start_gap) != '~') {
                        ++start_gap;
                    }
                    if (end_gap - start_gap < 4 && pos - 5 < end_gap) {
                        ruler.replace(start_gap, start_gap + 5, "~~~~~");
                    }
                }
                for (int i = pos - 1; i >= 0 && digit; --i) {
                    digit = Character.isDigit(ruler.charAt(i));
                    if (!digit) continue;
                    ruler.setCharAt(i, ' ');
                }
                ruler.replace(pos, pos + 5, "~~~~~");
            }
            block7: for (GeneNode node : nodes) {
                switch (gap_size) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        String sequence = node.getSequence();
                        c = sequence.charAt(seq_position);
                        if (node.getHMMSeq() == null) {
                            node.setHMMSeq(String.valueOf(c));
                            continue block7;
                        }
                        node.setHMMSeq(node.getHMMSeq() + c);
                        continue block7;
                    }
                }
                Object condensed = node.getHMMSeq();
                int pos = ruler.length() - 5;
                condensed = ((String)condensed).substring(0, pos) + ".....";
                node.setHMMSeq((String)condensed);
            }
        }
        this.hmm_length = 0;
        for (GeneNode node : nodes) {
            if (node.getHMMSeq().length() <= this.hmm_length) continue;
            this.hmm_length = node.getHMMSeq().length();
        }
        this.condense_ruler = new char[ruler.length()];
        for (int i = 0; i < ruler.length(); ++i) {
            this.condense_ruler[i] = ruler.charAt(i);
        }
        return this.condense_ruler;
    }

    public ArrayList<Integer> getMatchPosIndex() {
        return this.matchPosIndex;
    }

    public int getSeq_length() {
        return this.seq_length;
    }

    public int getHmm_length() {
        return this.hmm_length;
    }

    public String getSampleSeq() {
        return this.sampleSeq;
    }

    public String getSampleHmmSeq() {
        return this.sampleHmmSeq;
    }
}

