/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;
import org.bbop.swing.ExtensibleLabelUI;
import org.bbop.swing.HyperlinkLabel;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.gui.table.GeneTableModel;
import org.paint.util.RenderUtil;

public class GeneCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger(GeneCellRenderer.class);
    private Color bg_color;
    private HyperlinkLabel label;
    private String text;
    private boolean selected;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.selected = isSelected;
        GeneTableModel genes = (GeneTableModel)table.getModel();
        GeneNode gene = genes.getNode(row);
        this.bg_color = Preferences.inst().getBackgroundColor();
        if (isSelected) {
            this.bg_color = RenderUtil.annotationStatusColor(gene, this.bg_color).brighter();
        }
        if (value != null) {
            this.label = (HyperlinkLabel)value;
            String tip = this.label.getToolTipText();
            this.setToolTipText(tip);
            UIManager.put("ToolTip.foreground", Preferences.inst().getForegroundColor());
            ToolTipManager.sharedInstance().setDismissDelay(999999999);
            this.text = table.getColumnName(column).equals("Permanent Tree ID") ? gene.getPersistantNodeID() : gene.getDatabaseID();
        } else {
            this.text = "";
        }
        this.setText(this.text);
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        Rectangle local_bounds = new Rectangle(0, 0, bounds.width, bounds.height);
        RenderUtil.paintBorder(g, local_bounds, this.bg_color, this.selected);
        if (this.label != null) {
            ExtensibleLabelUI.Renderer r = (ExtensibleLabelUI.Renderer)this.label.getClientProperty((Object)"html");
            if (r == null) {
                log.debug((Object)"Missing renderer");
                g.setColor(Preferences.inst().getForegroundColor());
                g.drawString(this.text, bounds.x, bounds.height - 3);
            } else {
                r.paint(g, (Shape)local_bounds);
            }
        }
    }
}

