/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.table;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.paint.datamodel.GeneNode;
import org.paint.gui.table.GeneTable;

public class GeneSearch {
    private static GeneSearch singleton;
    private static Logger log;

    private GeneSearch() {
    }

    public static synchronized GeneSearch inst() {
        if (singleton == null) {
            singleton = new GeneSearch();
        }
        return singleton;
    }

    public List<GeneNode> search(List<GeneNode> all_nodes, String searchStr) {
        ArrayList<GeneNode> matches = new ArrayList<GeneNode>();
        if (all_nodes != null && searchStr != null && !searchStr.equals("")) {
            if (searchStr.charAt(0) == '*') {
                String string = searchStr = searchStr.length() > 1 ? searchStr.substring(1) : "";
            }
            if (searchStr.length() > 0 && searchStr.endsWith("*")) {
                searchStr = searchStr.length() > 1 ? searchStr.substring(0, searchStr.length() - 1) : "";
            }
            Pattern p = Pattern.compile(".*" + searchStr + ".*", 2);
            for (int i = 0; i < all_nodes.size(); ++i) {
                GeneNode node = all_nodes.get(i);
                boolean matched = false;
                matched = this.check4match(node.getSeqId(), p);
                if (!matched) {
                    matched = this.check4match(node.getNodeLabel(), p);
                }
                if (!matched) {
                    matched = this.check4match(node.getDatabaseID(), p);
                }
                if (!matched) {
                    matched = this.check4match(node.getSeqId(), p);
                }
                if (!matched) {
                    matched = this.check4match(node.getSeqName(), p);
                }
                if (!matched) {
                    matched = this.check4match(node.getPersistantNodeID(), p);
                }
                if (!matched) {
                    matched = this.check4match(node.getSpeciesLabel(), p);
                }
                if (!matched) {
                    matched = this.check4match(node.getDatabase(), p);
                }
                if (!matched) {
                    matched = this.check4match(node.getSeqDB(), p);
                }
                if (!matched) {
                    matched = this.check4match(node.getDescription(), p);
                }
                if (!matched) continue;
                matches.add(node);
            }
        }
        return matches;
    }

    private boolean check4match(String value, Pattern p) {
        boolean matched = false;
        if (value != null) {
            Matcher m = p.matcher(value);
            matched = m.matches();
        }
        return matched;
    }

    static {
        log = Logger.getLogger(GeneTable.class);
    }
}

