/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.table;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.bbop.swing.HyperlinkLabel;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.gui.FamilyViews;
import org.paint.gui.event.AspectChangeEvent;
import org.paint.gui.event.AspectChangeListener;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.GeneDataEvent;
import org.paint.gui.event.GeneSelectEvent;
import org.paint.gui.event.GeneSelectListener;
import org.paint.gui.event.NodeReorderEvent;
import org.paint.gui.event.NodeReorderListener;
import org.paint.gui.event.SubFamilyListener;
import org.paint.gui.event.TermSelectEvent;
import org.paint.gui.event.TermSelectionListener;
import org.paint.gui.familytree.TreePanel;
import org.paint.gui.table.GeneCellRenderer;
import org.paint.gui.table.GeneTableModel;
import org.paint.gui.table.OrthoCell;
import org.paint.gui.table.OrthoCellRenderer;
import org.paint.gui.table.TextCellRenderer;
import org.paint.main.PaintManager;
import org.paint.util.HTMLUtil;
import org.paint.util.TableUtil;

public class GeneTable
extends JTable
implements MouseListener,
GeneSelectListener,
TermSelectionListener,
SubFamilyListener,
NodeReorderListener,
AspectChangeListener {
    private static final long serialVersionUID = 1L;
    private ListSelectionModel geneSelectionModel;
    private boolean is_adjusting = false;
    private static Logger log = Logger.getLogger(GeneTable.class);

    public GeneTable() {
        this.setBackground(Preferences.inst().getBackgroundColor());
        this.setSelectionBackground(Preferences.inst().getSelectionColor());
        this.setAutoResizeMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setAutoscrolls(false);
        this.setDefaultRenderer(String.class, new TextCellRenderer());
        this.setDefaultRenderer(HyperlinkLabel.class, new GeneCellRenderer());
        this.setDefaultRenderer(OrthoCell.class, new OrthoCellRenderer());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        EventManager manager = EventManager.inst();
        manager.registerGeneListener(this);
        manager.registerNodeReorderListener(this);
        manager.registerSubFamilyListener(this);
        manager.registerAspectChangeListener(this);
        manager.registerTermListener(this);
        this.geneSelectionModel = this.getSelectionModel();
        this.geneSelectionModel.setSelectionMode(2);
        this.addMouseListener(this);
        this.geneSelectionModel.addListSelectionListener(new GeneSelectionHandler(this));
        this.setSelectionModel(this.geneSelectionModel);
        Preferences user_settings = Preferences.inst();
        Font f = user_settings.getFont();
        this.setFont(f);
        this.setRowMargin(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
    }

    public void setModel(GeneTableModel grid) {
        super.setModel(grid);
        if (grid != null) {
            TableUtil.setColumnWidths(grid, grid.getColumnCount(), this.getFontMetrics(this.getFont()), this.getColumnModel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int modifiers = e.getModifiers();
        Point p = e.getPoint();
        int clickRow = this.rowAtPoint(p);
        int clickCol = this.columnAtPoint(p);
        GeneTableModel grid = (GeneTableModel)this.getModel();
        grid.getNode(clickRow).setSelected(true);
        if (SwingUtilities.isLeftMouseButton(e) || !(SwingUtilities.isRightMouseButton(e) || e.isControlDown())) {
            Object o = this.getValueAt(clickRow, clickCol);
            if (o instanceof HyperlinkLabel) {
                HTMLUtil.bringUpInBrowser(((HyperlinkLabel)o).getToolTipText());
            }
        } else if (SwingUtilities.isRightMouseButton(e) || e.isControlDown()) {
            System.out.println("Right click");
            ListSelectionModel lsm = this.getSelectionModel();
            int min = lsm.getMinSelectionIndex();
            int max = lsm.getMaxSelectionIndex();
            log.debug((Object)("min index is " + min + " and max is " + max));
            if (clickCol < 0) {
                return;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == GeneTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void handleTermEvent(TermSelectEvent e) {
        GeneTableModel genes = (GeneTableModel)this.getModel();
        int total = genes.getRowCount();
        if (total > 0) {
            this.is_adjusting = true;
            ListSelectionModel lsm = this.getSelectionModel();
            lsm.clearSelection();
            for (int i = 0; i < total; ++i) {
                GeneNode node = genes.getNode(i);
                if (!node.isSelected()) continue;
                lsm.addSelectionInterval(i, i);
            }
            GeneNode mrca = EventManager.inst().getAncestralSelection();
            if (mrca.isLeaf()) {
                int row = genes.getRow(mrca);
                if (row >= 0) {
                    this.scrollToVisible(row);
                } else {
                    log.debug((Object)("Missing row for " + mrca.getSeqName()));
                }
            } else {
                this.scrollToVisible(mrca.getScreenRectangle());
            }
            this.is_adjusting = false;
        }
    }

    @Override
    public void handleGeneSelectEvent(GeneSelectEvent e) {
        if (e.getGenes() == null) {
            System.out.println("GeneTable: wierd, have a null");
        } else if (e.getSource() != this) {
            List<GeneNode> selection;
            ListSelectionModel lsm = this.getSelectionModel();
            lsm.clearSelection();
            GeneTableModel geneTableModel = (GeneTableModel)this.getModel();
            this.clearSelection();
            int total = geneTableModel.getRowCount();
            if (total > 0 && (selection = e.getGenes()) != null && !selection.isEmpty()) {
                for (GeneNode node : selection) {
                    int row = geneTableModel.getRow(node);
                    if (row < 0 || row >= total) continue;
                    this.addRowSelectionInterval(row, row);
                }
            }
        }
    }

    @Override
    public void handleSubFamilyEvent(GeneDataEvent e) {
        GeneTableModel model = (GeneTableModel)this.getModel();
        model.fireTableDataChanged();
        this.repaint();
    }

    private void setSelectedRows(ListSelectionModel lsm, TreePanel tree, GeneNode node) {
        this.is_adjusting = true;
        lsm.setValueIsAdjusting(true);
        int[] current_rows = this.getSelectedRows();
        GeneTableModel model = (GeneTableModel)this.getModel();
        if (current_rows.length > 0) {
            this.removeRowSelectionInterval(current_rows[0], current_rows[current_rows.length - 1]);
        }
        if (node.isExpanded() && !node.isPruned()) {
            GeneNode low_gene = tree.getTopLeafNode(node);
            int low_row = model.getRow(low_gene);
            GeneNode high_gene = tree.getBottomLeafNode(node);
            int high_row = model.getRow(high_gene);
            this.setRowSelectionInterval(low_row, high_row);
            this.scrollToVisible(node.getScreenRectangle());
        } else {
            int row = model.getRow(node);
            if (row >= 0 && row < this.getRowCount()) {
                this.setRowSelectionInterval(row, row);
                this.scrollToVisible(row);
            } else {
                log.debug((Object)("Row out of bounds: " + row));
            }
        }
        lsm.setValueIsAdjusting(false);
        this.is_adjusting = false;
    }

    @Override
    public void handleNodeReorderEvent(NodeReorderEvent e) {
        GeneTableModel model = (GeneTableModel)this.getModel();
        model.reorderRows(e.getNodes());
        model.fireTableDataChanged();
    }

    @Override
    public void handleAspectChangeEvent(AspectChangeEvent event) {
        this.repaint();
    }

    public void scrollToVisible(int rowIndex) {
        Rectangle row_rect = this.getCellRect(rowIndex, 0, true);
        this.scrollToVisible(row_rect);
    }

    private void scrollToVisible(Rectangle rect) {
        Point point_of_view;
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle visible = viewport.getViewRect();
        if (visible.y <= rect.y && visible.y + visible.height >= rect.y + rect.height) {
            return;
        }
        if (rect.y + rect.height > visible.y + visible.height) {
            int view_bottom = visible.y + visible.height;
            int row_bottom = rect.y + rect.height;
            int diff = row_bottom - view_bottom;
            point_of_view = new Point(rect.x, visible.y + diff);
        } else {
            point_of_view = new Point(rect.x, rect.y);
        }
        viewport.setViewPosition(point_of_view);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        int pad = FamilyViews.inst().getBottomMargin(2);
        d.height += pad;
        return d;
    }

    class GeneSelectionHandler
    implements ListSelectionListener {
        GeneTable table;

        public GeneSelectionHandler(GeneTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && !GeneTable.this.is_adjusting) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                int min_index = lsm.getMinSelectionIndex();
                if (!lsm.isSelectionEmpty() && min_index >= 0) {
                    int max_index = lsm.getMaxSelectionIndex();
                    GeneTableModel genes = (GeneTableModel)this.table.getModel();
                    if (min_index == max_index) {
                        GeneNode gene = genes.getNode(min_index);
                        if (gene != null) {
                            GeneTable.this.setSelectedRows(lsm, PaintManager.inst().getTree(), gene);
                            ArrayList<GeneNode> selection = new ArrayList<GeneNode>();
                            selection.add(gene);
                            GeneSelectEvent ge = new GeneSelectEvent(this.table, selection, gene);
                            EventManager.inst().fireGeneEvent(ge);
                        }
                    } else {
                        GeneNode max_gene;
                        GeneNode min_gene;
                        TreePanel tree = PaintManager.inst().getTree();
                        GeneNode mrca = tree.getMRCA(min_gene = genes.getNode(min_index), max_gene = genes.getNode(max_index));
                        if (mrca == null) {
                            log.error((Object)("Couldn't find ancestor of " + min_gene.getSeqId() + " and " + max_gene.getSeqId()));
                            return;
                        }
                        GeneTable.this.setSelectedRows(lsm, tree, mrca);
                        ArrayList<GeneNode> selection = new ArrayList<GeneNode>();
                        tree.getDescendentList(mrca, selection);
                        selection.add(mrca);
                        GeneSelectEvent ge = new GeneSelectEvent(this.table, selection, mrca);
                        EventManager.inst().fireGeneEvent(ge);
                    }
                }
            }
        }
    }
}

