/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.table;

import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeStaticInfo;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.paint.datamodel.GeneNode;
import org.paint.gui.table.AbstractGeneTableModel;
import org.paint.util.GeneNodeUtil;

public class GeneTableModel
extends AbstractGeneTableModel {
    private static final long serialVersionUID = 1L;
    protected int currentRow;
    protected Vector<GeneNode> contents = new Vector();
    public static final String ACC_COL_NAME = "Accession";
    public static final String ORTHO_COL_NAME = "O";
    public static final String DB_COL_NAME = "Database";
    public static final String DBID_COL_NAME = "ID";
    public static final String SYMB_COL_NAME = "Name";
    public static final String SPEC_COL_NAME = "Species";
    public static final String DESC_COL_NAME = "Description";
    public static final String PERMNODEID_COL_NAME = "Permanent Tree ID";
    public static final String STR_EMPTY = "";
    protected static final String[] column_headings = new String[]{"O", "Accession", "Database", "ID", "Name", "Species", "Permanent Tree ID", "Description"};
    protected static Logger log = Logger.getLogger(GeneTableModel.class);

    public GeneTableModel() {
    }

    public GeneTableModel(List<GeneNode> orderedNodes) {
        this.reorderRows(orderedNodes);
    }

    public void reorderRows(List<GeneNode> node_list) {
        GeneNodeUtil.inst().setVisibleRows(node_list, this.contents);
    }

    @Override
    public int getColumnCount() {
        return column_headings.length;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (this.getValueAt(0, c) == null) {
            return String.class;
        }
        Class<?> check = this.getValueAt(0, c).getClass();
        if (null == check) {
            log.debug((Object)("Table returning null for column " + c));
        }
        return check;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return column_headings[columnIndex];
    }

    @Override
    public int getRowCount() {
        if (this.contents != null) {
            return this.contents.size();
        }
        return 0;
    }

    @Override
    public String getTextAt(int rowIndex, int columnIndex) {
        NodeStaticInfo sni;
        Node n;
        if (null == this.contents) {
            return null;
        }
        GeneNode node = this.contents.elementAt(rowIndex);
        String tag = column_headings[columnIndex];
        if (tag.equals(ORTHO_COL_NAME)) {
            return node.getOrthoMCL();
        }
        if (tag.equals(ACC_COL_NAME)) {
            return node.getSeqId();
        }
        if (tag.equals(DB_COL_NAME)) {
            return node.getDatabase();
        }
        if (tag.equals(DBID_COL_NAME)) {
            return node.getDatabaseID();
        }
        if (tag.equals(SYMB_COL_NAME)) {
            return node.getSeqName();
        }
        if (tag.equals(SPEC_COL_NAME)) {
            return node.getSpeciesLabel();
        }
        if (tag.equals(DESC_COL_NAME)) {
            NodeStaticInfo sni2;
            Node n2 = node.getNode();
            if (null != n2 && null != (sni2 = n2.getStaticInfo())) {
                return sni2.getDefinition();
            }
        } else if (tag.equals(PERMNODEID_COL_NAME) && null != (n = node.getNode()) && null != (sni = n.getStaticInfo())) {
            return sni.getPublicId();
        }
        return STR_EMPTY;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (null == this.contents) {
            return null;
        }
        String tag = column_headings[columnIndex];
        GeneNode node = this.contents.elementAt(rowIndex);
        if (tag.equals(ACC_COL_NAME)) {
            return node.getAccLabel();
        }
        if (tag.equals(DBID_COL_NAME)) {
            return node.getModLabel();
        }
        if (tag.equals(ORTHO_COL_NAME)) {
            return node.getOrthoCell();
        }
        if (tag.equals(PERMNODEID_COL_NAME)) {
            return node.getPermaCell();
        }
        return this.getTextAt(rowIndex, columnIndex);
    }

    public void resetHiddenRows() {
        for (int i = 0; i < this.contents.size(); ++i) {
            GeneNode row = this.contents.elementAt(i);
            row.setVisible(false);
        }
    }

    public void setVisibleRows(List<GeneNode> visibleNodes) {
        for (int i = 0; i < this.contents.size(); ++i) {
            GeneNode node = this.contents.get(i);
            boolean visible = visibleNodes.contains(node);
            node.setVisible(visible);
        }
    }

    public int getRow(GeneNode dsn) {
        try {
            return this.contents.indexOf(dsn);
        }
        catch (NullPointerException e) {
            System.out.println("Could not find gene " + dsn.getSeqName() + " in contents");
            return -1;
        }
    }

    public GeneNode getNode(int row) {
        if (row >= this.contents.size()) {
            System.out.println("Asking for row " + row + " which is > than the number of rows (" + this.contents.size() + ")");
            return null;
        }
        GeneNode node = this.contents.elementAt(row);
        return node;
    }

    @Override
    public boolean isSquare(int column) {
        return this.getColumnName(column).equals(ORTHO_COL_NAME);
    }
}

