/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.paint.config.Preferences;
import org.paint.gui.table.OrthoCell;

public class OrthoCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    Border selectedBorder = null;
    HashMap<Color, Border> unselectedBorders;

    public OrthoCellRenderer() {
        this.setText("");
        this.unselectedBorders = new HashMap();
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        OrthoCell ortho_cell = (OrthoCell)value;
        Color program_color = ortho_cell.getProgramColor();
        if (program_color == null) {
            program_color = Preferences.inst().getBackgroundColor();
        }
        this.setBackground(program_color);
        if (isSelected) {
            if (this.selectedBorder == null) {
                Preferences prefs = Preferences.inst();
                this.selectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, prefs.getForegroundColor());
            }
            this.setBorder(this.selectedBorder);
        } else {
            Border unselectedBorder = this.unselectedBorders.get(program_color);
            if (unselectedBorder == null) {
                unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, program_color);
                this.unselectedBorders.put(program_color, unselectedBorder);
            }
            this.setBorder(unselectedBorder);
        }
        this.setToolTipText(ortho_cell.getProgramName());
        return this;
    }
}

