/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.gui.table.GeneTableModel;
import org.paint.util.RenderUtil;

public class TextCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private GeneNode node;
    private Color bg_color;
    private Color fg_color;
    private boolean selected;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.selected = isSelected;
        GeneTableModel genes = (GeneTableModel)table.getModel();
        this.node = genes.getNode(row);
        Preferences prefs = Preferences.inst();
        Font f = RenderUtil.getNodeFont(this.node);
        this.setFont(f);
        this.fg_color = RenderUtil.annotationStatusColor(this.node, prefs.getForegroundColor());
        if (isSelected) {
            this.fg_color = prefs.getForegroundColor();
            this.bg_color = RenderUtil.annotationStatusColor(this.node, prefs.getBackgroundColor()).brighter();
        } else {
            this.fg_color = RenderUtil.annotationStatusColor(this.node, prefs.getForegroundColor());
            this.bg_color = prefs.getBackgroundColor();
        }
        this.setText((String)value);
        this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        return this;
    }

    @Override
    public void paint(Graphics g) {
        String text = this.getText();
        Insets insets = this.getInsets();
        RenderUtil.paintBorder(g, new Rectangle(0, 0, this.getWidth(), this.getHeight()), this.bg_color, this.selected);
        int boxWidth = this.getWidth() - (insets.left + insets.right);
        g.setFont(this.getFont());
        g.setColor(this.fg_color);
        g.drawString(RenderUtil.formatText(g, insets, boxWidth, text, this.getFont()), insets.left, this.getHeight() - insets.bottom - 1);
    }
}

