/*
 * Decompiled with CFR 0.152.
 */
package org.paint.main;

import edu.usc.ksom.pm.panther.paintCommon.DataTransferObj;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.PAINTVersion;
import edu.usc.ksom.pm.panther.paintCommon.TaxonomyHelper;
import edu.usc.ksom.pm.panther.paintCommon.VersionContainer;
import edu.usc.ksom.pm.panther.paintCommon.VersionInfo;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.bbop.framework.GUIManager;
import org.bbop.framework.GUITask;
import org.bbop.framework.VetoableShutdownListener;
import org.bbop.util.OSUtil;
import org.paint.config.Preferences;
import org.paint.dataadapter.PantherServer;
import org.paint.gui.DirtyIndicator;
import org.paint.main.PaintManager;
import org.paint.main.PaintStartupTask;

public class PAINT {
    private static final long serialVersionUID = 1L;
    protected Thread runner;
    private static String[] args;
    Runnable mainRun = new Runnable(){

        @Override
        public void run() {
            try {
                StringBuffer sb;
                int response;
                GUIManager.getManager().addStartupTask((GUITask)new PaintStartupTask(args));
                GUIManager.getManager().start();
                Preferences preference = Preferences.inst();
                PantherServer pServer = PantherServer.inst();
                String pantherURL = preference.getPantherURL();
                VersionContainer vc = pServer.getVersions(pantherURL);
                if (null == vc) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Unable to verify version information from server", "Error", 0);
                    System.exit(-1);
                }
                boolean clientVersionOk = PAINT.this.checkVersion(vc, PAINTVersion.getPAINTClientversion());
                VersionInfo commonInfo = new VersionInfo();
                commonInfo.setVersionId(PAINTVersion.getPAINTCommonVersion());
                if (null != commonInfo.compareTo(vc.get(VersionContainer.VersionedObj.CLIENT_SERVER_COMMON_VERSION))) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Please download latest version of software", "Error", 0);
                    System.exit(-1);
                }
                if (!clientVersionOk && 1 == (response = JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), "PAINT version is not the same as version available for download from the server, continue?", "Warning", 0))) {
                    System.exit(0);
                }
                GOTermHelper gth = pServer.getGOTermHelper(pantherURL);
                TaxonomyHelper th = pServer.getTaxonomyHelper(pantherURL);
                DataTransferObj dto = new DataTransferObj();
                dto.setVc(vc);
                dto = new DataTransferObj();
                dto.setVc(vc);
                DataTransferObj serverObj = pServer.getAllOrganisms(pantherURL, dto);
                ArrayList orgList = (ArrayList)serverObj.getObj();
                System.out.println(new Date() + " Retrieved organism list from server");
                if (null == serverObj) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Unable to retrieve list of organisms from server", "Error", 0);
                    System.exit(-1);
                }
                if (null != (sb = serverObj.getMsg()) && 0 != sb.length()) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Error retrieving list of supported organisms \n" + sb.toString(), "Error", 0);
                    System.exit(-1);
                }
                dto = new DataTransferObj();
                dto.setVc(vc);
                serverObj = pServer.getBacterialGenomes(pantherURL, dto);
                ArrayList bacteriaList = (ArrayList)serverObj.getObj();
                System.out.println(new Date() + " Retrieved bacterial genomes list from server");
                if (null == serverObj) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Unable to retrieve bacterial genomes from server", "Error", 0);
                    System.exit(-1);
                }
                if (null != (sb = serverObj.getMsg()) && 0 != sb.length()) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Error retrieving plant genomes \n" + sb.toString(), "Error", 0);
                    System.exit(-1);
                }
                dto = new DataTransferObj();
                dto.setVc(vc);
                serverObj = pServer.getPlantGenomes(pantherURL, dto);
                ArrayList plantList = (ArrayList)serverObj.getObj();
                System.out.println(new Date() + " Retrieved plant genomes list from server");
                if (null == serverObj) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Unable to retrieve plant genomes from server", "Error", 0);
                    System.exit(-1);
                }
                if (null != (sb = serverObj.getMsg()) && 0 != sb.length()) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Error retrieving plant genomes \n" + sb.toString(), "Error", 0);
                    System.exit(-1);
                }
                if (null == vc.get(VersionContainer.VersionedObj.CLS_VERSION) || null == gth) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Unable to get static information from server", "Error", 0);
                    System.exit(-1);
                }
                if (null == th) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Unable to retrieve taxonomy constraints information, annotate without taxonomy constraints?", "Error", 0);
                    System.exit(-1);
                }
                PaintManager pm = PaintManager.inst();
                pm.setupFixedInfo(gth, th, vc, orgList, bacteriaList, plantList);
                System.out.println(new Date() + " Done with initialization");
                GUIManager.addVetoableShutdownListener((VetoableShutdownListener)new VetoableShutdownListener(){

                    public boolean willShutdown() {
                        if (DirtyIndicator.inst().bookUpdated() && 0 == JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), "Book has been updated, save before closing?", "Book Updated", 1, 2)) {
                            PaintManager.inst().saveCurrent();
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e, "Warning", 2);
                e.printStackTrace();
                System.exit(2);
            }
        }
    };

    public static void main(String[] args) {
        PAINT.args = args;
        if (OSUtil.isMacOSX()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", PAINT.getAppName());
        }
        PAINT theRunner = new PAINT();
        SwingUtilities.invokeLater(theRunner.mainRun);
    }

    public boolean checkVersion(VersionContainer vc, String clientVersion) {
        VersionInfo vo = vc.get(VersionContainer.VersionedObj.CLIENT_VERSION);
        if (null == vo) {
            return false;
        }
        String versionId = vo.getVersionId();
        return null != versionId && null != clientVersion && versionId.equals(clientVersion);
    }

    public static String getAppName() {
        return "Paint";
    }
}

