/*
 * Decompiled with CFR 0.152.
 */
package org.paint.main;

import com.sri.panther.paintCommon.User;
import edu.stanford.ejalbert.BrowserLauncher;
import edu.usc.ksom.pm.panther.paint.matrix.MatrixBuilder;
import edu.usc.ksom.pm.panther.paint.matrix.MatrixInfo;
import edu.usc.ksom.pm.panther.paint.matrix.TermAncestor;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationHelper;
import edu.usc.ksom.pm.panther.paintCommon.Comment;
import edu.usc.ksom.pm.panther.paintCommon.DataTransferObj;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Organism;
import edu.usc.ksom.pm.panther.paintCommon.SaveBookInfo;
import edu.usc.ksom.pm.panther.paintCommon.TaxonomyHelper;
import edu.usc.ksom.pm.panther.paintCommon.VersionContainer;
import edu.usc.ksom.pm.panther.paintCommon.VersionInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;
import org.geneontology.db.model.Term;
import org.obo.datamodel.OBOSession;
import org.paint.config.Preferences;
import org.paint.dataadapter.GOAdapter;
import org.paint.dataadapter.PantherServer;
import org.paint.datamodel.Family;
import org.paint.datamodel.GeneNode;
import org.paint.go.GO_Util;
import org.paint.gui.DirtyIndicator;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.ProgressEvent;
import org.paint.gui.evidence.ActionLog;
import org.paint.gui.familytree.TreeModel;
import org.paint.gui.familytree.TreePanel;
import org.paint.gui.matrix.AnnotationMatrix;
import org.paint.gui.msa.MSA;
import org.paint.gui.msa.MSAPanel;
import org.paint.gui.table.GeneTable;
import org.paint.gui.table.GeneTableModel;
import org.paint.util.GeneNodeUtil;

public class PaintManager {
    private static PaintManager INSTANCE = null;
    private static final long serialVersionUID = 1L;
    private TreePanel tree_pane;
    private GeneTable genes_pane;
    private MSAPanel msa_pane;
    private AnnotationMatrix annot_matrix;
    private HashMap<String, List<GeneNode>> seqIdtoGene;
    private HashMap<String, GeneNode> paintIdtoGene;
    private HashMap<String, GeneNode> DbIdtoGene;
    private HashMap<String, GeneNode> ptnIdtoGene;
    private HashMap<String, GeneNode> GPtoGene;
    private static Hashtable<String, Vector<GeneNode>> origTreeTable;
    private static File currentDirectory;
    private static Family family;
    private static final Logger log;
    private static final int go_max = 25;
    private static OBOSession go_root;
    private VersionContainer versinContainer;
    private VersionInfo versionInfo;
    private GOTermHelper goTermHelper;
    private TaxonomyHelper taxonHelper;
    private ArrayList<Organism> allOrgList;
    private ArrayList<String> bacterialGenomes;
    private ArrayList<String> plantGenomes;
    private Hashtable<Organism, HashSet<String>> nonDisplayedAnnotMatrixOrgToEvdnceLookup;
    private User user;
    private Vector userInfo;
    private HashMap<GeneNode, HashSet<Annotation>> removedAnnotLookup = new HashMap();
    private BrowserLauncher browserLauncher;
    private ArrayList<TermAncestor> termAncestorList;
    private MatrixInfo matrixInfo;

    private PaintManager() {
    }

    public static synchronized PaintManager inst() {
        if (INSTANCE == null) {
            INSTANCE = new PaintManager();
        }
        return INSTANCE;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Family getFamily() {
        return family;
    }

    public void setFamily(Family fam) {
        family = fam;
    }

    public void closeCurrent() {
        GUIManager.getManager().getFrame().setTitle("");
        DirtyIndicator.inst().dirtyGenes(false);
        this.clearGeneIDs();
        if (null != this.tree_pane) {
            this.tree_pane.removeAll();
            this.tree_pane.revalidate();
        }
        if (null != this.genes_pane) {
            this.genes_pane.removeAll();
            this.genes_pane.revalidate();
        }
        if (null != this.msa_pane) {
            this.msa_pane.removeAll();
            this.msa_pane.revalidate();
        }
        if (null != this.annot_matrix) {
            this.annot_matrix.removeAll();
            this.annot_matrix.revalidate();
        }
        family = null;
        this.termAncestorList = null;
        this.matrixInfo = null;
        this.removedAnnotLookup.clear();
    }

    private void clearGeneIDs() {
        if (this.paintIdtoGene == null) {
            this.paintIdtoGene = new HashMap();
        } else {
            this.paintIdtoGene.clear();
        }
        if (this.seqIdtoGene == null) {
            this.seqIdtoGene = new HashMap();
        } else {
            this.seqIdtoGene.clear();
        }
        if (this.DbIdtoGene == null) {
            this.DbIdtoGene = new HashMap();
        } else {
            this.DbIdtoGene.clear();
        }
        if (this.ptnIdtoGene == null) {
            this.ptnIdtoGene = new HashMap();
        } else {
            this.ptnIdtoGene.clear();
        }
        if (this.GPtoGene == null) {
            this.GPtoGene = new HashMap();
        } else {
            this.GPtoGene.clear();
        }
        GO_Util.inst().clearCache();
    }

    public void indexByPaintID(GeneNode node) {
        String an_number = node.getPaintId();
        if (an_number == null || an_number.length() == 0) {
            log.error((Object)"Paint ID for node is missing!");
        } else if (this.paintIdtoGene.get(an_number) != null) {
            log.error((Object)("We've already indexed this node by annotation id: " + an_number));
        } else {
            this.paintIdtoGene.put(an_number, node);
        }
    }

    public void indexNodeByPTN(GeneNode node) {
        String ptn_id = node.getPersistantNodeID();
        this.ptnIdtoGene.put(ptn_id, node);
    }

    public GeneNode getGeneByPTNId(String id) {
        GeneNode node = null;
        if (id != null && this.ptnIdtoGene != null) {
            node = this.ptnIdtoGene.get(id);
        }
        if (null == node) {
            System.out.println("did not find node for " + id);
        }
        return node;
    }

    public GeneNode getGeneByPaintId(String id) {
        if (id.length() == 0) {
            return null;
        }
        GeneNode node = this.paintIdtoGene.get(id);
        if (node == null && id.startsWith(this.getFamily().getFamilyID())) {
            id = id.substring(id.indexOf(58) + 1);
            node = this.paintIdtoGene.get(id);
        }
        return node;
    }

    public GeneNode getGeneByGP(String db, String db_id) {
        GeneNode node = null;
        if (db != null && db_id != null && this.GPtoGene != null) {
            node = this.GPtoGene.get(db + ":" + db_id);
        }
        return node;
    }

    public void setGeneTable(GeneTable gp) {
        this.genes_pane = gp;
    }

    public void setTreePane(TreePanel tree) {
        this.tree_pane = tree;
    }

    public void setMSAPane(MSAPanel msa_pane) {
        this.msa_pane = msa_pane;
    }

    public GeneTable getGeneTable() {
        return this.genes_pane;
    }

    public int getTopMargin() {
        int margin = this.genes_pane.getTableHeader().getHeight();
        if (margin > 0) {
            return margin;
        }
        return this.genes_pane.getRowHeight();
    }

    public int getRowHeight() {
        return this.genes_pane.getRowHeight();
    }

    private void addPruned(ArrayList<Node> prunedList, GeneNode gNode) {
        if (null == gNode) {
            return;
        }
        if (gNode.isPruned() && !prunedList.contains(gNode.getNode())) {
            prunedList.add(gNode.getNode());
            return;
        }
        List<GeneNode> children = gNode.getChildren();
        if (null != children) {
            for (GeneNode child : children) {
                this.addPruned(prunedList, child);
            }
        }
    }

    public ArrayList<Node> getPrunedList() {
        ArrayList<Node> prunedList = new ArrayList<Node>();
        this.addPruned(prunedList, this.tree_pane.getRoot());
        return prunedList;
    }

    public ArrayList<String> getTaxonmomyWarnings() {
        ArrayList<Annotation> annotations = this.getAnnotatedList();
        ArrayList<String> warnings = new ArrayList<String>();
        for (Annotation a : annotations) {
            String[] parts;
            ArrayList children;
            NodeVariableInfo nvi;
            if (!"IBD".equals(a.getSingleEvidenceCodeFromSet())) continue;
            Node n = a.getAnnotationDetail().getAnnotatedNode();
            if (!this.taxonHelper.termAndQualifierValidForSpeciesCheckTaxonomy(a.getGoTerm(), n.getStaticInfo().getCalculatedSpecies(), a.getAnnotationDetail().getQualifiers())) {
                warnings.add(n.getStaticInfo().getPublicId() + " - According to current taxonomy constraints rules, species " + n.getStaticInfo().getCalculatedSpecies() + " cannot be annotated to term " + a.getGoTerm() + ".  If there is an error with the taxonomy rule, create a ticket in GitHub in  https://github.com/geneontology/go-ontology/issues and tag as 'taxon constraint'.");
            }
            if (this.taxonHelper.isCheckingTaxonomy() || (nvi = n.getVariableInfo()).isPruned() || null == (children = n.getStaticInfo().getChildren())) continue;
            StringBuffer sb = new StringBuffer();
            for (Node child : children) {
                AnnotationHelper.checkTaxonomyViolationsForNodeAndDescendants((Node)child, (String)a.getGoTerm(), (StringBuffer)sb, (TaxonomyHelper)this.taxonHelper);
            }
            if (0 >= sb.length()) continue;
            for (String part : parts = sb.toString().split(Pattern.quote("\n"))) {
                warnings.add(part);
            }
        }
        return warnings;
    }

    public ArrayList<Annotation> getAnnotatedList() {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        List<GeneNode> allNodes = this.tree_pane.getAllNodes();
        for (GeneNode gNode : allNodes) {
            ArrayList annotList;
            NodeVariableInfo nvi;
            Node n = gNode.getNode();
            if (GeneNodeUtil.inPrunedBranch(gNode) || null == (nvi = n.getVariableInfo()) || null == (annotList = nvi.getGoAnnotationList())) continue;
            for (Annotation a : annotList) {
                if (!AnnotationHelper.isDirectAnnotation((Annotation)a)) continue;
                annotationList.add(a);
            }
        }
        return annotationList;
    }

    public ArrayList<Annotation> getExpAddedAnnotList() {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        List<GeneNode> allNodes = this.tree_pane.getAllNodes();
        for (GeneNode gNode : allNodes) {
            ArrayList annotList;
            Node n = gNode.getNode();
            NodeVariableInfo nvi = n.getVariableInfo();
            if (null == nvi || null == (annotList = nvi.getGoAnnotationList())) continue;
            for (Annotation a : annotList) {
                if (!a.isExpAnnotCreatedInPaint()) continue;
                annotationList.add(a);
            }
        }
        return annotationList;
    }

    public boolean saveCurrent() {
        ArrayList<Node> prunedList = this.getPrunedList();
        ArrayList<Annotation> annotationList = this.getAnnotatedList();
        int n = 3;
        Object[] options = new Object[]{"Save, unlock & set curated", "Save", "Save & unlock", "Cancel"};
        n = JOptionPane.showOptionDialog(GUIManager.getManager().getFrame(), "Save Options", "", -1, 3, null, options, options[3]);
        if (n > 2 || n < 0) {
            return false;
        }
        SaveBookInfo sbi = new SaveBookInfo();
        sbi.setUser(this.user);
        sbi.setBookId(this.getFamily().getFamilyID());
        sbi.setPrunedList(prunedList);
        sbi.setAnnotationList(annotationList);
        sbi.setExpAnnotatonList(this.getExpAddedAnnotList());
        sbi.setComment(this.getFamily().getFamilyComment());
        sbi.setFamilyName(this.getFamily().getName());
        sbi.setSaveStatus(new Integer(n));
        try {
            Path path = FileSystems.getDefault().getPath(this.getFamily().getFamilyID() + "_to_save.ser", new String[0]);
            FileOutputStream fout = new FileOutputStream(path.toAbsolutePath().normalize().toString());
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(sbi);
            oos.flush();
            System.out.println("Saved family locally to " + path.toAbsolutePath().normalize().toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String saveStatus = this.getFamily().saveBookToDatabase(sbi);
        if (null == saveStatus || !saveStatus.isEmpty()) {
            Object errMsg = saveStatus;
            if (null == errMsg) {
                errMsg = "Unable to save information to server";
            }
            errMsg = (String)errMsg + ".  Will attempt to save locally.  Please send locally saved file to system administrator for analysis and saving.";
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), errMsg, "Save Error", 0);
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Serialized file", "ser");
            chooser.setFileFilter(filter);
            chooser.setFileSelectionMode(0);
            chooser.setDialogType(1);
            chooser.setCurrentDirectory(PaintManager.inst().getCurrentDirectory());
            int returned = chooser.showDialog(GUIManager.getManager().getFrame(), "Save");
            if (0 == returned) {
                File f = chooser.getSelectedFile();
                if (null != f) {
                    try {
                        FileOutputStream fout = new FileOutputStream(f);
                        ObjectOutputStream oos = new ObjectOutputStream(fout);
                        oos.writeObject(sbi);
                        oos.flush();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Error saving file", "Save Error", 0);
                        DirtyIndicator.inst().setAnnotated(false);
                        return true;
                    }
                }
            } else {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Changes not saved", "Save Error", 0);
            }
            DirtyIndicator.inst().setAnnotated(false);
            return true;
        }
        JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Book has been saved", "Save Successful", 1);
        DirtyIndicator.inst().setAnnotated(false);
        return true;
    }

    public void openNewFamily(String familyID) {
        this.closeCurrent();
        family = new Family();
        boolean success = family.loadFamily(familyID);
        if (success) {
            int nodes;
            this.setTitle();
            String progressMessage = "Initializing tree, attributes and MSA";
            PaintManager.fireProgressChange(progressMessage, 0, ProgressEvent.Status.START);
            if (null == family.getTreeStrings() || 0 == family.getTreeStrings().length || null == family.getNodeLookup() || 0 == family.getNodeLookup().size()) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Please contact administrator about book " + familyID, "Failed to load information for book", 0);
                this.closeCurrent();
                return;
            }
            GeneNode root = GeneNodeUtil.inst().parseTreeData(family.getTreeStrings(), family.getNodeLookup(), familyID);
            TreeModel treeModel = null;
            if (root == null) {
                System.out.println("Could not parse data");
                this.closeCurrent();
                return;
            }
            treeModel = new TreeModel(root);
            this.tree_pane.setTreeModel(treeModel);
            GeneTableModel geneTblModel = new GeneTableModel(this.tree_pane.getTerminusNodes());
            this.genes_pane.setModel(geneTblModel);
            if (family.getMSAcontent() != null) {
                progressMessage = "Initializing multiple sequence alignment";
                PaintManager.fireProgressChange(progressMessage, 50, ProgressEvent.Status.START);
                MSA msa = new MSA(family.getMSAcontent(), family.getWtsContent(), family.getNodeToDomainLookup(), family.getKeyResidueList());
                this.msa_pane.setModel(msa);
            }
            if (0 == (nodes = treeModel.getNumNodes())) {
                nodes = 1;
            }
            int progress_inc = 100 / nodes;
            progressMessage = "Initializing evidence log";
            PaintManager.fireProgressChange(progressMessage, progress_inc * 2, ProgressEvent.Status.START);
            ActionLog.inst().clearLog();
            progressMessage = "Initializing GO experimental annotations";
            PaintManager.fireProgressChange(progressMessage, progress_inc, ProgressEvent.Status.START);
            progressMessage = "Initializing annotation matrix";
            MatrixInfo mi = MatrixBuilder.getMatrixInfo(treeModel);
            this.annot_matrix.setModels(this.getTree().getTerminusNodes(), mi);
            PaintManager.fireProgressChange(progressMessage, 100, ProgressEvent.Status.END);
            EventManager.inst().fireNewFamilyEvent(this, family);
        } else {
            family = null;
            PaintManager.fireProgressChange("Unable to open family", 100, ProgressEvent.Status.END);
        }
    }

    private static void fireProgressChange(String message, int percentageDone, ProgressEvent.Status status) {
    }

    public List<Term> findTerm(String cue) {
        return null;
    }

    public String getCuratorNotes() {
        if (null == family) {
            return null;
        }
        Comment c = family.getFamilyComment();
        if (null == c) {
            return null;
        }
        return c.getCommentUserNotes();
    }

    public void setCuratorNotes(String curatorNotes) {
        if (null == family || null == curatorNotes) {
            return;
        }
        Comment c = family.getFamilyComment();
        if (null == c) {
            c = new Comment(null, null, null);
            family.setFamilyComment(c);
        }
        c.setCommentUserNotes(curatorNotes);
    }

    public String getUpdateHistory() {
        if (null == family) {
            return null;
        }
        Comment c = family.getFamilyComment();
        if (null == c) {
            return null;
        }
        return c.getRevisionHistoryInfo();
    }

    public String getFullComment() {
        if (null == family) {
            return null;
        }
        Comment c = family.getFamilyComment();
        if (null == c) {
            return null;
        }
        return c.getFormattedComment();
    }

    public void setTitle() {
        Object title = this.getFamily().getName() != null ? this.getFamily().getName() + " (" + this.getFamily().getFamilyID() + ")" : "";
        GUIManager.getManager().getFrame().setTitle((String)title);
    }

    public File getCurrentDirectory() {
        return currentDirectory;
    }

    public void setCurrentDirectory(File currentDir) {
        currentDirectory = currentDir;
    }

    public OBOSession getGoRoot() {
        if (go_root == null) {
            go_root = GOAdapter.loadGO();
        }
        return go_root;
    }

    public TreePanel getTree() {
        return this.tree_pane;
    }

    public MSAPanel getMSAPanel() {
        return this.msa_pane;
    }

    public void setMatrix(AnnotationMatrix annot_table) {
        this.annot_matrix = annot_table;
    }

    public AnnotationMatrix getMatrix() {
        return this.annot_matrix;
    }

    public void setupFixedInfo(GOTermHelper goTermHelper, TaxonomyHelper taxonHelper, VersionContainer vc, ArrayList<Organism> allOrgList, ArrayList<String> bacterialGenomes, ArrayList<String> plantGenomes) {
        this.goTermHelper = goTermHelper;
        this.taxonHelper = taxonHelper;
        this.versinContainer = vc;
        this.allOrgList = allOrgList;
        this.bacterialGenomes = bacterialGenomes;
        this.plantGenomes = plantGenomes;
    }

    public VersionContainer getVersionContainer() {
        return this.versinContainer;
    }

    public GOTermHelper goTermHelper() {
        return this.goTermHelper;
    }

    public TaxonomyHelper getTaxonHelper() {
        return this.taxonHelper;
    }

    public HashSet<String> getCuratableBookSet() {
        PantherServer pServer = PantherServer.inst();
        DataTransferObj serverInput = new DataTransferObj();
        serverInput.setVc(this.versinContainer);
        DataTransferObj serverObj = pServer.getCuratableBooks(Preferences.inst().getPantherURL(), serverInput);
        System.out.println(new Date() + " Retrieved curatable book information from server");
        if (null == serverObj) {
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Unable to retrieve list of curatable books from server", "Error", 0);
            return null;
        }
        StringBuffer sb = serverObj.getMsg();
        if (null != sb && 0 != sb.length()) {
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Download new version from server \n" + sb.toString(), "Error", 0);
            return null;
        }
        return (HashSet)serverObj.getObj();
    }

    public ArrayList<Organism> getAllOrgList() {
        return new ArrayList<Organism>(this.allOrgList);
    }

    public ArrayList<String> getBacterialGenomes() {
        return this.bacterialGenomes;
    }

    public ArrayList<String> getPlantGenomes() {
        return this.plantGenomes;
    }

    public Hashtable<Organism, HashSet<String>> getnonDisplayedAnnotMatrixOrgToEvdnceLookup() {
        return this.nonDisplayedAnnotMatrixOrgToEvdnceLookup;
    }

    public void setnonDisplayedAnnotMatrixOrgToEvdnceLookup(Hashtable<Organism, HashSet<String>> nonDisplayedAnnotMatrixOrgToEvdnceLookup) {
        this.nonDisplayedAnnotMatrixOrgToEvdnceLookup = nonDisplayedAnnotMatrixOrgToEvdnceLookup;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public void setUserInfo(Vector userInfo) {
        this.userInfo = userInfo;
    }

    public Vector getUserInfo() {
        return this.userInfo;
    }

    public void addToRemovedAnnotationLookup(GeneNode gNode, Annotation a) {
        if (null == gNode || null == a) {
            return;
        }
        HashSet<Object> annotSet = this.removedAnnotLookup.get(gNode);
        if (null == annotSet) {
            annotSet = new HashSet();
            this.removedAnnotLookup.put(gNode, annotSet);
        }
        annotSet.add(a);
    }

    public void addTermAncestor(TermAncestor termAncestor) {
        if (null == this.termAncestorList) {
            this.termAncestorList = new ArrayList();
        }
        this.termAncestorList.add(termAncestor);
        TreeModel treeModel = this.tree_pane.getTreeModel();
        MatrixInfo mi = MatrixBuilder.getMatrixInfo(treeModel);
        this.annot_matrix.setModels(this.getTree().getTerminusNodes(), mi);
    }

    public void handleExpTermUpdate() {
        TreeModel treeModel = this.tree_pane.getTreeModel();
        MatrixInfo mi = MatrixBuilder.getMatrixInfo(treeModel);
        this.annot_matrix.setModels(this.getTree().getTerminusNodes(), mi);
    }

    public ArrayList<TermAncestor> getTermAncestorList() {
        return this.termAncestorList;
    }

    public void setMatrixInfo(MatrixInfo mi) {
        this.matrixInfo = mi;
    }

    public MatrixInfo getMatrixInnfo() {
        return this.matrixInfo;
    }

    public BrowserLauncher getBrowserLauncher() {
        if (null == this.browserLauncher) {
            try {
                this.browserLauncher = new BrowserLauncher();
                this.browserLauncher.setNewWindowPolicy(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.browserLauncher;
    }

    static {
        log = Logger.getLogger(PaintManager.class);
    }
}

