/*
 * Decompiled with CFR 0.152.
 */
package org.paint.main;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import net.infonode.docking.theme.DockingWindowsTheme;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.DataAdapter;
import org.bbop.framework.AbstractApplicationStartupTask;
import org.bbop.framework.GUIComponentFactory;
import org.bbop.framework.GUIManager;
import org.bbop.framework.GUITask;
import org.bbop.framework.ScreenLockTask;
import org.bbop.framework.VetoableShutdownListener;
import org.bbop.framework.dock.LayoutDriver;
import org.bbop.framework.dock.idw.IDWDriver;
import org.bbop.util.CollectionUtil;
import org.paint.config.Preferences;
import org.paint.dialog.AboutDialog;
import org.paint.factory.AssociationsPanelFactory;
import org.paint.factory.EvidenceFactory;
import org.paint.factory.GeneTreeFactory;
import org.paint.factory.StatusViewFactory;
import org.paint.gui.DirtyIndicator;
import org.paint.gui.PaintDockingTheme;
import org.paint.main.PAINT;
import org.paint.main.PaintDefaultComponentsFactory;
import org.paint.main.PaintFrame;

public class PaintStartupTask
extends AbstractApplicationStartupTask {
    private static Logger LOG = Logger.getLogger(PaintStartupTask.class);
    private String[] args;

    PaintStartupTask(String[] args) {
        this.args = args;
    }

    protected Collection<GUIComponentFactory<?>> getDefaultComponentFactories() {
        ArrayList factories = new ArrayList();
        factories.add((GUIComponentFactory<?>)new AssociationsPanelFactory());
        factories.add((GUIComponentFactory<?>)new EvidenceFactory());
        factories.add((GUIComponentFactory<?>)new GeneTreeFactory());
        factories.add((GUIComponentFactory<?>)new StatusViewFactory());
        return factories;
    }

    protected void doOtherInstallations() {
    }

    protected Collection<DataAdapter> getDefaultDataAdapters() {
        LinkedList<DataAdapter> adapters = new LinkedList<DataAdapter>();
        return adapters;
    }

    protected Action getAboutAction() {
        return new AbstractAction("About PAINT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog about = new AboutDialog(GUIManager.getManager().getFrame());
                about.showDialog();
            }
        };
    }

    protected Collection<JToolBar> getDefaultToolBars() {
        ArrayList<JToolBar> toolbars = new ArrayList<JToolBar>();
        return toolbars;
    }

    protected String getAppID() {
        return PAINT.getAppName() + Preferences.inst().getVersion();
    }

    protected String getAppName() {
        return PAINT.getAppName();
    }

    protected String getPerspectiveResourceDir() {
        return this.getPrefsDir() + File.separator + "perspectives";
    }

    protected String getDefaultPerspectiveResourcePath() {
        if (this.getPerspectiveResourceDir() != null) {
            return this.getPerspectiveResourceDir() + File.separator + this.getAppName() + ".idw";
        }
        return null;
    }

    public File getPrefsDir() {
        Path currentRelativePath = Paths.get("", new String[0]);
        String s = currentRelativePath.toAbsolutePath().toString();
        return new File(s);
    }

    protected Collection<? extends JMenuItem> getDefaultMenus() {
        return PaintDefaultComponentsFactory.createDefaultMenus();
    }

    protected Collection<GUITask> getDefaultTasks() {
        ScreenLockTask screenLockTask = new ScreenLockTask(GUIManager.getManager().getScreenLockQueue(), (Frame)GUIManager.getManager().getFrame(), this.getUseModalProgressMonitors());
        return CollectionUtil.list((Object[])new GUITask[]{screenLockTask});
    }

    protected void installSystemListeners() {
        GUIManager.addVetoableShutdownListener((VetoableShutdownListener)DirtyIndicator.inst());
    }

    protected JFrame createFrame() {
        PaintFrame out = new PaintFrame("Paint Version " + Preferences.inst().getPAINTversion());
        return out;
    }

    protected LayoutDriver createLayoutDriver() {
        LayoutDriver driver = super.createLayoutDriver();
        if (driver instanceof IDWDriver) {
            ((IDWDriver)driver).setCustomTheme((DockingWindowsTheme)new PaintDockingTheme());
        }
        driver.setSaveLayoutOnExit(false);
        return driver;
    }

    public boolean getUseModalProgressMonitors() {
        return !System.getProperty("useModalProgressMonitors", "true").equals("false");
    }

    protected void configureLogging() {
        FileAppender a;
        Logger rl = LogManager.getRootLogger();
        Enumeration appenders = rl.getAllAppenders();
        if (appenders == null || !appenders.hasMoreElements()) {
            System.out.println("Log4J configuration is empty, using default configuration settings");
            BasicConfigurator.configure();
            rl.setLevel(Level.DEBUG);
            LOG = LogManager.getLogger(PAINT.class);
        }
        if ((a = (FileAppender)rl.getAppender("MAIN")) != null) {
            System.out.println("log file: " + a.getFile());
        }
        if (a != null && a.getFile() != null) {
            File f = new File(a.getFile());
            System.out.println("path of file " + f.getPath() + " absolute " + f.getAbsolutePath() + " canWrite " + f.canWrite());
        }
        LOG.info((Object)("Loading Paint version " + Preferences.inst().getPAINTversion()));
    }

    protected void configureUI() {
        String lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        if (lookAndFeelClassName.equals("apple.laf.AquaLookAndFeel") || lookAndFeelClassName.equals("com.apple.laf.AquaLookAndFeel")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            return;
        }
    }
}

