/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import edu.usc.ksom.pm.panther.paint.annotation.AnnotationForTerm;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationDetail;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationHelper;
import edu.usc.ksom.pm.panther.paintCommon.DBReference;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.IWith;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import edu.usc.ksom.pm.panther.paintCommon.TaxonomyHelper;
import edu.usc.ksom.pm.panther.paintCommon.WithEvidence;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.paint.datamodel.GeneNode;
import org.paint.gui.AspectSelector;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.EventManager;
import org.paint.gui.familytree.TreePanel;
import org.paint.gui.msa.MSAPanel;
import org.paint.main.PaintManager;
import org.paint.util.GeneNodeUtil;

public class AnnotationUtil {
    public static void deletePropagatorsAnnotationFromDescendants(GeneNode origPropagator, Annotation origAnnotation, ArrayList<GeneNode> descNodes, boolean checkQualifiers) {
        ArrayList descCopy = (ArrayList)descNodes.clone();
        String goTerm = origAnnotation.getGoTerm();
        HashSet propQualifierSet = origAnnotation.getQualifierSet();
        for (GeneNode gn : descCopy) {
            ArrayList goAnnotList;
            Node n = gn.getNode();
            NodeVariableInfo nvi = n.getVariableInfo();
            if (null == nvi || null == (goAnnotList = nvi.getGoAnnotationList())) continue;
            Iterator annotIter = goAnnotList.iterator();
            while (annotIter.hasNext()) {
                GeneNode annotPropagator;
                Annotation annot = (Annotation)annotIter.next();
                if (annot.isExperimental() || !origPropagator.equals(annotPropagator = AnnotationUtil.getPAINTWithNode(annot)) || !goTerm.equals(annot.getGoTerm())) continue;
                if (checkQualifiers) {
                    if (!QualifierDif.allQualifiersSame((Set)propQualifierSet, (Set)annot.getQualifierSet())) continue;
                    annotIter.remove();
                    break;
                }
                annotIter.remove();
                break;
            }
            if (!goAnnotList.isEmpty()) continue;
            nvi.setGoAnnotationList(null);
        }
    }

    public static Annotation getSingleWithPropagatorAnnot(Annotation a) {
        HashSet withAnnotSet = a.getAnnotationDetail().getWithEvidenceAnnotSet();
        if (null == withAnnotSet || 1 != withAnnotSet.size()) {
            return null;
        }
        Iterator iterator = withAnnotSet.iterator();
        if (iterator.hasNext()) {
            WithEvidence we = (WithEvidence)iterator.next();
            return (Annotation)we.getWith();
        }
        return null;
    }

    public static Annotation getAnnotationWithSingleWithAnnotAndEvidenceCde(ArrayList<Annotation> annotList, Annotation withAnnot, String evidenceCode) {
        block0: for (Annotation a : annotList) {
            HashSet withEvSet = a.getAnnotationDetail().getWithEvidenceAnnotSet();
            if (null == withEvSet || 1 != withEvSet.size()) continue;
            for (WithEvidence we : withEvSet) {
                Annotation wa = (Annotation)we.getWith();
                if (wa != withAnnot) continue;
                if ((null == evidenceCode || !evidenceCode.equals(wa.getSingleEvidenceCodeFromSet())) && (null != evidenceCode || null != wa.getSingleEvidenceCodeFromSet())) continue block0;
                return withAnnot;
            }
        }
        return null;
    }

    public static ArrayList<DBReference> getWiths(ArrayList<DBReference> dbRefList, String skipId) {
        if (null == dbRefList || null == skipId) {
            return null;
        }
        ArrayList<DBReference> newList = new ArrayList<DBReference>();
        for (DBReference dbRef : dbRefList) {
            if (skipId.equals(dbRef.getEvidenceValue())) continue;
            newList.add(dbRef);
        }
        if (newList.isEmpty()) {
            newList = null;
        }
        return newList;
    }

    public static boolean isIBAFromIBDAndForIKRorIRD(Annotation ibaAnnot, GeneNode gn) {
        ArrayList ancestors;
        if (null == gn) {
            return false;
        }
        Annotation ibaPropagator = AnnotationUtil.getSingleWithPropagatorAnnot(ibaAnnot);
        if (null == ibaPropagator) {
            return false;
        }
        if (!"IBD".equals(ibaPropagator.getSingleEvidenceCodeFromSet())) {
            return false;
        }
        AnnotationDetail ad = ibaPropagator.getAnnotationDetail();
        Set qualiferSet = ad.getQualifiers();
        boolean isNeg = QualifierDif.containsNegative((Set)qualiferSet);
        PaintManager pm = PaintManager.inst();
        GOTermHelper gth = pm.goTermHelper();
        GOTerm term = gth.getTerm(ibaPropagator.getGoTerm());
        GOTerm ibaTerm = gth.getTerm(ibaAnnot.getGoTerm());
        if (null == term || null == ibaTerm) {
            return false;
        }
        if (false == isNeg ? false == (ancestors = gth.getAncestors(term)).contains(ibaTerm) : false == (ancestors = gth.getAncestors(ibaTerm)).contains(term)) {
            return false;
        }
        Node n = gn.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return false;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return false;
        }
        for (Annotation a : annotList) {
            HashSet withAnnotSet;
            String code = a.getSingleEvidenceCodeFromSet();
            if ((!"IKR".equals(code) || gn.isLeaf()) && !"IRD".equals(code) || null == (withAnnotSet = a.getAnnotationDetail().getWithEvidenceAnnotSet())) continue;
            for (WithEvidence we : withAnnotSet) {
                Annotation withAnnot = (Annotation)we.getWith();
                if (ibaPropagator != withAnnot) continue;
                return true;
            }
        }
        return false;
    }

    public static ArrayList<GeneNode> getNodesProvidingExperimentalEvidence(Annotation a, GeneNode propagator) {
        HashSet withs = a.getAnnotationDetail().getWithAnnotSet();
        ArrayList<GeneNode> nodeList = new ArrayList<GeneNode>();
        PaintManager pm = PaintManager.inst();
        if (null != withs) {
            for (Annotation with : withs) {
                Node n = with.getAnnotationDetail().getAnnotatedNode();
                GeneNode gn = pm.getGeneByPTNId(n.getStaticInfo().getPublicId());
                if (null == gn || nodeList.contains(gn) || gn == propagator) continue;
                nodeList.add(gn);
            }
        }
        if (nodeList.isEmpty()) {
            return null;
        }
        return nodeList;
    }

    public static GeneNode getPAINTWithNode(Annotation a) {
        HashSet annotSet = a.getAnnotationDetail().getWithAnnotSet();
        PaintManager pm = PaintManager.inst();
        for (Annotation annot : annotSet) {
            Node n;
            GeneNode gn;
            if (a == annot || null == (gn = pm.getGeneByPTNId((n = annot.getAnnotationDetail().getAnnotatedNode()).getStaticInfo().getPublicId())) || gn.isLeaf()) continue;
            return gn;
        }
        return null;
    }

    public static GeneNode getNonLeafPaintNodeFromWiths(ArrayList<DBReference> references) {
        if (null == references) {
            return null;
        }
        PaintManager pm = PaintManager.inst();
        for (DBReference ref : references) {
            GeneNode gNode;
            String type = ref.getEvidenceType();
            if (!"PANTHER".equals(type) || null == (gNode = pm.getGeneByPTNId(ref.getEvidenceValue())) || gNode.isLeaf()) continue;
            return gNode;
        }
        return null;
    }

    public static Annotation getPropagatorsNOTAnnotation(String goTerm, GeneNode propagator, HashSet<Qualifier> curQualifierSet) {
        if (null == goTerm) {
            return null;
        }
        Node propNode = propagator.getNode();
        NodeVariableInfo nvi = propNode.getVariableInfo();
        if (null == nvi) {
            return null;
        }
        ArrayList propAnnotList = nvi.getGoAnnotationList();
        if (null == propAnnotList) {
            return null;
        }
        for (Annotation annot : propAnnotList) {
            if (!goTerm.equals(annot.getGoTerm()) || !QualifierDif.areOpposite(curQualifierSet, (Set)annot.getQualifierSet())) continue;
            return annot;
        }
        return null;
    }

    public static Annotation getPropagatorsAnnotation(String goTerm, GeneNode propagator) {
        if (null == goTerm) {
            return null;
        }
        Node propNode = propagator.getNode();
        NodeVariableInfo nvi = propNode.getVariableInfo();
        if (null == nvi) {
            return null;
        }
        ArrayList propAnnotList = nvi.getGoAnnotationList();
        if (null == propAnnotList) {
            return null;
        }
        for (Annotation annot : propAnnotList) {
            if (!goTerm.equals(annot.getGoTerm())) continue;
            return annot;
        }
        return null;
    }

    private static boolean IBAannotationAlreadyExists(String term, Annotation propagatorAnnot, Node node) {
        NodeVariableInfo nvi = node.getVariableInfo();
        if (null == nvi) {
            return false;
        }
        ArrayList goAnnotList = nvi.getGoAnnotationList();
        if (null == goAnnotList) {
            return false;
        }
        for (Annotation a : goAnnotList) {
            AnnotationDetail ad;
            if (!"IBA".equals(a.getSingleEvidenceCodeFromSet()) || !a.getGoTerm().equals(term) || null == (ad = a.getAnnotationDetail())) continue;
            HashSet withs = ad.getWithAnnotSet();
            if (null == withs || 1 != withs.size()) {
                System.out.println("Found IBA with more than 1 with for annotation id " + a.getAnnotationId());
                continue;
            }
            for (Annotation with : withs) {
                if (with != propagatorAnnot) continue;
                return true;
            }
        }
        return false;
    }

    public static HashSet<GeneNode> getDescWithExpEvdnce(GeneNode gNode) {
        HashSet<GeneNode> rtnList = new HashSet<GeneNode>();
        ArrayList<GeneNode> descList = new ArrayList<GeneNode>();
        GeneNodeUtil.allDescendents(gNode, descList);
        List<GeneNode> leafDesc = GeneNodeUtil.getAllLeaves(descList);
        for (GeneNode gn : leafDesc) {
            ArrayList goAnnotList;
            Node n = gn.getNode();
            NodeVariableInfo nvi = n.getVariableInfo();
            if (null == nvi || null == (goAnnotList = nvi.getGoAnnotationList())) continue;
            for (Annotation annot : goAnnotList) {
                if (!annot.isExperimental()) continue;
                rtnList.add(gn);
            }
        }
        if (rtnList.isEmpty()) {
            rtnList = null;
        }
        return rtnList;
    }

    public boolean isQualifierForTermNegative(ArrayList<Annotation> annotList, String term) {
        if (null == annotList || null == term) {
            return false;
        }
        PaintManager pm = PaintManager.inst();
        GOTermHelper gth = pm.goTermHelper();
        GOTerm compTerm = gth.getTerm(term);
        ArrayList ancestors = gth.getAncestors(compTerm);
        boolean foundNegative = false;
        for (Annotation annot : annotList) {
            String cTerm = annot.getGoTerm();
            if (term.equals(cTerm)) {
                return QualifierDif.containsNegative((Set)annot.getQualifierSet());
            }
            GOTerm curTerm = gth.getTerm(cTerm);
            if (!ancestors.contains(curTerm) || !QualifierDif.containsNegative((Set)annot.getQualifierSet())) continue;
            foundNegative = true;
        }
        return foundNegative;
    }

    private static void removeNonExperimentalNonPaintAnnotations(GeneNode gNode, PaintManager pm, HashSet<Annotation> removedAnnotSet) {
        List<GeneNode> children;
        ArrayList annotList;
        NodeVariableInfo nvi;
        if (null == gNode) {
            return;
        }
        Node n = gNode.getNode();
        if (null == n) {
            System.out.println("Did not find node information");
        }
        if (null != (nvi = gNode.getNode().getVariableInfo()) && null != (annotList = nvi.getGoAnnotationList())) {
            ArrayList<Annotation> removeList = new ArrayList<Annotation>();
            for (Annotation a : annotList) {
                if (a.isExperimental() || a.isPaint()) continue;
                removeList.add(a);
            }
            removedAnnotSet.addAll(removeList);
            for (Annotation a : removeList) {
                pm.addToRemovedAnnotationLookup(gNode, a);
            }
            annotList.removeAll(removeList);
            if (annotList.isEmpty()) {
                nvi.setGoAnnotationList(null);
            }
        }
        if (null == (children = gNode.getChildren())) {
            return;
        }
        for (GeneNode child : children) {
            AnnotationUtil.removeNonExperimentalNonPaintAnnotations(child, pm, removedAnnotSet);
        }
    }

    private static HashSet<GeneNode> getEvidenceNodesForAnnotation(Annotation a) {
        AnnotationDetail ad = a.getAnnotationDetail();
        HashSet withAnnotSet = ad.getWithAnnotSet();
        if (null == withAnnotSet) {
            return null;
        }
        HashSet<GeneNode> withNodes = new HashSet<GeneNode>();
        PaintManager pm = PaintManager.inst();
        for (Annotation annot : withAnnotSet) {
            Node n = annot.getAnnotationDetail().getAnnotatedNode();
            if (null == n) {
                System.out.println("Annotation id " + a.getAnnotationId() + " does not have annotated node");
                continue;
            }
            withNodes.add(pm.getGeneByPTNId(n.getStaticInfo().getPublicId()));
        }
        return withNodes;
    }

    private static void propagateIBAToDescendants(Annotation propagator, GeneNode gn, List<GeneNode> nodesToSkip, String term, boolean checkTaxonConstraint, TaxonomyHelper th) {
        if (AnnotationUtil.IBAannotationAlreadyExists(term, propagator, gn.getNode())) {
            return;
        }
        AnnotationUtil.addIBAToNode(propagator, gn, term);
        List<GeneNode> children = gn.getChildren();
        if (null == children) {
            return;
        }
        for (GeneNode child : children) {
            if (child.isPruned()) continue;
            AnnotationUtil.propagateIBAToDescendants(propagator, child, nodesToSkip, term, checkTaxonConstraint, th);
        }
    }

    private static void addIBAToNode(Annotation propagator, GeneNode gn, String term) {
        Node n = gn.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            nvi = new NodeVariableInfo();
            n.setVariableInfo(nvi);
        }
        Annotation newAnnot = new Annotation();
        nvi.addGOAnnotation(newAnnot);
        newAnnot.setGoTerm(term);
        AnnotationDetail newDetail = newAnnot.getAnnotationDetail();
        newDetail.setAnnotatedNode(n);
        WithEvidence we = new WithEvidence();
        we.setEvidenceType("PAINT_ANCESTOR");
        we.setEvidenceCode("IBA");
        we.setWith((IWith)propagator);
        newAnnot.addWithEvidence(we);
        LinkedHashMap qualifierLookup = propagator.getAnnotationDetail().getQualifierLookup();
        for (Qualifier q : qualifierLookup.keySet()) {
            Qualifier newQ = new Qualifier();
            newQ.setText(q.getText());
            newDetail.addToInheritedQualifierLookup(newQ, propagator);
            newAnnot.addQualifier(newQ);
        }
    }

    private static Annotation getPropagator(Annotation a) {
        HashSet withSet = a.getAnnotationDetail().getWithEvidenceAnnotSet();
        if (null == withSet) {
            return null;
        }
        for (WithEvidence we : withSet) {
            Annotation with = (Annotation)we.getWith();
            if (a == we.getWith()) continue;
            return with;
        }
        return null;
    }

    public static HashSet<GeneNode> getWithsNodes(Annotation a) {
        AnnotationDetail ad = a.getAnnotationDetail();
        HashSet withSet = ad.getWithEvidenceAnnotSet();
        PaintManager pm = PaintManager.inst();
        HashSet<GeneNode> rtnSet = new HashSet<GeneNode>(withSet.size());
        if (null != withSet) {
            for (WithEvidence with : withSet) {
                Annotation annot = (Annotation)with.getWith();
                Node n = annot.getAnnotationDetail().getAnnotatedNode();
                rtnSet.add(pm.getGeneByPTNId(n.getStaticInfo().getPublicId()));
            }
        }
        if (null != (withSet = ad.getWithEvidenceNodeSet())) {
            for (WithEvidence with : withSet) {
                Node n = (Node)with.getWith();
                rtnSet.add(pm.getGeneByPTNId(n.getStaticInfo().getPublicId()));
            }
        }
        return rtnSet;
    }

    public static HashSet<GeneNode> getWithsFromLastIBD(Annotation a, GeneNode gNode) {
        Annotation ibdAnnot = AnnotationUtil.getLastIBD(a, gNode);
        if (null == ibdAnnot) {
            System.out.println("Did not find last ibd");
            return null;
        }
        AnnotationDetail ad = ibdAnnot.getAnnotationDetail();
        HashSet withSet = ad.getWithAnnotSet();
        if (null == withSet) {
            return null;
        }
        PaintManager pm = PaintManager.inst();
        HashSet<GeneNode> rtnSet = new HashSet<GeneNode>(withSet.size());
        for (Annotation with : withSet) {
            Node n = with.getAnnotationDetail().getAnnotatedNode();
            rtnSet.add(pm.getGeneByPTNId(n.getStaticInfo().getPublicId()));
        }
        return rtnSet;
    }

    public static Annotation getLastIBD(Annotation a, GeneNode gNode) {
        if (null == a) {
            return null;
        }
        if (!"IBD".equals(a.getSingleEvidenceCodeFromSet())) {
            Annotation temp = AnnotationUtil.getWithAnnotation(a, gNode);
            if (null == temp) {
                return null;
            }
            return AnnotationUtil.getLastIBD(temp, PaintManager.inst().getGeneByPTNId(temp.getAnnotationDetail().getAnnotatedNode().getStaticInfo().getPublicId()));
        }
        return a;
    }

    public static Annotation getWithAnnotation(Annotation a, GeneNode gNode) {
        AnnotationDetail ad = a.getAnnotationDetail();
        HashSet withSet = ad.getWithEvidenceAnnotSet();
        if (null == withSet) {
            return null;
        }
        for (WithEvidence with : withSet) {
            Annotation annot = (Annotation)with.getWith();
            if (annot.getAnnotationDetail().getAnnotatedNode().equals(gNode.getNode())) continue;
            return annot;
        }
        return null;
    }

    public static Annotation getWithAnnotationForIBA(Annotation a, GeneNode gNode) {
        return AnnotationUtil.getWithAnnotation(a, gNode);
    }

    public static Annotation getWithIRD_IKR_Annotation(Annotation a, GeneNode node) {
        AnnotationDetail ad = a.getAnnotationDetail();
        HashSet withSet = ad.getWithAnnotSet();
        if (null == withSet) {
            return null;
        }
        for (Annotation with : withSet) {
            Node n = with.getAnnotationDetail().getAnnotatedNode();
            if (n.equals(node.getNode())) continue;
            return with;
        }
        return null;
    }

    public static HashSet<Annotation> deleteAnnotation(GeneNode gNode, Annotation a) {
        HashSet<Annotation> deleteAnnots = new HashSet<Annotation>();
        deleteAnnots.add(a);
        return AnnotationUtil.deleteAnnotation(gNode, a, deleteAnnots);
    }

    public static HashSet<Annotation> deleteAnnotation(GeneNode gNode, Annotation a, HashSet<Annotation> annotsToBeDeleted) {
        HashSet<Annotation> deletedAnnots = new HashSet<Annotation>();
        Node n = gNode.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return deletedAnnots;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return deletedAnnots;
        }
        if (!annotList.contains(a)) {
            return deletedAnnots;
        }
        AnnotationUtil.deleteAnnotation(gNode, a, deletedAnnots, annotsToBeDeleted);
        for (Annotation annot : deletedAnnots) {
            ArrayList aList;
            NodeVariableInfo nodeNvi;
            Node node = annot.getAnnotationDetail().getAnnotatedNode();
            if (null == node || null == (nodeNvi = node.getVariableInfo()) || null == (aList = nodeNvi.getGoAnnotationList())) continue;
            aList.remove(annot);
            System.out.println("Deleted annotation from node " + n.getStaticInfo().getPublicId() + " annotation to term " + annot.getGoTerm());
            if (!aList.isEmpty()) continue;
            nodeNvi.setGoAnnotationList(null);
        }
        return deletedAnnots;
    }

    private static void deleteAnnotation(GeneNode gNode, Annotation a, HashSet<Annotation> deletedAnnots, HashSet<Annotation> annotsToBeDeleted) {
        if (!a.isCreatedByPaint()) {
            return;
        }
        annotsToBeDeleted.add(a);
        Node node = gNode.getNode();
        String code = a.getSingleEvidenceCodeFromSet();
        System.out.println("Deleting annotation for " + gNode.getNode().getStaticInfo().getPublicId() + " code " + a.getSingleEvidenceCodeFromSet());
        ArrayList<GeneNode> descendents = new ArrayList<GeneNode>();
        GeneNodeUtil.allNonPrunedDescendents(gNode, descendents);
        for (GeneNode desc : descendents) {
            ArrayList annotList;
            Node n = desc.getNode();
            NodeVariableInfo nvi = n.getVariableInfo();
            if (null == nvi || null == (annotList = nvi.getGoAnnotationList())) continue;
            Vector deleteInfo = new Vector();
            for (Annotation annot : annotList) {
                if (!annot.withExists(a)) continue;
                if (!annot.isRequired(a)) {
                    System.out.println("Annot to " + annot.getSingleEvidenceCodeFromSet() + " does not require annot with code " + a.getSingleEvidenceCodeFromSet());
                    annot.removeWith(a);
                    HashSet codes = annot.getAnnotationDetail().getEvidenceCodes();
                    if (null != codes && !codes.isEmpty()) continue;
                    AnnotationUtil.deleteAnnotation(desc, annot, annotsToBeDeleted);
                    continue;
                }
                System.out.println("Deleting descendent annotation for " + n.getStaticInfo().getPublicId() + " annot code " + annot.getSingleEvidenceCodeFromSet());
                Vector<GeneNode> deleteLater = new Vector<GeneNode>(2);
                deleteInfo.add(deleteLater);
                deleteLater.add(desc);
                deleteLater.add((GeneNode)annot);
            }
            for (int i = 0; i < deleteInfo.size(); ++i) {
                Vector deleteLater = (Vector)deleteInfo.get(i);
                AnnotationUtil.deleteAnnotation((GeneNode)deleteLater.get(0), (Annotation)deleteLater.get(1), annotsToBeDeleted);
            }
        }
        if ("IKR".equals(code) || "IRD".equals(code)) {
            Annotation propagator = AnnotationUtil.getPropagator(a);
            Annotation iba = AnnotationUtil.getAssociatedIBAForIKRorIRD(gNode, a);
            if (null != iba) {
                String goTerm = iba.getGoTerm();
                AnnotationUtil.deleteAnnotation(gNode, iba, annotsToBeDeleted);
                for (GeneNode gn : descendents) {
                    ArrayList annotList;
                    Node n = gn.getNode();
                    NodeVariableInfo nvi = n.getVariableInfo();
                    if (null == nvi || null == (annotList = nvi.getGoAnnotationList())) continue;
                    Vector deleteInfo = new Vector();
                    for (Annotation annot : annotList) {
                        Vector<GeneNode> deleteLater;
                        Annotation curProp;
                        if (!goTerm.equals(annot.getGoTerm()) || propagator != (curProp = AnnotationUtil.getPropagator(annot))) continue;
                        QualifierDif qd = new QualifierDif(iba.getQualifierSet(), annot.getQualifierSet());
                        String curCode = annot.getSingleEvidenceCodeFromSet();
                        if (0 == qd.getDifference() && "IBA".equals(curCode)) {
                            deleteLater = new Vector<GeneNode>(2);
                            deleteInfo.add(deleteLater);
                            deleteLater.add(gn);
                            deleteLater.add((GeneNode)annot);
                        }
                        if (!QualifierDif.areOpposite((Set)iba.getQualifierSet(), (Set)annot.getQualifierSet()) || !"IKR".equals(curCode) && !"IRD".equals(curCode) && !"TCV".equals(curCode)) continue;
                        deleteLater = new Vector(2);
                        deleteInfo.add(deleteLater);
                        deleteLater.add(gn);
                        deleteLater.add((GeneNode)annot);
                    }
                    for (int i = 0; i < deleteInfo.size(); ++i) {
                        Vector deleteLater = (Vector)deleteInfo.get(i);
                        AnnotationUtil.deleteAnnotation((GeneNode)deleteLater.get(0), (Annotation)deleteLater.get(1), annotsToBeDeleted);
                    }
                }
            }
            deletedAnnots.add(a);
            if (annotsToBeDeleted.contains(propagator) || deletedAnnots.contains(propagator)) {
                return;
            }
            Annotation ibd = AnnotationUtil.getLastIBD(a, gNode);
            Node ibdProp = ibd.getAnnotationDetail().getAnnotatedNode();
            PaintManager pm = PaintManager.inst();
            ArrayList<GeneNode> evNodes = AnnotationUtil.getNodesProvidingExperimentalEvidence(ibd, pm.getGeneByPTNId(ibdProp.getStaticInfo().getPublicId()));
            System.out.println("Creating IBA's for " + propagator.getGoTerm());
            AnnotationUtil.propagateIBAToDescendants(propagator, gNode, evNodes, propagator.getGoTerm(), false, pm.getTaxonHelper());
            return;
        }
        deletedAnnots.add(a);
    }

    public static boolean hasDirectNot(GeneNode gNode, GOTermHelper gth) {
        Node node = gNode.getNode();
        NodeVariableInfo nvi = node.getVariableInfo();
        if (null == nvi) {
            return false;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return false;
        }
        String go_aspect = AspectSelector.aspects.get(AspectSelector.inst().getAspect().toString());
        for (Annotation annot : annotList) {
            LinkedHashMap map;
            String code;
            if (!go_aspect.equals(gth.getTerm(annot.getGoTerm()).getAspect()) || !"IBD".equals(code = annot.getSingleEvidenceCodeFromSet()) && (!"IKR".equals(code) || gNode.isLeaf()) && !"IRD".equals(code) && !"TCV".equals(code) || !QualifierDif.containsNegative((map = annot.getAnnotationDetail().getQualifierLookup()).keySet())) continue;
            return true;
        }
        return false;
    }

    public static void propagateIBD(Annotation ibd) {
        HashSet modifiedSet = new HashSet();
        StringBuffer errorMsgBuf = new StringBuffer();
        PaintManager pm = PaintManager.inst();
        AnnotationHelper.propagateIBD((Annotation)ibd, (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper(), (StringBuffer)errorMsgBuf, modifiedSet, new HashSet());
    }

    public static HashSet<Annotation> getApplicableAnnotations(ArrayList<GeneNode> leaves, GOTerm goTerm, GOTermHelper gth, HashSet<Qualifier> qSet) {
        HashSet<Annotation> annots = new HashSet<Annotation>();
        for (GeneNode leaf : leaves) {
            AnnotationForTerm aft = new AnnotationForTerm(leaf, goTerm, gth);
            if (!aft.annotationExists()) continue;
            for (Annotation a : aft.getAnnotSet()) {
                QualifierDif qd = new QualifierDif(qSet, a.getQualifierSet());
                if (0 != qd.getDifference()) continue;
                annots.add(a);
            }
        }
        return annots;
    }

    public static void graftBranch(GeneNode gNode) {
        PaintManager pm = PaintManager.inst();
        AnnotationHelper.fixAnnotationsForGraftPruneExpOperation((Node)pm.getTree().getRoot().getNode(), (Node)gNode.getNode(), (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper());
        AnnotationUtil.branchNotify(gNode);
    }

    public static void pruneBranch(GeneNode gNode) {
        ArrayList<GeneNode> descendents = new ArrayList<GeneNode>();
        GeneNodeUtil.allDescendents(gNode, descendents);
        descendents.add(0, gNode);
        for (GeneNode desc : descendents) {
            ArrayList annotList;
            Node node = desc.getNode();
            NodeVariableInfo nvi = node.getVariableInfo();
            if (null == nvi || null == (annotList = nvi.getGoAnnotationList())) continue;
            Iterator annotIter = annotList.iterator();
            while (annotIter.hasNext()) {
                Annotation a = (Annotation)annotIter.next();
                if (a.isExperimental()) continue;
                annotIter.remove();
            }
        }
        PaintManager pm = PaintManager.inst();
        AnnotationHelper.fixAnnotationsForGraftPruneExpOperation((Node)pm.getTree().getRoot().getNode(), (Node)gNode.getNode(), (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper());
        AnnotationUtil.branchNotify(gNode);
    }

    public static void branchNotify(GeneNode node) {
        TreePanel tree = PaintManager.inst().getTree();
        tree.handlePruning(node);
        if (node.isLeaf()) {
            MSAPanel msa = PaintManager.inst().getMSAPanel();
            msa.handlePruning(node);
        }
        EventManager.inst().fireAnnotationChangeEvent(new AnnotationChangeEvent(node));
    }

    public static Annotation getAssociatedIBAForIKRorIRD(GeneNode gNode, Annotation IKRorIRDAnnotation) {
        Node node;
        NodeVariableInfo nvi;
        Node n = gNode.getNode();
        String code = IKRorIRDAnnotation.getSingleEvidenceCodeFromSet();
        if (!"IRD".equals(code) && !"IKR".equals(code) || !gNode.isLeaf()) {
            System.out.println("Call to get associated IBA for non IKR or IRD");
            return null;
        }
        Annotation with = null;
        HashSet ikrIrdwithSet = IKRorIRDAnnotation.getAnnotationDetail().getWithAnnotSet();
        if (null == ikrIrdwithSet) {
            return null;
        }
        for (Annotation iw : ikrIrdwithSet) {
            HashSet withSet = iw.getAnnotationDetail().getWithAnnotSet();
            if (null == withSet || iw == IKRorIRDAnnotation) continue;
            with = iw;
            break;
        }
        if (null == (nvi = (node = gNode.getNode()).getVariableInfo())) {
            return null;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return null;
        }
        for (Annotation a : annotList) {
            if (a == IKRorIRDAnnotation || !"IBA".equals(a.getSingleEvidenceCodeFromSet()) || !a.getAnnotationDetail().getWithAnnotSet().contains(with)) continue;
            return a;
        }
        return null;
    }

    public static Annotation getAssociatedIKRorIRDforIBA(GeneNode gNode, Annotation ibaAnnotation) {
        Node node;
        NodeVariableInfo nvi;
        if (!"IBA".equals(ibaAnnotation.getSingleEvidenceCodeFromSet())) {
            System.out.println("Call to get associated IRD OR IKR for non IBA");
            return null;
        }
        Annotation with = null;
        Iterator iterator = ibaAnnotation.getAnnotationDetail().getWithAnnotSet().iterator();
        if (iterator.hasNext()) {
            Annotation aWith;
            with = aWith = (Annotation)iterator.next();
        }
        if (null == (nvi = (node = gNode.getNode()).getVariableInfo())) {
            return null;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return null;
        }
        for (Annotation a : annotList) {
            String code = a.getSingleEvidenceCodeFromSet();
            if (!"IKR".equals(code) && !"IRD".equals(code) || !a.getAnnotationDetail().getWithAnnotSet().contains(with)) continue;
            return a;
        }
        return null;
    }

    public static HashSet<Annotation> getAnnotationsForTerm(GeneNode gNode, GOTerm term) {
        HashSet<Annotation> annotSet = new HashSet<Annotation>();
        GOTermHelper gth = PaintManager.inst().goTermHelper();
        ArrayList<GeneNode> desc = new ArrayList<GeneNode>();
        GeneNodeUtil.allNonPrunedDescendents(gNode, desc);
        List<GeneNode> leaves = GeneNodeUtil.getAllLeaves(desc);
        for (GeneNode leaf : leaves) {
            AnnotationForTerm aft = new AnnotationForTerm(leaf, term, gth);
            if (!aft.annotationExists()) continue;
            annotSet.addAll(aft.getAnnotSet());
        }
        if (annotSet.isEmpty()) {
            return null;
        }
        return annotSet;
    }

    public static ArrayList<AnnotationForTerm> getAnnotsAndApplicableQls(GeneNode gNode, GOTerm term) {
        ArrayList<AnnotationForTerm> annotForTerm = new ArrayList<AnnotationForTerm>();
        GOTermHelper gth = PaintManager.inst().goTermHelper();
        ArrayList<GeneNode> desc = new ArrayList<GeneNode>();
        GeneNodeUtil.allNonPrunedDescendents(gNode, desc);
        List<GeneNode> leaves = GeneNodeUtil.getAllLeaves(desc);
        for (GeneNode leaf : leaves) {
            AnnotationForTerm aft = new AnnotationForTerm(leaf, term, gth);
            if (!aft.annotationExists()) continue;
            annotForTerm.add(aft);
        }
        if (annotForTerm.isEmpty()) {
            return null;
        }
        return annotForTerm;
    }

    public static boolean qualifiersMatch(HashSet<Annotation> annotSet) {
        if (null == annotSet || annotSet.isEmpty()) {
            return false;
        }
        Boolean positive = null;
        Boolean negative = null;
        for (Annotation a : annotSet) {
            if (null != positive && null != negative) break;
            if (QualifierDif.containsNegative((Set)a.getQualifierSet())) {
                negative = true;
                continue;
            }
            positive = true;
        }
        return null == positive || null == negative;
    }

    public static boolean contains(HashSet<WithEvidence> withEvSet, IWith with) {
        if (null == withEvSet || null == with) {
            return false;
        }
        for (WithEvidence we : withEvSet) {
            if (we.getWith() != with) continue;
            return true;
        }
        return false;
    }
}

