/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import com.sri.panther.paintCommon.util.Utils;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.paint.datamodel.GeneNode;
import org.paint.main.PaintManager;
import org.paint.util.PantherParseUtil;

public class GeneNodeUtil {
    public static final String DELIM = ",();";
    protected static final String SEMI_COLON = ";";
    protected static final String OPEN_PAREN = "(";
    protected static final String CLOSE_PAREN = ")";
    protected static final String COMMA = ",";
    protected static final String COLON = ":";
    protected static final String OPEN_BRACKET = "[";
    protected static final String CLOSE_BRACKET = "]";
    protected static final String NEWLINE = "\n";
    protected static final String TAB = "\t";
    protected static final String SPACE = " ";
    protected static final String PLUS = "+";
    private static final String NODE_TYPE_ANNOTATION = "ID=";
    private static final int NODE_TYPE_ANNOTATION_LENGTH = "ID=".length();
    public static final String MSG_INVALID_AN_ID = "Invalid annotation id encountered ";
    public static final String ERROR_MSG_DATA_FOR_NON_AN = "Found data for non-existant annotation node ";
    public static final String STR_EMPTY = "";
    public static final Logger logger = Logger.getLogger(GeneNodeUtil.class);
    private static GeneNodeUtil singleton = null;
    public static final String DATABASE_PREFIX_MGI = "MGI:";
    public static final String SPECIAL_CASE_TAIR = "TAIR";
    public static final String SPECIAL_CASE_MGI = "MGI";
    public static final String[] SPECIAL_CASE_SOURCES = new String[]{"TAIR", "MGI"};

    public static GeneNodeUtil inst() {
        if (singleton == null) {
            singleton = new GeneNodeUtil();
        }
        return singleton;
    }

    public GeneNode parseTreeData(String[] treeContents, HashMap<String, Node> nodeLookup, String familyId) {
        if (null == treeContents) {
            return null;
        }
        if (0 == treeContents.length) {
            return null;
        }
        if (1 == treeContents.length) {
            treeContents = Utils.tokenize((String)treeContents[0], (String)SEMI_COLON);
        }
        GeneNode root = this.parseTreeString(treeContents[0]);
        for (int i = 1; i < treeContents.length; ++i) {
            String line = treeContents[i];
            int index = line.indexOf(COLON);
            String anId = line.substring(0, index);
            GeneNode node = PaintManager.inst().getGeneByPaintId(anId);
            if (null == node) {
                logger.error((Object)(ERROR_MSG_DATA_FOR_NON_AN + anId));
                continue;
            }
            PantherParseUtil.inst().parseIDstr(node, line.substring(index + 1));
        }
        this.initNodeProperties(root, nodeLookup, familyId);
        return root;
    }

    private GeneNode parseTreeString(String s) {
        GeneNode node = null;
        GeneNode root = null;
        StringTokenizer st = new StringTokenizer(s, DELIM, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(OPEN_PAREN)) {
                if (null == node) {
                    root = node = new GeneNode(false);
                    continue;
                }
                GeneNode newChild = new GeneNode(false);
                List<GeneNode> children = node.getChildren();
                if (null == children) {
                    children = new ArrayList<GeneNode>();
                }
                children.add(newChild);
                newChild.setParent(node);
                node.setChildren(children);
                node = newChild;
                node.setExpanded(true);
                continue;
            }
            if (token.equals(CLOSE_PAREN) || token.equals(COMMA) || token.equals(SEMI_COLON)) continue;
            int squareIndexStart = token.indexOf(OPEN_BRACKET);
            int squareIndexEnd = token.indexOf(CLOSE_BRACKET);
            if (0 == squareIndexStart) {
                String type = token.substring(squareIndexStart, squareIndexEnd + 1);
                this.setTypeAndId(type, node);
                continue;
            }
            int index = token.indexOf(COLON);
            if (0 == index) {
                if (-1 == squareIndexStart) {
                    node.setDistanceFromParent(Float.valueOf(token.substring(index + 1)).floatValue());
                } else {
                    node.setDistanceFromParent(Float.valueOf(token.substring(index + 1, squareIndexStart)).floatValue());
                    String type = token.substring(squareIndexStart, squareIndexEnd + 1);
                    this.setTypeAndId(type, node);
                }
                node = node.getParent();
                continue;
            }
            if (index <= 0) continue;
            GeneNode newChild = new GeneNode(false);
            if (-1 == squareIndexStart) {
                newChild.setDistanceFromParent(Float.valueOf(token.substring(index + 1)).floatValue());
                this.setTypeAndId(token.substring(0, index), newChild);
            } else {
                newChild.setDistanceFromParent(Float.valueOf(token.substring(index + 1, squareIndexStart)).floatValue());
                String type = token.substring(squareIndexStart, squareIndexEnd + 1);
                this.setTypeAndId(type, newChild);
            }
            List<GeneNode> children = node.getChildren();
            if (null == children) {
                children = new ArrayList<GeneNode>();
            }
            children.add(newChild);
            newChild.setParent(node);
            node.setChildren(children);
            node.setExpanded(true);
        }
        return root;
    }

    private void initNodeProperties(GeneNode node, HashMap<String, Node> nodeLookup, String familyId) {
        if (null == node) {
            return;
        }
        String anId = node.getPaintId();
        if (null != nodeLookup) {
            String lookupId = familyId + COLON + anId;
            Node n = nodeLookup.get(lookupId);
            if (null != n) {
                NodeVariableInfo nvi;
                node.setNode(n);
                node.setPersistantNodeID(n.getStaticInfo().getPublicId());
                String longGeneName = n.getStaticInfo().getLongGeneName();
                if (null != longGeneName) {
                    String[] parts = longGeneName.split(Pattern.quote("|"));
                    int length = parts.length;
                    if (length < 2) {
                        return;
                    }
                    String[] geneParts = parts[1].split("=");
                    if (geneParts.length < 2) {
                        return;
                    }
                    String geneSource = geneParts[0];
                    Object geneId = geneParts[1];
                    if (Utils.search((String[])SPECIAL_CASE_SOURCES, (String)geneSource)) {
                        if (geneSource.equals(SPECIAL_CASE_MGI) && !geneSource.startsWith(DATABASE_PREFIX_MGI)) {
                            geneId = geneParts.length >= 3 ? DATABASE_PREFIX_MGI + geneParts[2] : DATABASE_PREFIX_MGI + (String)geneId;
                        }
                        if (geneSource.equals(SPECIAL_CASE_TAIR) && geneParts.length >= 3) {
                            geneId = geneParts[2];
                        }
                    }
                    node.setGeneSource(geneSource);
                    node.setGeneId((String)geneId);
                    String[] proteinParts = parts[2].split("=");
                    if (proteinParts.length < 2) {
                        return;
                    }
                    node.setProteinSource(proteinParts[0]);
                    node.setProteinId(proteinParts[1]);
                }
                if (null != (nvi = n.getVariableInfo()) && nvi.isPruned()) {
                    node.setPrune(true);
                }
            } else {
                System.out.println("Did not find node information for " + lookupId);
            }
        } else {
            System.out.println("Did not find any node information to match with tree");
        }
        node.setOriginalChildrenToCurrentChildren();
        List<GeneNode> children = node.getChildren();
        if (null == children) {
            node.setExpanded(false);
        } else {
            node.setExpanded(true);
            for (int i = 0; i < children.size(); ++i) {
                this.initNodeProperties(children.get(i), nodeLookup, familyId);
            }
        }
    }

    public void setVisibleRows(List<GeneNode> node_list, List<GeneNode> contents) {
        contents.clear();
        contents.addAll(node_list);
    }

    private void setTypeAndId(String nodeType, GeneNode node) {
        String annot_id;
        if (null == nodeType) {
            return;
        }
        if (!nodeType.startsWith("AN")) {
            int endIndex;
            node.setType(nodeType);
            int index = nodeType.indexOf("S=");
            if (index >= 0) {
                endIndex = nodeType.indexOf(COLON, index);
                if (-1 == endIndex) {
                    endIndex = nodeType.indexOf(CLOSE_BRACKET);
                }
                String species = nodeType.substring(index + "S=".length(), endIndex);
                node.setSpecies(species);
                node.addSpeciesLabel(species);
            }
            if ((index = nodeType.indexOf(NODE_TYPE_ANNOTATION)) >= 0) {
                endIndex = nodeType.indexOf(COLON, index);
                if (-1 == endIndex) {
                    endIndex = nodeType.indexOf(CLOSE_BRACKET);
                }
                annot_id = nodeType.substring(index + NODE_TYPE_ANNOTATION_LENGTH, endIndex);
            } else {
                annot_id = null;
            }
        } else {
            annot_id = nodeType;
        }
        if (annot_id != null) {
            if (!annot_id.startsWith("AN")) {
                logger.debug((Object)(annot_id + " isn't an AN number"));
            }
            if (node.getPaintId().length() > 0) {
                logger.debug((Object)(annot_id + "AN number is already set to " + node.getPaintId()));
            }
            node.setPaintId(annot_id);
        }
    }

    public static void allDescendents(GeneNode gNode, List<GeneNode> nodeList) {
        if (null == gNode || null == nodeList) {
            return;
        }
        List<GeneNode> children = gNode.getChildren();
        if (null == children) {
            return;
        }
        for (GeneNode child : children) {
            nodeList.add(child);
            GeneNodeUtil.allDescendents(child, nodeList);
        }
    }

    public static void getAncestors(GeneNode gNode, List<GeneNode> ancestors) {
        if (null == gNode || null == ancestors) {
            return;
        }
        GeneNode parent = gNode.getParent();
        if (null != parent) {
            ancestors.add(parent);
            GeneNodeUtil.getAncestors(parent, ancestors);
        }
    }

    public static void allNonPrunedDescendents(GeneNode gNode, List<GeneNode> nodeList) {
        if (null == gNode || null == nodeList) {
            return;
        }
        Node n = gNode.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi && nvi.isPruned()) {
            return;
        }
        List<GeneNode> children = gNode.getChildren();
        if (null == children) {
            return;
        }
        for (GeneNode child : children) {
            Node cn = child.getNode();
            NodeVariableInfo childNvi = cn.getVariableInfo();
            if (null != childNvi && childNvi.isPruned()) continue;
            nodeList.add(child);
            GeneNodeUtil.allNonPrunedDescendents(child, nodeList);
        }
    }

    public static boolean inPrunedBranch(GeneNode gNode) {
        if (gNode.isPruned()) {
            return true;
        }
        GeneNode copy = gNode;
        return GeneNodeUtil.hasPrunedAncestor(copy);
    }

    private static boolean hasPrunedAncestor(GeneNode gNode) {
        GeneNode parent = gNode.getParent();
        if (null == parent) {
            return false;
        }
        if (parent.isPruned()) {
            return true;
        }
        return GeneNodeUtil.hasPrunedAncestor(parent);
    }

    public static List<GeneNode> getAllLeaves(List<GeneNode> list) {
        if (null == list) {
            return null;
        }
        ArrayList<GeneNode> rtnList = new ArrayList<GeneNode>();
        for (GeneNode gNode : list) {
            if (!gNode.isLeaf()) continue;
            rtnList.add(gNode);
        }
        return rtnList;
    }

    public static boolean hasDirectAnnotation(GeneNode gNode) {
        Node n = gNode.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return false;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return false;
        }
        for (Annotation annot : annotList) {
            String evidenceCode = annot.getSingleEvidenceCodeFromSet();
            if (!"IBD".equals(evidenceCode) && !"IKR".equals(evidenceCode) && !"IRD".equals(evidenceCode)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAllPropagatedAnnotation(GeneNode gNode) {
        Node n = gNode.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return false;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList || 0 == annotList.size()) {
            return false;
        }
        for (Annotation annot : annotList) {
            String evidenceCode = annot.getSingleEvidenceCodeFromSet();
            if (!"IBD".equals(evidenceCode) && !"IKR".equals(evidenceCode) && !"IRD".equals(evidenceCode)) continue;
            return false;
        }
        return true;
    }
}

