/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.net.URI;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;
import org.bbop.swing.HyperlinkLabel;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.gui.event.TermHyperlinkListener;

public class HTMLUtil {
    protected static final String COMMA_DELIM = ",";
    protected static final String SPACE_DELIM = " ";
    protected static final String SEMI_COLON_DELIM = ";";
    protected static final String REPLACE_STRING = "XXX";
    protected static final String SPECIES_SPOT = "YYY";
    protected static final String PAINT_LINK_PREFIX = "paint?id=";
    public static final String HTML_TEXT_BEGIN = "<html>";
    public static final String HTML_TEXT_END = "</html>";
    protected static final String[][] URL_primary = new String[][]{{"ENSEMBL", "http://www.ensembl.org/YYY/Gene/Summary?g=XXX"}, {"Ensembl", "http://www.ensembl.org/YYY/Gene/Summary?g=XXX"}, {"EnsemblGenome", "http://www.uniprot.org/uniprot/?query=XXX&sort=score"}, {"ENTREZ", "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=protein&id=XXX"}, {"RefSeq", "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=protein&id=XXX"}, {"FB", "http://flybase.org/reports/XXX"}, {"FlyBase", "http://flybase.org/reports/XXX"}, {"MGI", "http://www.informatics.jax.org/marker/XXX"}, {"ZFIN", "http://zfin.org/cgi-bin/webdriver?MIval=aa-markerview.apg&OID=XXX"}, {"WB", "http://wormbase.org/db/gene/gene?name=XXX;class=Gene"}, {"PomBase", "http://www.pombase.org/spombe/result/XXX"}, {"GeneDB_Spombe", "http://www.pombase.org/spombe/result/XXX"}, {"AspGD", "http://www.aspergillusgenome.org/cgi-bin/locus.pl?locus=XXX"}, {"dictyBase", "http://dictybase.org/gene/XXX"}, {"TAIR", "http://www.arabidopsis.org/servlets/TairObject?type=locus&name=XXX"}, {"CGD", "http://www.candidagenome.org/cgi-bin/locus.pl?dbid=XXX"}, {"Xenbase", "http://www.xenbase.org/gene/showgene.do?method=display&geneId=XXX"}, {"ECOLI", "http://biocyc.org/ECOLI/NEW-IMAGE?type=NIL&object=XXX"}, {"SGD", "https://www.yeastgenome.org/locus/XXX"}, {"RGD", "http://rgd.mcw.edu/tools/genes/genes_view.cgi?id=XXX"}, {"AMIGO", "http://amigo.geneontology.org/amigo/term/XXX"}, {"taxonomy", "http://www.ncbi.nlm.nih.gov/htbin-post/Taxonomy/wgetorg?mode=Undef&name=XXX&searchtype=1&lvl=3"}, {"Reactome", "http://www.reactome.org/PathwayBrowser/#XXX"}, {"mim", "http://www.ncbi.nlm.nih.gov/entrez/dispomim.cgi?id=XXX"}, {"pdb", "http://www.rcsb.org/pdb/cgi/explore.cgi?pdbId=XXX"}, {"pir", "http://pir.georgetown.edu/cgi-bin/nbrfget?uid=XXX"}, {"prosite", "http://www.expasy.ch/cgi-bin/prosite-search-ac?XXX"}, {"uniprot", "http://www.uniprot.org/uniprot/XXX"}, {"UniProtKB", "http://www.uniprot.org/uniprot/?query=XXX"}, {"GeneID", "http://www.uniprot.org/uniprot/?query=XXX&sort=score"}, {"wormpep", "http://www.sanger.ac.uk/cgi-bin/Projects/C_elegans/wormpep_fetch.pl?what=protein&type=exact&entry=XXX"}, {"maize_db", "http://www.maizegdb.org/cgi-bin/displaygprecord.cgi?id=XXX"}, {"embl", "http://www.ebi.ac.uk/cgi-bin/emblfetch?style=html&id=XXX&Submit=Go"}, {"uniprot", "http://www.pir.uniprot.org/cgi-bin/upEntry?id=XXX"}, {"hssp", "http://srs.ebi.ac.uk/srs7bin/cgi-bin/wgetz?-e+[hssp-ID:XXX]"}, {"pantree", "http://pantree.org/node/annotationNode.jsp?id=XXX"}, {"PANTHER", "http://pantree.org/node/annotationNode.jsp?id=XXX"}, {"pfam", "http://www.sanger.ac.uk/cgi-bin/Pfam/getacc?XXX"}, {"prints", "http://umber.sbs.man.ac.uk/cgi-bin/dbbrowser/PRINTS/DoPRINTS.pl?cmd_a=Display&qua_a=none&fun_a=Text&qst_a=XXX"}, {"prodom", "http://protein.toulouse.inra.fr/prodom/current/cgi-bin/request.pl?question=DBLI&query=XXX"}, {"pirsf", "http://pir.georgetown.edu/cgi-bin/ipcSF?id=XXX"}, {"WormBase", "http://www.wormbase.org/species/c_elegans/gene/XXX"}, {"EcoCyc", "http://biocyc.org/ECOLI/NEW-IMAGE?type=NIL&object=XXX"}, {"MetaCyc", "http://metacyc.org/META/NEW-IMAGE?type=NIL&object=XXX&redirect=T"}, {"Gene", "https://www.google.com/search?q=XXX"}};
    protected static final String[][] URL_references = new String[][]{{"ENTREZ", "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=protein&id=XXX"}, {"RefSeq", "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=protein&id=XXX"}, {"FB", "http://flybase.org/reports/XXX"}, {"MGI", "http://www.informatics.jax.org/searches/accession_report.cgi?id=XXX"}, {"ZFIN", "http://zfin.org/cgi-bin/webdriver?MIval=aa-pubview2.apg&OID=XXX"}, {"WB", "http://wormbase.org/db/misc/paper?name=XXX;class=Paper"}, {"dictyBase", "http://dictybase.org/db/cgi-bin/feature_page.pl?primary_id=XXX"}, {"TAIR", "http://www.arabidopsis.org/servlets/TairObject?accession=XXX"}, {"ECOLI", "http://biocyc.org/ECOLI/NEW-IMAGE?type=NIL&object=XXX"}, {"SGD_REF", "https://www.yeastgenome.org/locus/XXX"}, {"RGD", "http://rgd.mcw.edu/tools/references/references_view.cgi?id=XXX"}, {"PMID", "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=pubmed&dopt=Abstract&list_uids=XXX"}, {"medline", "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=XXX&dopt=Abstract"}, {"WormBase", "http://www.wormbase.org/species/c_elegans/gene/XXX"}};
    private static final Logger LOG = Logger.getLogger(HTMLUtil.class);

    public static void setHyperlinkField(GeneNode node, HyperlinkLabel field, String label_txt) {
        Object panelText = HTML_TEXT_BEGIN;
        String guts = HTMLUtil.getLinkForDB(node, label_txt, URL_primary);
        String id = "";
        if (node != null && label_txt != null) {
            id = label_txt.equals("Accession") ? node.getSeqId() : (label_txt.equals("Permanent Tree ID") ? node.getPersistantNodeID() : (node.getDatabase().equals("PANTHER") ? node.getPersistantNodeID() : node.getDatabaseID()));
        }
        if (guts != null) {
            panelText = (String)panelText + "<a href=\"" + guts + "\">" + id + "</a>";
            field.setToolTipText(guts);
            field.setFont(Preferences.inst().getFont());
        } else {
            field.setToolTipText("no link");
            panelText = (String)panelText + id;
        }
        panelText = (String)panelText + HTML_TEXT_END;
        field.setText((String)panelText);
    }

    public static HyperlinkLabel makeHyperlinkField(TermHyperlinkListener termHyperlinkListener) {
        HyperlinkLabel field = new HyperlinkLabel();
        field.setEnabled(true);
        if (null != termHyperlinkListener) {
            field.addHyperlinkListener((HyperlinkListener)termHyperlinkListener);
        }
        return field;
    }

    private static String getLinkForDB(GeneNode node, String label_txt, String[][] URL_array) {
        String id = null;
        String db = null;
        if (node != null && label_txt != null) {
            if (label_txt.equals("Accession")) {
                id = node.getSeqId();
                db = node.getSeqDB();
                if (id != null && id.length() > 0) {
                    // empty if block
                }
            } else if (label_txt.equals("Permanent Tree ID")) {
                id = node.getPersistantNodeID();
                db = "pantree";
            } else {
                id = node.getDatabaseID();
                db = node.getDatabase();
            }
        }
        if (id != null && id.length() > 0 && db != null && db.length() > 0) {
            String temp_url;
            String url = temp_url = HTMLUtil.getURLLinks(id, db, URL_array);
            if (temp_url != null && temp_url.indexOf(SPECIES_SPOT) > 0) {
                Pattern pattern = Pattern.compile(SPECIES_SPOT);
                Object species = node.getSpeciesLabel();
                String[] two = ((String)species).split(SPACE_DELIM);
                if (two.length > 1) {
                    species = two[0] + "_" + two[1];
                }
                Matcher matcher = pattern.matcher(temp_url);
                url = matcher.replaceAll((String)species);
                if (id.charAt(6) == 'P') {
                    temp_url = url;
                    pattern = Pattern.compile("g=");
                    matcher = pattern.matcher(temp_url);
                    url = matcher.replaceAll("p=");
                }
            }
            return url;
        }
        return null;
    }

    private static String getURLLinks(String id, String DBname, String[][] URL_array) {
        if (0 == id.length() || DBname.length() == 0) {
            return null;
        }
        if (DBname.equals("Accession")) {
            DBname = id.startsWith("ENS") ? "ENSEMBL" : (id.indexOf(95) >= 0 ? "ENTREZ" : "uniprot");
        }
        String url = null;
        for (int i = 0; i < URL_array.length && url == null; ++i) {
            if (!URL_array[i][0].equals(DBname)) continue;
            String template = URL_array[i][1];
            Pattern pattern = Pattern.compile(REPLACE_STRING);
            Matcher matcher = pattern.matcher(template);
            url = matcher.replaceAll(id);
        }
        return url;
    }

    public static String getHTML(String DBname, String accession, boolean basic) {
        return HTMLUtil.getHTML(DBname, accession, accession, basic);
    }

    public static String getURL(String DBname, String accession, boolean basic) {
        if (basic) {
            return HTMLUtil.getURLLinks(accession, DBname, URL_primary);
        }
        return HTMLUtil.getURLLinks(accession, DBname, URL_references);
    }

    private static String getHTML(String DBname, String acc, String name, boolean basic) {
        String link = basic ? HTMLUtil.getURLLinks(acc, DBname, URL_primary) : HTMLUtil.getURLLinks(acc, DBname, URL_references);
        Object html = HTML_TEXT_BEGIN;
        html = link != null ? (String)html + "<a href=\"" + link + "\">" + DBname + ":" + name + "</a>" : (String)html + (String)(DBname == null ? "" : DBname + ":") + name;
        html = (String)html + HTML_TEXT_END;
        return html;
    }

    public static void bringUpInBrowser(String text) {
        URL url;
        try {
            url = new URL(text);
        }
        catch (Exception e) {
            LOG.warn((Object)("could not create url from \"" + text + "\""));
            return;
        }
        HTMLUtil.bringUpInBrowser(url);
    }

    public static void bringUpInBrowser(BrowserLauncher bl, String url) {
        BrowserLauncher tmp = bl;
        if (null == tmp) {
            try {
                tmp = new BrowserLauncher();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != tmp) {
            try {
                tmp.openURLinBrowser(url);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url.toString()));
            } else {
                System.out.println("Can't open browser, Desktop is not supported");
            }
        }
        catch (Exception e) {
            System.out.println("Could not open browser using desktop browse functionality");
            e.printStackTrace();
        }
    }

    public static void bringUpInBrowser(URL url) {
        if (url == null) {
            return;
        }
        try {
            BrowserLauncher bl = new BrowserLauncher();
            bl.openURLinBrowser(url.toString());
            return;
        }
        catch (BrowserLaunchingInitializingException be) {
            LOG.error((Object)"cant launch browser ", (Throwable)be);
        }
        catch (UnsupportedOperatingSystemException ue) {
            LOG.error((Object)"cant launch browser ", (Throwable)ue);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot launch browser ", (Throwable)e);
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url.toString()));
            }
        }
        catch (Exception e) {
            System.out.println("Could not open browser using desktop browse functionality exception " + e.getMessage() + " has been returned");
        }
    }

    public static String displayPropertiesToCSS(Font font, Color fg) {
        StringBuffer rule = new StringBuffer("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            if (fg.getRed() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getRed()));
            if (fg.getGreen() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getGreen()));
            if (fg.getBlue() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getBlue()));
            rule.append(" ; ");
        }
        rule.append(" }");
        return rule.toString();
    }

    public static boolean isInternalLink(HyperlinkEvent e) {
        return e.getURL() == null && e.getDescription().startsWith(PAINT_LINK_PREFIX);
    }

    public static String getIdFromHyperlink(HyperlinkEvent e) {
        String desc = e.getDescription();
        if (desc == null || desc.equals("")) {
            return null;
        }
        String id = HTMLUtil.getIdFromHyperlinkDesc(desc);
        return id;
    }

    private static String getIdFromHyperlinkDesc(String desc) {
        return desc.substring(PAINT_LINK_PREFIX.length());
    }
}

