/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.CharBuffer;
import java.util.Date;
import org.apache.log4j.Logger;

public class InternetChecker {
    private static final String URL_TO_CHECK = "http://www.google.com/";
    private static final long CHECK_EVERY = 1800000L;
    private static final int BUF_SIZE = 1024;
    private static InternetChecker ref;
    private Date lastCheck;
    private Boolean lastState;
    private final Logger log = Logger.getLogger((String)InternetChecker.class.getName());

    public static synchronized InternetChecker getInstance() {
        if (ref == null) {
            ref = new InternetChecker();
        }
        return ref;
    }

    private boolean isStateValid() {
        if (this.lastState == null) {
            return false;
        }
        return this.lastCheck.getTime() <= System.currentTimeMillis() + 1800000L;
    }

    public boolean isConnectionPresent() {
        if (!this.isStateValid()) {
            this.checkConnection();
        }
        return this.lastState;
    }

    public boolean isConnectionPresent(boolean forceCheck) {
        if (forceCheck) {
            this.invalidateState();
        }
        return this.isConnectionPresent();
    }

    private void invalidateState() {
        this.lastCheck = null;
        this.lastState = null;
    }

    public void checkConnection() {
        this.lastCheck = new Date();
        try {
            URL url = new URL(URL_TO_CHECK);
            URLConnection urlConnection = url.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            StringBuilder contents = new StringBuilder();
            CharBuffer buf = CharBuffer.allocate(1024);
            while (true) {
                ((Reader)reader).read(buf);
                if (!buf.hasRemaining()) break;
                contents = contents.append(buf);
            }
            inputStream.close();
            this.lastState = true;
        }
        catch (Exception e) {
            System.out.println("Internet connectivity not present.");
            this.lastState = false;
        }
    }
}

