/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.paint.datamodel.GeneNode;

public class PantherParseUtil {
    private static final String PIPE = "\\|";
    private static final String ACC_TAG = "gi";
    private static final String PROT_TAG = "Protein Id";
    private static final String SF_TAG = "sf_name";
    private static final String ORG_TAG = "organism";
    private static final String DEF_TAG = "definition";
    private static final String GENE_TAG = "gene id";
    private static final String SYMB_TAG = "gene symbol";
    private static final String OMCL_TAG = "OrthoMCL";
    private static final String PERM_NODE_TAG = "public Id";
    private static final String MGI_DATABASE = "MGI";
    private Vector<String> origColumnHeadings;
    private Vector<String> currentColHeadings;
    private static PantherParseUtil singleton = null;
    private static Logger log = Logger.getLogger(PantherParseUtil.class);

    public static PantherParseUtil inst() {
        if (singleton == null) {
            singleton = new PantherParseUtil();
        }
        return singleton;
    }

    private String[] getParts(String row) {
        if (row.charAt(row.length() - 1) == ';') {
            row = row.substring(0, row.length() - 1);
        }
        String[] parts = row.split(PIPE);
        return parts;
    }

    private String parseANid(String name) {
        String[] parts = this.getParts(name);
        String paint_id = null;
        if (parts.length < 1) {
            paint_id = name;
        } else if (parts.length < 2) {
            paint_id = parts[0];
        }
        return paint_id;
    }

    private String[] getDBparts(String row) {
        String[] parts = this.getParts(row);
        if (parts.length >= 3) {
            String[] db_source;
            if (parts[2].contains("=ENSTRUG") || parts[1].contains("=ENSTRUP")) {
                db_source = parts[2].split("=");
                String[] seq_source = parts[1].split("=");
                log.debug((Object)("Gene " + db_source[1] + " and protein " + seq_source[1] + " appear reversed in " + row));
            } else {
                db_source = parts[1].split("=");
                if (db_source.length == 3) {
                    if (db_source[0].equals(MGI_DATABASE) || db_source[0].equals("TAIR") || db_source[0].equals("ECOLI")) {
                        db_source[1] = db_source[1] + ":" + db_source[2];
                    } else if (db_source[0].equals("Gene")) {
                        db_source[0] = db_source[1];
                        db_source[1] = db_source[2];
                    } else {
                        log.debug((Object)("Too many parts in " + parts[1]));
                    }
                }
            }
            return db_source;
        }
        return null;
    }

    public String[] getSeqParts(String row) {
        String[] parts = this.getParts(row);
        if (parts.length >= 3) {
            String[] seq_source = parts[2].contains("=ENSTRUG") || parts[1].contains("=ENSTRUP") ? parts[1].split("=") : parts[2].split("=");
            return seq_source;
        }
        return null;
    }

    public void parseIDstr(GeneNode node, String name) {
        String paint_id = this.parseANid(name);
        if (paint_id != null) {
            node.setPaintId(paint_id);
        } else {
            String[] parts = this.getParts(name);
            if (parts != null && parts.length > 0) {
                node.addSpeciesLabel(parts[0]);
                node.setSpecies(parts[0]);
            }
            String[] db_source = this.getDBparts(name);
            String[] seq_source = this.getSeqParts(name);
            if (db_source != null && db_source.length >= 2) {
                node.setDatabaseID(db_source[0], db_source[1]);
            } else {
                log.debug((Object)("Couldn't get db from " + name));
            }
            node.setSeqId(seq_source[0], seq_source[1]);
            node.setSeqName(node.getSpeciesLabel() + "_" + node.getSeqId());
        }
    }

    public void setOrigAttributeHeadings(Vector<String> headings) {
        PantherParseUtil.inst().setHeadings(headings);
    }

    private void setHeadings(Vector<String> headings) {
        this.origColumnHeadings = headings;
    }

    public Vector<String> getOrigAttributeHeadings() {
        return PantherParseUtil.inst().getHeadings();
    }

    private Vector<String> getHeadings() {
        return this.origColumnHeadings;
    }

    public Vector<String> getCurrentHeadings() {
        return PantherParseUtil.inst().currentColHeadings;
    }

    public void addGeneAttributes(GeneNode gene, Vector<String> row) {
        Vector<String> origColHeadings = PantherParseUtil.inst().origColumnHeadings;
        for (int i = 0; i < row.size(); ++i) {
            gene.setAttrLookup(origColHeadings.get(i), row.get(i));
        }
    }

    public Hashtable<String, String> getAttributes(GeneNode node) {
        Hashtable<String, String> gene_data = new Hashtable<String, String>(3);
        gene_data.put(ACC_TAG, node.getSeqId());
        gene_data.put(SF_TAG, "");
        gene_data.put(DEF_TAG, node.getDescription());
        return gene_data;
    }

    public int getColIndex(String colName) {
        if (null == this.currentColHeadings) {
            return -1;
        }
        for (int i = 0; i < this.currentColHeadings.size(); ++i) {
            if (!colName.equals(this.currentColHeadings.get(i))) continue;
            return i;
        }
        return -1;
    }

    private String cleanDefinition(String def) {
        String[] parts;
        String[] wierd;
        String better_def = def;
        if (!def.equals("") && (wierd = (parts = def.split(";"))[0].split("=")).length == 2) {
            better_def = wierd[1];
        }
        return better_def;
    }
}

