/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationHelper;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Organism;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.gui.AspectSelector;
import org.paint.main.PaintManager;

public class RenderUtil {
    private static final Logger LOG = Logger.getLogger(RenderUtil.class);
    private static final String STR_DOT_DOT = "...";
    private static final String STR_EMPTY = "";
    private static HashMap<String, Color> ortho_colors;

    public static void paintBorder(Graphics g, Rectangle r, Color bgColor, boolean selected) {
        if (bgColor != null) {
            g.setColor(bgColor);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        if (selected) {
            Preferences prefs = Preferences.inst();
            Color color = prefs.getForegroundColor();
            g.setColor(color);
            g.drawLine(r.x, r.y, r.x + r.width, r.y);
        } else {
            g.setColor(Color.lightGray);
        }
        int bottom_y = r.y + r.height - 1;
        g.drawLine(r.x, bottom_y, r.x + r.width, bottom_y);
    }

    public static String formatText(Graphics g, Insets insets, int boxWidth, String text, Font font) {
        int i;
        if (text == null) {
            return STR_EMPTY;
        }
        FontMetrics fm = g.getFontMetrics(font);
        int neededWidth = RenderUtil.getTextWidth(fm, text);
        if (boxWidth >= neededWidth) {
            return text;
        }
        String finalStr = STR_DOT_DOT;
        neededWidth = RenderUtil.getTextWidth(fm, finalStr);
        if (neededWidth > boxWidth) {
            return STR_EMPTY;
        }
        StringBuffer sb = new StringBuffer(finalStr);
        for (i = 0; neededWidth < boxWidth && i <= text.length() - 1; ++i) {
            sb.insert(i, text.charAt(i));
            try {
                neededWidth = RenderUtil.getTextWidth(fm, sb.toString());
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.error((Object)("ArrayIndexOutOfBoundsException " + e.getMessage() + " returned while attempting to calculate Text size."));
            }
        }
        if (neededWidth > boxWidth) {
            try {
                sb.setLength(i - 1);
                sb.append(finalStr);
            }
            catch (StringIndexOutOfBoundsException e) {
                LOG.error((Object)("StringIndexOutOfBoundsException " + e.getMessage() + " returned while attempting to delete character from string buffer."));
            }
        }
        return sb.toString();
    }

    public static int getTextWidth(FontMetrics fm, String s) {
        int width = 0;
        try {
            width = fm.stringWidth(s);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error((Object)("ArrayIndexOutOfBoundsException " + e.getMessage() + " returned while attempting to calculate Text size."));
        }
        return width;
    }

    public static int getWidth(FontMetrics fm, String text, Insets insets) {
        return RenderUtil.getTextWidth(fm, text + insets.left + insets.right);
    }

    public static Font getNodeFont(GeneNode node) {
        Font f = Preferences.inst().getFont();
        if (node.hasBiologicalProcessEvidence() && AspectSelector.inst().getAspect() == AspectSelector.Aspect.BIOLOGICAL_PROCESS || node.hasCellularComponentEvidence() && AspectSelector.inst().getAspect() == AspectSelector.Aspect.CELLULAR_COMPONENT || node.hasMolecularFunctionEvidence() && AspectSelector.inst().getAspect() == AspectSelector.Aspect.MOLECULAR_FUNCTION) {
            f = new Font(f.getFontName(), 1, f.getSize());
        }
        return f;
    }

    public static Color annotationStatusColor(GeneNode node, Color c) {
        Color color = new Color(c.getRGB());
        Preferences prefs = Preferences.inst();
        String go_aspect = AspectSelector.aspects.get(AspectSelector.inst().getAspect().toString());
        Node n = node.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi) {
            boolean foundExp = false;
            boolean foundNonExp = false;
            boolean foundCurated = false;
            PaintManager pm = PaintManager.inst();
            GOTermHelper gth = pm.goTermHelper();
            ArrayList annotList = nvi.getGoAnnotationList();
            Hashtable<Organism, HashSet<String>> nonDisplayOrgToEvdneceLookup = pm.getnonDisplayedAnnotMatrixOrgToEvdnceLookup();
            if (null != annotList) {
                for (Annotation annot : annotList) {
                    if (AnnotationHelper.ignoreAnnot((Annotation)annot, (Node)n, nonDisplayOrgToEvdneceLookup) || !go_aspect.equals(gth.getTerm(annot.getGoTerm()).getAspect())) continue;
                    if (annot.isExperimental()) {
                        foundExp = true;
                        break;
                    }
                    foundNonExp = true;
                    String code = annot.getSingleEvidenceCodeFromSet();
                    if (!"IBD".equals(code) && (!"IKR".equals(code) || node.isLeaf()) && !"IRD".equals(code) && !"TCV".equals(code)) continue;
                    foundCurated = true;
                }
            }
            if (foundNonExp) {
                color = prefs.getInferPaintColor();
            }
            if (foundExp) {
                color = prefs.getExpPaintColor();
            }
            if (foundCurated) {
                color = prefs.getCuratedPaintColor();
            }
        }
        color = RenderUtil.selectedColor(node.isSelected(), color, c);
        return color;
    }

    public static Color selectedColor(boolean selected, Color color, Color c) {
        if (selected) {
            color = color.equals(c) ? Color.gray : color.brighter().brighter();
        }
        return color;
    }

    public static Color getAspectColor() {
        return RenderUtil.getAspectColor(AspectSelector.inst().getAspect().toString());
    }

    public static Color getAspectColor(String cv) {
        if (cv != null) {
            if (cv.equals(AspectSelector.Aspect.BIOLOGICAL_PROCESS.toString())) {
                return Preferences.inst().getAspectColor(1);
            }
            if (cv.equals(AspectSelector.Aspect.CELLULAR_COMPONENT.toString())) {
                return Preferences.inst().getAspectColor(2);
            }
            if (cv.equals(AspectSelector.Aspect.MOLECULAR_FUNCTION.toString())) {
                return Preferences.inst().getAspectColor(4);
            }
        }
        return Preferences.inst().getBackgroundColor();
    }

    public static Color getLineColor(GeneNode node) {
        return node.getParent().getSubFamilyColor();
    }

    public static Color getOrthoColor(String ortho_name) {
        Color color;
        if (ortho_colors == null) {
            ortho_colors = new HashMap();
        }
        if ((color = ortho_colors.get(ortho_name)) == null) {
            int red_val = 0;
            int green_val = 0;
            int blue_val = 0;
            while (red_val + green_val + blue_val < 128) {
                red_val = (int)(Math.random() * 255.0);
                green_val = (int)(Math.random() * 255.0);
                blue_val = (int)(Math.random() * 255.0);
            }
            color = new Color(red_val, green_val, blue_val);
            ortho_colors.put(ortho_name, color);
        }
        return color;
    }
}

