/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import javax.swing.Icon;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.log4j.Logger;
import org.paint.util.SVGUtil;

public class SVGIcon
implements Icon {
    protected static final Logger logger = Logger.getLogger(SVGIcon.class);
    protected GraphicsNode node;
    protected String uri;
    protected int width = -1;
    protected int height = -1;
    protected double widthScaleFactor = 1.0;
    protected double heightScaleFactor = 1.0;

    public SVGIcon(String uri) throws IOException {
        this(uri, -1, -1);
    }

    public SVGIcon(String uri, int dimension) throws IOException {
        this.node = SVGUtil.getSVG(uri);
        this.uri = uri;
        int width = -1;
        int height = -1;
        Rectangle2D r = this.node.getBounds();
        if (r.getWidth() < r.getHeight()) {
            height = dimension;
        } else {
            width = dimension;
        }
        this.setDimension(width, height);
    }

    public SVGIcon(String uri, int width, int height) throws IOException {
        this.node = SVGUtil.getSVG(uri);
        this.uri = uri;
        this.setDimension(width, height);
    }

    protected void setDimension(int width, int height) {
        Rectangle2D r = this.node.getBounds();
        this.widthScaleFactor = 1.0;
        this.heightScaleFactor = 1.0;
        if (height > 0) {
            this.heightScaleFactor = (double)height / r.getHeight();
        }
        if (width > 0) {
            this.widthScaleFactor = (double)width / r.getWidth();
        }
        if (width == -1) {
            this.widthScaleFactor = this.heightScaleFactor;
        }
        if (height == -1) {
            this.heightScaleFactor = this.widthScaleFactor;
        }
        width = (int)(r.getWidth() * this.widthScaleFactor);
        height = (int)(r.getHeight() * this.heightScaleFactor);
        this.width = width;
        this.height = height;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.translate(x, y);
            g2.scale(this.widthScaleFactor, this.heightScaleFactor);
            this.node.paint(g2);
            g2.scale(1.0 / this.widthScaleFactor, 1.0 / this.heightScaleFactor);
            g2.translate(-x, -y);
        }
    }

    public String toString() {
        return this.uri;
    }
}

