/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.text.EditorKit;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.log4j.Logger;
import org.bbop.swing.HyperlinkLabel;
import org.bbop.swing.IconFactory;
import org.bbop.swing.PluggableImageHTMLEditorKit;
import org.paint.util.SVGIcon;
import org.w3c.dom.Document;

public class SVGUtil {
    protected static final Logger logger = Logger.getLogger(SVGUtil.class);

    public static GraphicsNode getSVG(String uri) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        Document doc = f.createDocument(uri);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode node = builder.build(new BridgeContext((UserAgent)new UserAgentAdapter(){}), doc);
        return node;
    }

    public static void editorPaneMain(String[] args) {
        JEditorPane pane = new JEditorPane();
        PluggableImageHTMLEditorKit kit = new PluggableImageHTMLEditorKit();
        kit.installFactory("svg", new IconFactory(){

            public Icon createIcon(URL url, int width, int height) {
                try {
                    return new SVGIcon(url.toString(), width, height);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
        pane.setEditorKit((EditorKit)kit);
        pane.setText("<html>Hey there: <img width='30' src='file:/Users/suzi/downloads/lion.svg'></html>");
        JFrame frame = new JFrame();
        frame.setContentPane(pane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        HyperlinkLabel label = new HyperlinkLabel();
        label.installIconFactory("svg", new IconFactory(){

            public Icon createIcon(URL url, int width, int height) {
                try {
                    return new SVGIcon(url.toString(), width, height);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
        label.setText("<html>Hey there: <a href='click'><img src='file:/Users/jrichter/downloads/lion.svg'></a></html>");
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)label);
        frame.pack();
        frame.setVisible(true);
    }
}

