/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import org.paint.gui.familytree.TreeModel;
import org.paint.util.DuplicationColor;

public class SpeciesClsColor {
    private static SpeciesClsColor inst = null;
    private static List<Color> colorList = null;
    private static Color DEFAULT_OTHER = Color.WHITE;
    private static HashMap<String, Color> orgLookup = null;

    private SpeciesClsColor() {
    }

    public static synchronized SpeciesClsColor getInst() {
        if (null == inst) {
            inst = new SpeciesClsColor();
            colorList = DuplicationColor.inst().getPastelColors();
            int counter = 0;
            orgLookup = new HashMap();
            for (String org : TreeModel.SPECIES_CLASSIFICATION) {
                Color c = colorList.get(counter);
                if (c.equals(DEFAULT_OTHER)) {
                    ++counter;
                }
                orgLookup.put(org.toUpperCase(), colorList.get(counter));
                ++counter;
            }
        }
        return inst;
    }

    public Color getColorForSpecies(String speciesCls) {
        if (null == speciesCls) {
            return DEFAULT_OTHER;
        }
        Color c = orgLookup.get(speciesCls.toUpperCase());
        if (null == c) {
            return DEFAULT_OTHER;
        }
        return c;
    }
}

