/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import com.sri.panther.paintCommon.Constant;
import com.sri.panther.paintCommon.util.Utils;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.paint.datamodel.GeneNode;
import org.paint.gui.familytree.TreePanel;

public class SubFamilyUtil {
    private static final String MSG_INVALID_SF_ID = "Invalid subfamily id encountered ";
    private static final String MSG_DUPLICATE_AN_ID_ENCOUNTERED_FOR_SUBFAMILY = " Duplicate anotation id encountered for subfamily ";
    private static final String MSG_DUPLICATE_SF_ID_ENCOUNTERED_FOR_ANNOTATION_ID = " Duplicate subfamily id encountered for annotation node ";
    private static final String MSG_SF_AN_INFO_IS_NULL = "Subfamily annotation node relationship information is null";
    private static final String MSG_SF_AN_INFO_INVALID = "Subfamily annotation node relationship information is invalid ";
    private static final Logger logger = Logger.getLogger((String)SubFamilyUtil.class.getName());

    public static String[] saveSFToAN(TreePanel tree) {
        GeneNode root = tree.getRoot();
        Vector<String> sfList = new Vector<String>();
        SubFamilyUtil.generateSFToAN(root, sfList);
        Object[] rtnArray = new String[sfList.size()];
        sfList.copyInto(rtnArray);
        return rtnArray;
    }

    private static void generateSFToAN(GeneNode node, Vector<String> sfList) {
        List<GeneNode> children;
        if (null == node) {
            return;
        }
        if (node.isSubfamily()) {
            StringBuffer sb = new StringBuffer();
            sb.append(node.getSubFamilyName());
            sb.append("\t");
            sb.append(node.getSeqId());
            sb.append("\n");
            sfList.add(sb.toString());
        }
        if (null == (children = node.getChildren())) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            GeneNode child = children.get(i);
            SubFamilyUtil.generateSFToAN(child, sfList);
        }
    }

    public static Hashtable<String, Vector<GeneNode>> getSubfamilyRelations(TreePanel tree) {
        Hashtable<String, Vector<GeneNode>> sfToLeafTbl = new Hashtable<String, Vector<GeneNode>>();
        List<GeneNode> nodes = tree.getAllNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            GeneNode sfAncestor;
            GeneNode node = nodes.get(i);
            if (!node.isLeaf() || null == (sfAncestor = SubFamilyUtil.getSubfamilyAncestor(node))) continue;
            String sfName = sfAncestor.getSubFamilyName();
            Vector<GeneNode> leaves = sfToLeafTbl.get(sfName);
            if (null == leaves) {
                leaves = new Vector();
                sfToLeafTbl.put(sfName, leaves);
            }
            leaves.add(node);
        }
        return sfToLeafTbl;
    }

    public static GeneNode getSubfamilyAncestor(GeneNode node) {
        if (null == node) {
            return null;
        }
        if (node.isSubfamily()) {
            return node;
        }
        return SubFamilyUtil.getSubfamilyAncestor(node.getParent());
    }

    public static Hashtable<String, String> parseSfAnInfo(String[] sfAnInfo, boolean checkSFName) {
        if (null == sfAnInfo) {
            logger.error((Object)MSG_SF_AN_INFO_IS_NULL);
            return null;
        }
        int length = sfAnInfo.length;
        Hashtable<String, String> AnSfTbl = new Hashtable<String, String>(length);
        Hashtable<String, String> sfTbl = new Hashtable<String, String>(length);
        for (int i = 0; i < length; ++i) {
            String info = sfAnInfo[i];
            String[] infoStr = Utils.tokenize((String)(info = info.trim()), (String)"\t");
            int infoLen = infoStr.length;
            if (infoLen >= 1 && infoLen >= 0) {
                if (!checkSFName) {
                    AnSfTbl.put(infoStr[1], infoStr[0]);
                    continue;
                }
                String sfName = infoStr[0];
                if (null == sfName || !sfName.startsWith("SF")) {
                    logger.error((Object)(MSG_INVALID_SF_ID + sfName));
                    return null;
                }
                String numberPart = sfName.substring(Constant.NODE_SUBFAMILY_PREFIX_LENGTH, sfName.length());
                try {
                    Integer.parseInt(numberPart);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    logger.error((Object)(MSG_INVALID_SF_ID + sfName));
                    return null;
                }
                String anId = infoStr[1];
                if (null == anId || !anId.startsWith("AN")) {
                    logger.error((Object)("Invalid annotation id encountered " + anId));
                    return null;
                }
                numberPart = anId.substring(Constant.NODE_ANNOTATION_PREFIX_LENGTH, anId.length());
                try {
                    Integer.parseInt(numberPart);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    logger.error((Object)("Invalid annotation id encountered " + anId));
                    return null;
                }
                String previousSfId = AnSfTbl.put(anId, sfName);
                if (null != previousSfId) {
                    logger.error((Object)(anId + MSG_DUPLICATE_AN_ID_ENCOUNTERED_FOR_SUBFAMILY + previousSfId));
                    return null;
                }
                if (null == sfTbl.put(sfName, sfName)) continue;
                logger.error((Object)(sfName + MSG_DUPLICATE_SF_ID_ENCOUNTERED_FOR_ANNOTATION_ID + anId));
                return null;
            }
            logger.error((Object)(MSG_SF_AN_INFO_INVALID + info));
            return null;
        }
        return AnSfTbl;
    }
}

