/*
 * Decompiled with CFR 0.152.
 */
package org.paint.util;

import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.paint.gui.PaintTable;

public class TableUtil {
    public static void setColumnWidths(PaintTable grid, int col_count, FontMetrics fm, TableColumnModel colModel) {
        Insets insets = new DefaultTableCellRenderer().getInsets();
        for (int i = 0; i < col_count; ++i) {
            int optimalColumnWidth = 0;
            if (grid.isSquare(i)) {
                optimalColumnWidth = fm.getHeight();
            } else {
                for (int j = 0; j < grid.getRowCount(); ++j) {
                    String value = grid.getTextAt(j, i);
                    if (null == value) {
                        value = "";
                    }
                    int optimalCellWidth = fm.stringWidth(value) + insets.left + insets.right + 2;
                    optimalColumnWidth = Math.max(optimalColumnWidth, optimalCellWidth);
                }
            }
            TableColumn col = colModel.getColumn(i);
            col.setPreferredWidth(optimalColumnWidth);
            col.setWidth(optimalColumnWidth);
        }
    }
}

