/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeVar;
import com.hp.hpl.jena.sparql.serializer.FmtExprARQ;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;
import com.hp.hpl.jena.sparql.util.Utils;
import org.apache.commons.logging.LogFactory;

public class SortCondition
extends PrintSerializableBase {
    public Expr expression = null;
    public int direction = 0;

    public SortCondition(Var var, int dir) {
        this(new NodeVar(var), dir);
    }

    public SortCondition(Node var, int dir) {
        this(ExprUtils.nodeToExpr(var), dir);
    }

    public SortCondition(Expr expr, int dir) {
        this.expression = expr;
        this.direction = dir;
        if (dir != Query.ORDER_ASCENDING && dir != Query.ORDER_DESCENDING && dir != Query.ORDER_DEFAULT) {
            LogFactory.getLog((Class)SortCondition.class).fatal((Object)"Unknown sort direction");
        }
    }

    public void format(ExprVisitor fmt, IndentedWriter writer) {
        boolean explicitDirection = false;
        boolean needParens = false;
        if (this.direction != Query.ORDER_DEFAULT && (this.expression.isVariable() || this.expression instanceof E_Function)) {
            needParens = true;
        }
        if (this.direction == Query.ORDER_ASCENDING) {
            writer.print("ASC");
        }
        if (this.direction == Query.ORDER_DESCENDING) {
            writer.print("DESC");
        }
        if (needParens) {
            writer.print("(");
        }
        this.expression.visit(fmt);
        if (needParens) {
            writer.print(")");
        }
    }

    public void formatPrefix(ExprVisitor fmt, IndentedWriter writer) {
        boolean close = true;
        if (this.direction != Query.ORDER_DEFAULT) {
            if (this.direction == Query.ORDER_ASCENDING) {
                writer.print("asc ");
            }
            if (this.direction == Query.ORDER_DESCENDING) {
                writer.print("desc ");
            }
        }
        this.expression.visit(fmt);
    }

    public int getDirection() {
        return this.direction;
    }

    public Expr getExpression() {
        return this.expression;
    }

    public int hashCode() {
        int x = this.getDirection();
        if (this.getExpression() != null) {
            x ^= this.getExpression().hashCode();
        }
        return x;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SortCondition)) {
            return false;
        }
        SortCondition sc = (SortCondition)other;
        if (sc.getDirection() != this.getDirection()) {
            return false;
        }
        return Utils.eq(this.getExpression(), sc.getExpression());
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        FmtExprARQ fmt = new FmtExprARQ(out, sCxt);
        this.format(fmt, out);
    }
}

