/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.larq.ARQLuceneException;
import com.hp.hpl.jena.query.larq.IndexBuilderModel;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;

public class IndexBuilderSubject
extends IndexBuilderModel {
    private static Log log = LogFactory.getLog((Class)IndexBuilderSubject.class);
    private Set seen = new HashSet();
    Property property;

    public IndexBuilderSubject() {
    }

    public IndexBuilderSubject(IndexWriter existingWriter) {
        super(existingWriter);
    }

    public IndexBuilderSubject(File fileDir) {
        super(fileDir);
    }

    public IndexBuilderSubject(String fileDir) {
        super(fileDir);
    }

    public IndexBuilderSubject(Property p) {
        this();
        this.property = p;
    }

    public IndexBuilderSubject(Property p, IndexWriter existingWriter) {
        super(existingWriter);
        this.property = p;
    }

    public IndexBuilderSubject(Property p, File fileDir) {
        this(fileDir);
        this.property = p;
    }

    public IndexBuilderSubject(Property p, String fileDir) {
        this(fileDir);
        this.property = p;
    }

    public void unindexStatement(Statement s) {
        throw new ARQNotImplemented("unindexStatement");
    }

    public void indexStatement(Statement s) {
        if (!this.indexThisStatement(s)) {
            return;
        }
        try {
            Node subject = s.getSubject().asNode();
            if (!s.getObject().isLiteral() || !LARQ.isString(s.getLiteral())) {
                return;
            }
            Node object = s.getObject().asNode();
            Document doc = new Document();
            LARQ.index(doc, object);
            LARQ.store(doc, subject);
            this.getIndexWriter().addDocument(doc);
        }
        catch (Exception e2) {
            throw new ARQLuceneException("indexStatement", e2);
        }
    }

    protected boolean indexThisStatement(Statement s) {
        if (this.property == null) {
            return true;
        }
        return s.getPredicate().equals(this.property);
    }

    public void closeForWriting() {
        super.closeForWriting();
        this.seen = null;
    }
}

