/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;

public class ARQConstants {
    public static final String fnPrefix = "http://www.w3.org/2005/xpath-functions#";
    public static final String rdfPrefix = RDF.getURI();
    public static final String rdfsPrefix = RDFS.getURI();
    public static final String owlPrefix = OWL.getURI();
    public static final String xsdPrefix = "http://www.w3.org/2001/XMLSchema#";
    public static final String srxPrefix = "http://www.w3.org/2005/sparql-results#";
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema#";
    public static final String javaClassURIScheme = "java:";
    public static final String ARQFunctionLibraryURI = "http://jena.hpl.hp.com/ARQ/function#";
    public static final String ARQPropertyFunctionLibraryURI = "http://jena.hpl.hp.com/ARQ/property#";
    public static final String ARQFunctionLibrary = "java:com.hp.hpl.jena.sparql.function.library.";
    public static final String ARQPropertyFunctionLibrary = "java:com.hp.hpl.jena.sparql.pfunction.library.";
    protected static PrefixMapping globalPrefixMap = new PrefixMappingImpl();
    public static final String anonVarMarker = "%";
    public static final String allocVarMarker = "@";
    public static final String systemVarNS = "http://jena.hpl.hp.com/ARQ/system#";
    public static final Symbol sysCurrentTime;
    public static final Symbol sysVersionARQ;
    public static final Symbol sysVersionJena;
    public static final Symbol autoDistinct;
    public static final Symbol registryPropertyFunctions;
    public static final Symbol registryDescribeHandlers;
    public static final Symbol registryFunctions;
    public static final Symbol registryExtensions;

    public static PrefixMapping getGlobalPrefixMap() {
        return globalPrefixMap;
    }

    public static Symbol allocSymbol(String shortName) {
        if (shortName.startsWith("http://jena.hpl.hp.com/ARQ#")) {
            throw new ARQInternalErrorException("Symbol short name begins with the ARQ namespace name: " + shortName);
        }
        return Symbol.create("http://jena.hpl.hp.com/ARQ#" + shortName);
    }

    static {
        globalPrefixMap.setNsPrefixes(PrefixMapping.Standard);
        globalPrefixMap.setNsPrefix("rdf", rdfPrefix);
        globalPrefixMap.setNsPrefix("rdfs", rdfsPrefix);
        globalPrefixMap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixMap.setNsPrefix("owl", owlPrefix);
        globalPrefixMap.setNsPrefix("fn", fnPrefix);
        globalPrefixMap.setNsPrefix("afn", ARQFunctionLibraryURI);
        globalPrefixMap.setNsPrefix("apf", ARQPropertyFunctionLibraryURI);
        sysCurrentTime = Symbol.create("http://jena.hpl.hp.com/ARQ/system#now");
        sysVersionARQ = Symbol.create("http://jena.hpl.hp.com/ARQ/system#version/ARQ");
        sysVersionJena = Symbol.create("http://jena.hpl.hp.com/ARQ/system#version/Jena");
        autoDistinct = ARQConstants.allocSymbol("autoDistinct");
        registryPropertyFunctions = ARQConstants.allocSymbol("registryPropertyFunctions");
        registryDescribeHandlers = ARQConstants.allocSymbol("registryDescribeHandlers");
        registryFunctions = ARQConstants.allocSymbol("registryFunctions");
        registryExtensions = ARQConstants.allocSymbol("registryExtensions");
    }
}

