/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.engine.ref.Evaluator;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;

public class OpFilter
extends Op1 {
    ExprList expressions;

    public static OpFilter filter(Expr expr, Op op) {
        if (op instanceof OpFilter) {
            OpFilter f = (OpFilter)op;
            f.getExprs().add(expr);
            return f;
        }
        ExprList x = new ExprList(expr);
        return new OpFilter(x, op);
    }

    public static OpFilter filter(ExprList exprs, Op op) {
        if (op instanceof OpFilter) {
            OpFilter f = (OpFilter)op;
            f.getExprs().addAll(exprs);
            return f;
        }
        return new OpFilter(exprs, op);
    }

    private OpFilter(ExprList exprs, Op sub) {
        super(sub);
        this.expressions = exprs;
    }

    public Table eval_1(Table table, Evaluator evaluator) {
        return evaluator.filter(this.expressions, table);
    }

    public static OpFilter tidy(OpFilter base) {
        ExprList exprs = new ExprList();
        Op op = base;
        while (op instanceof OpFilter) {
            OpFilter f = op;
            exprs.addAll(f.getExprs());
            op = f.getSubOp();
        }
        return OpFilter.filter(exprs, op);
    }

    public ExprList getExprs() {
        return this.expressions;
    }

    public String getName() {
        return "filter";
    }

    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy(Op subOp) {
        return new OpFilter(this.expressions, subOp);
    }
}

