/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.table.TableUnit;
import com.hp.hpl.jena.sparql.engine.ref.Evaluator;

public class OpJoin
extends Op2 {
    public static Op create(Op left, Op right) {
        if (left == null) {
            return right;
        }
        if (OpJoin.isJoinIdentify(left)) {
            return right;
        }
        if (OpJoin.isJoinIdentify(right)) {
            return left;
        }
        return new OpJoin(left, right);
    }

    private static boolean isJoinIdentify(Op op) {
        if (!(op instanceof OpTable)) {
            return false;
        }
        Table t = ((OpTable)op).getTable();
        return t instanceof TableUnit;
    }

    private OpJoin(Op left, Op right) {
        super(left, right);
    }

    public Table eval_2(Table tableLeft, Table tableRight, Evaluator evaluator) {
        return evaluator.join(tableLeft, tableRight);
    }

    public String getName() {
        return "join";
    }

    public Op apply(Transform transform, Op left, Op right) {
        return transform.transform(this, left, right);
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy(Op newLeft, Op newRight) {
        return new OpJoin(newLeft, newRight);
    }
}

