/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op0;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class OpQuadPattern
extends Op0 {
    Node graphNode;
    BasicPattern triples;
    List quads = null;

    public OpQuadPattern(Node quadNode, BasicPattern triples) {
        this.graphNode = quadNode;
        this.triples = triples;
    }

    public List getQuads() {
        if (this.quads == null) {
            this.quads = new ArrayList();
            ListIterator iter = this.triples.iterator();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                this.quads.add(new Quad(this.graphNode, t));
            }
        }
        return this.quads;
    }

    public Node getGraphNode() {
        return this.graphNode;
    }

    public BasicPattern getBasicPattern() {
        return this.triples;
    }

    public String getName() {
        return "quadpattern";
    }

    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy() {
        return new OpQuadPattern(this.graphNode, this.triples);
    }
}

