/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.table;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.util.Iterator;

public class TableWriter {
    public static String asSSE(Table table) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        IndentedWriter out = buff.getIndentedWriter();
        TableWriter.output(table, out);
        return buff.asString();
    }

    public static void output(Table table, IndentedWriter out) {
        TableWriter.output(table, out, null);
    }

    public static void output(Table table, IndentedWriter out, SerializationContext sCxt) {
        if (sCxt != null) {
            // empty if block
        }
        out.print("(table");
        out.incIndent();
        QueryIterator qIter = table.iterator(null);
        while (qIter.hasNext()) {
            out.println();
            Binding binding = qIter.nextBinding();
            TableWriter.output(binding, out, sCxt);
        }
        out.decIndent();
        out.print(")");
    }

    private static void output(Binding binding, IndentedWriter out, SerializationContext sCxt) {
        out.print("(row");
        Iterator iter = binding.vars();
        while (iter.hasNext()) {
            Var v = (Var)((Object)iter.next());
            Node n = binding.get(v);
            out.print(" ");
            out.print("[");
            out.print(FmtUtils.stringForNode((Node)v));
            out.print(" ");
            out.print(FmtUtils.stringForNode(n));
            out.print("]");
        }
        out.print(")");
    }
}

