/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrefixMapping2;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import com.hp.hpl.jena.sparql.util.Printable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Prologue
implements Printable {
    private static Log log = LogFactory.getLog((Class)Prologue.class);
    protected boolean seenBaseURI = false;
    protected String baseURI = null;
    protected PrefixMapping prefixMap = new PrefixMappingImpl();
    protected IRIResolver resolver = new IRIResolver();

    public Prologue() {
    }

    public Prologue(PrefixMapping pmap) {
        this.prefixMap = pmap;
    }

    public Prologue(PrefixMapping pmap, String base) {
        this.prefixMap = pmap;
        this.setBaseURI(base);
    }

    public boolean explicitlySetBaseURI() {
        return this.seenBaseURI;
    }

    public String getBaseURI() {
        if (this.baseURI == null) {
            this.setDefaultBaseIRI();
        }
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
        this.seenBaseURI = true;
        this.resolver = new IRIResolver(baseURI);
    }

    protected void setDefaultBaseIRI() {
        this.setDefaultBaseIRI(null);
    }

    protected void setDefaultBaseIRI(String base) {
        if (this.baseURI != null) {
            return;
        }
        this.baseURI = IRIResolver.chooseBaseURI((String)base);
    }

    public void setPrefix(String prefix, String expansion) {
        try {
            this.prefixMap.setNsPrefix(prefix, expansion);
        }
        catch (PrefixMapping.IllegalPrefixException ex) {
            log.warn((Object)("Illegal prefix mapping(ignored): " + prefix + "=>" + expansion));
        }
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMap;
    }

    public void setPrefixMapping(PrefixMapping pmap) {
        this.prefixMap = pmap;
    }

    public String getPrefix(String prefix) {
        return this.prefixMap.getNsPrefixURI(prefix);
    }

    public IRIResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(IRIResolver resolver) {
        this.resolver = resolver;
    }

    public String expandQName(String qname) {
        return this.expandPrefixedName(qname);
    }

    public String expandPrefixedName(String qname) {
        String s = this.prefixMap.expandPrefix(qname);
        if (s.equals(qname)) {
            return null;
        }
        return s;
    }

    public String shortForm(String uri) {
        return this.prefixMap.shortForm(uri);
    }

    public String toString() {
        return PrintUtils.toString(this);
    }

    public String toString(PrefixMapping pmap) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        IndentedWriter out = buff.getIndentedWriter();
        this.output(out);
        return buff.toString();
    }

    public void output(IndentedWriter out) {
        this.printBase(out);
        this.printPrefixes(out);
    }

    private void printBase(IndentedWriter out) {
        if (this.getBaseURI() != null && this.explicitlySetBaseURI()) {
            out.print("BASE    ");
            out.print("<" + this.getBaseURI() + ">");
            out.newline();
        }
    }

    public void printPrefixes(IndentedWriter out) {
        Map pmap = null;
        if (this.getPrefixMapping() instanceof PrefixMapping2) {
            PrefixMapping2 pm2 = (PrefixMapping2)this.getPrefixMapping();
            pmap = pm2.getNsPrefixMap(false);
        } else {
            pmap = this.getPrefixMapping().getNsPrefixMap();
        }
        if (pmap.size() > 0) {
            Iterator iter = pmap.keySet().iterator();
            while (iter.hasNext()) {
                String k = (String)iter.next();
                String v = (String)pmap.get(k);
                out.print("PREFIX  ");
                out.print(k);
                out.print(':');
                out.print(' ', -k.length());
                out.print(" <" + v + ">");
                out.newline();
            }
        }
    }
}

