/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;

public class Quad {
    public static Node defaultGraph = Node.createURI((String)"http://localhost/defaultgraph");
    private final Node graph;
    private final Node subject;
    private final Node predicate;
    private final Node object;

    public Quad(Node graph, Triple triple) {
        this(graph, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public Quad(Node g, Node s, Node p, Node o) {
        if (g == null) {
            throw new UnsupportedOperationException("Quad: graph cannot be null");
        }
        if (s == null) {
            throw new UnsupportedOperationException("Quad: subject cannot be null");
        }
        if (p == null) {
            throw new UnsupportedOperationException("Quad: predicate cannot be null");
        }
        if (o == null) {
            throw new UnsupportedOperationException("Quad: object cannot be null");
        }
        this.graph = g;
        this.subject = s;
        this.predicate = p;
        this.object = o;
    }

    public Node getGraph() {
        return this.graph;
    }

    public Node getSubject() {
        return this.subject;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public Node getObject() {
        return this.object;
    }

    public Triple getTriple() {
        return new Triple(this.subject, this.predicate, this.object);
    }

    public int hashCode() {
        return this.graph.hashCode() >> 2 ^ this.subject.hashCode() >> 1 ^ this.predicate.hashCode() ^ this.object.hashCode() << 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Quad)) {
            return false;
        }
        Quad quad = (Quad)other;
        if (!this.graph.equals((Object)quad.graph)) {
            return false;
        }
        if (!this.subject.equals((Object)quad.subject)) {
            return false;
        }
        if (!this.predicate.equals((Object)quad.predicate)) {
            return false;
        }
        return this.object.equals((Object)quad.object);
    }

    public String toString() {
        return "[" + this.graph.toString() + " " + this.subject.toString() + " " + this.predicate.toString() + " " + this.object.toString() + "]";
    }
}

