/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.describe.DescribeHandler;
import com.hp.hpl.jena.sparql.core.describe.DescribeHandlerRegistry;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.DatasetUtils;
import com.hp.hpl.jena.sparql.util.GraphUtils;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.util.FileManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryExecutionBase
implements QueryExecution {
    private static Log log = LogFactory.getLog((Class)QueryExecutionBase.class);
    private Query query;
    private Dataset dataset;
    private QueryEngineFactory qeFactory;
    private QueryIterator queryIterator = null;
    private Plan plan = null;
    private Op queryOp = null;
    private Context context;
    private FileManager fileManager = FileManager.get();
    private QuerySolution initialBinding = null;

    public QueryExecutionBase(Query query, Dataset dataset, Context context, QueryEngineFactory qeFactory) {
        this.query = query;
        this.dataset = dataset;
        this.context = context;
        this.qeFactory = qeFactory;
    }

    public void abort() {
        if (this.queryIterator != null) {
            this.queryIterator.abort();
        }
    }

    public void close() {
        if (this.queryIterator != null) {
            this.queryIterator.close();
        }
    }

    public ResultSet execSelect() {
        if (!this.query.isSelectType()) {
            throw new QueryExecException("Attempt to have ResultSet from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        return this.execInternal();
    }

    public Model execConstruct() {
        return this.execConstruct(GraphUtils.makeJenaDefaultModel());
    }

    public Model execConstruct(Model model) {
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        ResultSet qRes = this.execInternal();
        this.insertPrefixesInto(model);
        HashSet set = new HashSet();
        Template template = this.query.getConstructTemplate();
        while (qRes.hasNext()) {
            HashMap bNodeMap = new HashMap();
            QuerySolution qs = qRes.nextSolution();
            ResultBinding rb = (ResultBinding)qs;
            template.subst(set, bNodeMap, rb.getBinding());
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            Statement stmt = ModelUtils.tripleToStatement(model, t);
            if (stmt == null) continue;
            model.add(stmt);
        }
        this.close();
        return model;
    }

    public Model execDescribe() {
        return this.execDescribe(GraphUtils.makeJenaDefaultModel());
    }

    public Model execDescribe(Model model) {
        DescribeHandler dh;
        Iterator iter;
        if (!this.query.isDescribeType()) {
            throw new QueryExecException("Attempt to get a DESCRIBE result from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        HashSet<RDFNode> set = new HashSet<RDFNode>();
        ResultSet qRes = this.execInternal();
        this.insertPrefixesInto(model);
        if (qRes != null) {
            while (qRes.hasNext()) {
                QuerySolution rb = qRes.nextSolution();
                iter = this.query.getResultVars().iterator();
                while (iter.hasNext()) {
                    String varName = (String)iter.next();
                    RDFNode n = rb.get(varName);
                    set.add(n);
                }
            }
        }
        if (this.query.getResultURIs() != null) {
            Iterator iter2 = this.query.getResultURIs().iterator();
            while (iter2.hasNext()) {
                Node n = (Node)iter2.next();
                RDFNode rNode = ModelUtils.convertGraphNodeToRDFNode(n, this.dataset.getDefaultModel());
                set.add(rNode);
            }
        }
        List dhList = DescribeHandlerRegistry.get().newHandlerList();
        Iterator handlers = dhList.iterator();
        while (handlers.hasNext()) {
            dh = (DescribeHandler)handlers.next();
            dh.start(model, this.getContext());
        }
        iter = set.iterator();
        while (iter.hasNext()) {
            RDFNode n = (RDFNode)iter.next();
            if (!(n instanceof Resource)) continue;
            Iterator handlers2 = dhList.iterator();
            while (handlers2.hasNext()) {
                DescribeHandler dh2 = (DescribeHandler)handlers2.next();
                dh2.describe((Resource)n);
            }
        }
        handlers = dhList.iterator();
        while (handlers.hasNext()) {
            dh = (DescribeHandler)handlers.next();
            dh.finish();
        }
        this.close();
        return model;
    }

    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new QueryExecException("Attempt to have boolean from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        ResultSet results = this.execInternal();
        boolean r = results.hasNext();
        this.close();
        return r;
    }

    protected void execInit() {
    }

    private ResultSet execInternal() {
        this.execInit();
        if (this.query.getQueryPattern() == null) {
            return null;
        }
        Model model = null;
        model = this.dataset != null ? this.dataset.getDefaultModel() : ModelFactory.createDefaultModel();
        this.queryIterator = this.getPlan().iterator();
        ResultSetStream rStream = new ResultSetStream(this.query.getResultVars(), model, this.queryIterator);
        if (this.query.hasOrderBy()) {
            rStream.setOrdered(true);
        }
        if (this.query.isDistinct()) {
            rStream.setDistinct(true);
        }
        return rStream;
    }

    public Plan getPlan() {
        if (this.plan == null) {
            DatasetGraph dsg = QueryExecutionBase.prepareDataset(this.dataset, this.query, this.fileManager);
            Binding inputBinding = null;
            if (this.initialBinding != null) {
                inputBinding = new BindingMap();
                BindingUtils.addToBinding(inputBinding, this.initialBinding);
            }
            if (inputBinding == null) {
                inputBinding = BindingRoot.create();
            }
            this.plan = this.qeFactory.create(this.query, dsg, inputBinding, this.getContext());
        }
        return this.plan;
    }

    private void insertPrefixesInto(Model model) {
        try {
            Model m = this.dataset.getDefaultModel();
            model.setNsPrefixes((PrefixMapping)m);
            model.setNsPrefixes(this.query.getPrefixMapping());
        }
        catch (Exception ex) {
            log.warn((Object)("Exception in insertPrefixes: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private static String labelForQuery(Query q) {
        if (q.isSelectType()) {
            return "SELECT";
        }
        if (q.isConstructType()) {
            return "CONSTRUCT";
        }
        if (q.isDescribeType()) {
            return "DESCRIBE";
        }
        if (q.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }

    public Context getContext() {
        return this.context;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    private static DatasetGraph prepareDataset(Dataset dataset, Query query, FileManager fileManager) {
        if (dataset != null) {
            return dataset.asDatasetGraph();
        }
        if (!query.hasDatasetDescription()) {
            throw new QueryExecException("No dataset description for query");
        }
        String baseURI = query.getBaseURI();
        if (baseURI == null) {
            baseURI = IRIResolver.chooseBaseURI();
        }
        log.debug((Object)("init: baseURI for query is: " + baseURI));
        DatasetGraph dsg = DatasetUtils.createDatasetGraph(query.getGraphURIs(), query.getNamedGraphURIs(), fileManager, baseURI);
        return dsg;
    }

    public void setFileManager(FileManager fm) {
        this.fileManager = fm;
    }

    public void setInitialBinding(QuerySolution startSolution) {
        this.initialBinding = startSolution;
    }

    protected QuerySolution getInputBindings() {
        return this.initialBinding;
    }
}

