/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.engine.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingKey;
import java.util.Map;

public abstract class AggregatorBase
implements Aggregator {
    private Map buckets;
    private Var var;

    public AggregatorBase(Var var) {
        this.var = var;
    }

    public final void accumulate(BindingKey key, Binding binding) {
        Accumulator acc = (Accumulator)this.buckets.get(key);
        if (acc == null) {
            acc = this.createAccumulator();
            this.buckets.put(key, acc);
        }
        acc.accumulate(binding);
    }

    protected abstract Accumulator createAccumulator();

    public Node getValue(BindingKey key) {
        Accumulator acc = (Accumulator)this.buckets.get(key);
        if (acc == null) {
            throw new ARQInternalErrorException("Null for accumuator");
        }
        return acc.getValue().asNode();
    }

    public Var getVariable() {
        return this.var;
    }
}

