/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter1;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterSlice
extends QueryIter1 {
    static Log clsLog = LogFactory.getLog((Class)QueryIterSlice.class);
    long count = 0L;
    long limit;
    long offset;

    public QueryIterSlice(QueryIterator cIter, long startPosition, long numItems, ExecutionContext context) {
        super(cIter, context);
        this.offset = startPosition;
        if (this.offset == Query.NOLIMIT) {
            this.offset = 0L;
        }
        this.limit = numItems;
        if (this.limit == Query.NOLIMIT) {
            this.limit = Long.MAX_VALUE;
        }
        if (this.limit < 0L) {
            throw new QueryExecException("Negative LIMIT: " + this.limit);
        }
        if (this.offset < 0L) {
            throw new QueryExecException("Negative OFFSET: " + this.offset);
        }
        this.count = 0L;
        int i = 0;
        while ((long)i < this.offset) {
            if (!cIter.hasNext()) {
                this.close();
                break;
            }
            cIter.next();
            ++i;
        }
    }

    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        if (!this.getInput().hasNext()) {
            return false;
        }
        return this.count < this.limit;
    }

    protected Binding moveToNextBinding() {
        ++this.count;
        return this.getInput().nextBinding();
    }

    protected void releaseResources() {
    }
}

