/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.main.OpCompiler;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CompilerDispatch
implements OpVisitor {
    private static Log log = LogFactory.getLog((Class)CompilerDispatch.class);
    private Stack stack = new Stack();
    private OpCompiler opCompiler;

    CompilerDispatch(OpCompiler compiler) {
        this.opCompiler = compiler;
    }

    QueryIterator compile(Op op, QueryIterator input) {
        this.push(input);
        int x = this.stack.size();
        op.visit(this);
        int y = this.stack.size();
        if (x != y) {
            log.warn((Object)"Possible stack misalignment");
        }
        QueryIterator qIter = this.pop();
        return qIter;
    }

    public void visit(OpBGP opBGP) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opBGP, input);
        this.push(qIter);
    }

    public void visit(OpQuadPattern quadPattern) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(quadPattern, input);
        this.push(qIter);
    }

    public void visit(OpJoin opJoin) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opJoin, input);
        this.push(qIter);
    }

    public void visit(OpLeftJoin opLeftJoin) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opLeftJoin, input);
        this.push(qIter);
    }

    public void visit(OpDiff opDiff) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opDiff, input);
        this.push(qIter);
    }

    public void visit(OpUnion opUnion) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opUnion, input);
        this.push(qIter);
    }

    public void visit(OpFilter opFilter) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opFilter, input);
        this.push(qIter);
    }

    public void visit(OpGraph opGraph) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opGraph, input);
        this.push(qIter);
    }

    public void visit(OpDatasetNames dsNames) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(dsNames, input);
        this.push(qIter);
    }

    public void visit(OpTable opTable) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opTable, input);
        this.push(qIter);
    }

    public void visit(OpExt opExt) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opExt, input);
        this.push(qIter);
    }

    public void visit(OpNull opNull) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opNull, input);
        this.push(qIter);
    }

    public void visit(OpList opList) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opList, input);
        this.push(qIter);
    }

    public void visit(OpOrder opOrder) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opOrder, input);
        this.push(qIter);
    }

    public void visit(OpProject opProject) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opProject, input);
        this.push(qIter);
    }

    public void visit(OpDistinct opDistinct) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opDistinct, input);
        this.push(qIter);
    }

    public void visit(OpReduced opReduced) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opReduced, input);
        this.push(qIter);
    }

    public void visit(OpSlice opSlice) {
        QueryIterator input = this.pop();
        QueryIterator qIter = this.opCompiler.compile(opSlice, input);
        this.push(qIter);
    }

    public void visit(OpGroupAgg opGroupAgg) {
        throw new ARQNotImplemented("Compile OpGroupAgg");
    }

    private void push(QueryIterator qIter) {
        this.stack.push(qIter);
    }

    private QueryIterator pop() {
        if (this.stack.size() == 0) {
            log.warn((Object)"Warning: pop: empty stack");
        }
        return (QueryIterator)this.stack.pop();
    }
}

