/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.main.Stage;
import com.hp.hpl.jena.sparql.engine.main.StageBasic;
import com.hp.hpl.jena.sparql.engine.main.StageGenerator;
import com.hp.hpl.jena.sparql.engine.main.StageList;
import com.hp.hpl.jena.sparql.engine.main.StagePropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.GNode;
import com.hp.hpl.jena.sparql.util.GraphList;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class StageGenPropertyFunction
implements StageGenerator {
    private StageGenerator other;

    public StageGenPropertyFunction(StageGenerator other) {
        this.other = other;
    }

    public StageList compile(BasicPattern pattern, ExecutionContext execCxt) {
        if (pattern.isEmpty()) {
            return new StageList();
        }
        return StageGenPropertyFunction.process(execCxt.getContext(), pattern);
    }

    private static StageList process(Context context, BasicPattern pattern) {
        boolean doingMagicProperties = context.isTrue(ARQ.enablePropertyFunctions);
        PropertyFunctionRegistry registry = StageGenPropertyFunction.chooseRegistry(context);
        StageList stages = new StageList();
        ArrayList propertyFunctionTriples = new ArrayList();
        BasicPattern triples = new BasicPattern();
        StageGenPropertyFunction.findPropetryFunctions(context, pattern, doingMagicProperties, registry, triples, propertyFunctionTriples);
        HashMap pfStages = new HashMap();
        StageGenPropertyFunction.makePropetryFunctions(context, registry, pfStages, triples, propertyFunctionTriples);
        StageGenPropertyFunction.makeStages(context, stages, pfStages, triples, propertyFunctionTriples);
        return stages;
    }

    private static void findPropetryFunctions(Context context, BasicPattern pattern, boolean doingMagicProperties, PropertyFunctionRegistry registry, BasicPattern triples, List propertyFunctionTriples) {
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Triple)) {
                LogFactory.getLog((Class)StageGenPropertyFunction.class).warn((Object)("Don't recognize: [" + Utils.className(obj) + "]"));
                throw new ARQInternalErrorException("Not a triple pattern: " + obj.toString());
            }
            Triple t = (Triple)obj;
            triples.add(t);
            if (!doingMagicProperties || !StageGenPropertyFunction.isMagicProperty(registry, t)) continue;
            propertyFunctionTriples.add(t);
        }
    }

    private static void makePropetryFunctions(Context context, PropertyFunctionRegistry registry, Map pfStages, BasicPattern triples, List propertyFunctionTriples) {
        Iterator iter = propertyFunctionTriples.iterator();
        while (iter.hasNext()) {
            Triple pf = (Triple)iter.next();
            Stage stage = StageGenPropertyFunction.magicProperty(context, registry, pf, triples);
            if (stage == null) {
                LogFactory.getLog((Class)(class$com$hp$hpl$jena$sparql$engine$main$StageGenPropertyFunction == null ? StageGenPropertyFunction.class$("com.hp.hpl.jena.sparql.engine.main.StageGenPropertyFunction") : class$com$hp$hpl$jena$sparql$engine$main$StageGenPropertyFunction)).warn((Object)"Lost a Stage for a property function");
                continue;
            }
            pfStages.put(pf, stage);
        }
    }

    private static void makeStages(Context context, StageList stages, Map pfStages, BasicPattern triples, List propertyFunctionTriples) {
        BasicPattern pattern = null;
        ListIterator iter = triples.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            if (propertyFunctionTriples.contains(t)) {
                Stage stage = (Stage)pfStages.get(t);
                stages.add(stage);
                pattern = null;
                continue;
            }
            if (pattern == null) {
                pattern = new BasicPattern();
                StageBasic basicStage = new StageBasic(pattern);
                stages.add(basicStage);
            }
            pattern.add(t);
        }
    }

    private static PropertyFunctionRegistry chooseRegistry(Context context) {
        PropertyFunctionRegistry registry = PropertyFunctionRegistry.get(context);
        if (registry == null) {
            registry = PropertyFunctionRegistry.get();
        }
        return registry;
    }

    private static boolean isMagicProperty(PropertyFunctionRegistry registry, Triple pfTriple) {
        if (!pfTriple.getPredicate().isURI()) {
            return false;
        }
        return registry.manages(pfTriple.getPredicate().getURI());
    }

    private static Stage magicProperty(Context context, PropertyFunctionRegistry registry, Triple pfTriple, BasicPattern triples) {
        if (!StageGenPropertyFunction.isMagicProperty(registry, pfTriple)) {
            throw new ARQInternalErrorException("Not a property function: " + pfTriple.getMatchPredicate());
        }
        ArrayList listTriples = new ArrayList();
        GNode sGNode = new GNode(triples, pfTriple.getSubject());
        GNode oGNode = new GNode(triples, pfTriple.getObject());
        List sList = null;
        List oList = null;
        if (GraphList.isListNode(sGNode)) {
            sList = GraphList.members(sGNode);
            GraphList.allTriples(sGNode, listTriples);
        }
        if (GraphList.isListNode(oGNode)) {
            oList = GraphList.members(oGNode);
            GraphList.allTriples(oGNode, listTriples);
        }
        PropFuncArg subjArgs = new PropFuncArg(sList, pfTriple.getSubject());
        PropFuncArg objArgs = new PropFuncArg(oList, pfTriple.getObject());
        StagePropertyFunction propFuncStage = StagePropertyFunction.make(context, subjArgs, pfTriple.getPredicate(), objArgs);
        if (propFuncStage != null) {
            triples.getList().removeAll(listTriples);
        }
        return propFuncStage;
    }
}

