/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.Functions;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class E_LogicalOr
extends ExprFunction2 {
    private static final String printName = "or";
    private static final String symbol = "||";

    public E_LogicalOr(Expr left, Expr right) {
        super(left, right, printName, symbol);
    }

    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        ExprEvalException error = null;
        try {
            NodeValue x = this.getArg1().eval(binding, env);
            if (Functions.booleanEffectiveValue(x)) {
                return NodeValue.TRUE;
            }
        }
        catch (ExprEvalException eee) {
            error = eee;
        }
        try {
            NodeValue y = this.getArg2().eval(binding, env);
            if (Functions.booleanEffectiveValue(y)) {
                return NodeValue.TRUE;
            }
            if (error != null) {
                throw error;
            }
            return NodeValue.FALSE;
        }
        catch (ExprEvalException eee) {
            if (error != null) {
                throw error;
            }
            throw eee;
        }
    }

    public NodeValue eval(NodeValue x, NodeValue y) {
        throw new ARQInternalErrorException("Can't do that to " + this.getClass());
    }

    public Expr copy(Expr e1, Expr e2) {
        return new E_LogicalOr(e1, e2);
    }
}

