/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprNode;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.VariableNotBoundException;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import org.apache.commons.logging.LogFactory;

public class NodeVar
extends ExprNode {
    Var varNode = null;

    public NodeVar(String name) {
        this.varNode = Var.alloc(name);
    }

    public NodeVar(Node n) {
        if (!n.isVariable()) {
            throw new ARQInternalErrorException("Attempt to create a NodeVar from a non variable Node: " + n);
        }
        this.varNode = Var.alloc(n);
    }

    public NodeVar(Var n) {
        this.varNode = n;
    }

    public NodeValue eval(Binding binding, FunctionEnv env) {
        if (binding == null) {
            throw new VariableNotBoundException("Not bound: (no binding): " + (Object)((Object)this.varNode));
        }
        Node v = binding.get(this.varNode);
        if (v == null) {
            throw new VariableNotBoundException("Not bound: variable " + (Object)((Object)this.varNode));
        }
        return NodeValue.makeNode(v);
    }

    public Expr copySubstitute(Binding binding, boolean foldConstants) {
        if (binding == null || !binding.contains(this.varNode)) {
            return new NodeVar(this.varNode.getVarName());
        }
        try {
            return this.eval(binding, null);
        }
        catch (VariableNotBoundException ex) {
            LogFactory.getLog((Class)NodeVar.class).warn((Object)"Failed to eval bound variable");
            throw ex;
        }
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public void format(Query query, IndentedWriter out) {
        out.print('?');
        out.print(this.varNode.getName());
    }

    public int hashCode() {
        return this.varNode.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeVar)) {
            return false;
        }
        NodeVar nvar = (NodeVar)other;
        return this.getVarName().equals(nvar.getVarName());
    }

    public boolean isVariable() {
        return true;
    }

    public String getVarName() {
        return this.varNode.getName();
    }

    public NodeVar getNodeVar() {
        return this;
    }

    public Var asVar() {
        return this.varNode;
    }

    public Node getAsNode() {
        return this.varNode;
    }

    public String toString() {
        return "?" + this.varNode.getName();
    }
}

