/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Calendar;

public class NodeValueDate
extends NodeValue {
    Calendar date;

    public NodeValueDate(Calendar cal) {
        this.date = (Calendar)cal.clone();
        this.date.set(10, 0);
        this.date.set(12, 0);
        this.date.set(13, 0);
        this.date.set(14, 0);
    }

    public NodeValueDate(Calendar cal, Node n) {
        super(n);
        this.date = cal;
    }

    public boolean isDate() {
        return true;
    }

    public Calendar getDate() {
        return this.date;
    }

    protected Node makeNode() {
        String lex = Utils.calendarToXSDDateString(this.date);
        return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDdate);
    }

    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

